/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.xmpp;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.xfire.XFireRuntimeException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XmlPullStreamReader
implements XMLStreamReader {
    private XmlPullParser parser;
    private int current;
    private int startDepth;
    private String local;
    private String namespace;
    private String prefix;

    public XmlPullStreamReader(XmlPullParser parser) {
        this.parser = parser;
        this.startDepth = parser.getDepth();
        try {
            this.current = this.xmlpullToStaxEvent(parser.getEventType());
        }
        catch (XmlPullParserException e) {
            throw new XFireRuntimeException("Couldn't convert to stax event.", e);
        }
    }

    public void close() throws XMLStreamException {
    }

    public int getAttributeCount() {
        return this.parser.getAttributeCount();
    }

    public String getAttributeLocalName(int index) {
        return this.parser.getAttributeName(index);
    }

    public QName getAttributeName(int index) {
        String prefix = this.getAttributePrefix(index);
        if (prefix != null && prefix.length() > 0) {
            return new QName(prefix, this.getAttributeNamespace(index), this.getAttributeLocalName(index));
        }
        return new QName(this.getAttributeNamespace(index), this.getAttributeLocalName(index));
    }

    public String getAttributeNamespace(int index) {
        return this.parser.getAttributeNamespace(index);
    }

    public String getAttributePrefix(int index) {
        return this.parser.getAttributePrefix(index);
    }

    public String getAttributeType(int index) {
        return this.parser.getAttributeType(index);
    }

    public String getAttributeValue(int index) {
        return this.parser.getAttributeValue(index);
    }

    public String getAttributeValue(String ns, String local) {
        return this.parser.getAttributeValue(ns, local);
    }

    public String getCharacterEncodingScheme() {
        return this.parser.getInputEncoding();
    }

    public String getElementText() throws XMLStreamException {
        return this.parser.getText();
    }

    public String getEncoding() {
        return this.parser.getInputEncoding();
    }

    public int getEventType() {
        return this.current;
    }

    public String getLocalName() {
        return this.local;
    }

    public Location getLocation() {
        return null;
    }

    public QName getName() {
        if (this.prefix != null && this.prefix.length() > 0) {
            return new QName(this.namespace, this.local, this.prefix);
        }
        return new QName(this.namespace, this.local);
    }

    public NamespaceContext getNamespaceContext() {
        throw new IllegalStateException();
    }

    public int getNamespaceCount() {
        try {
            return this.parser.getNamespaceCount(this.parser.getDepth());
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
    }

    public String getNamespacePrefix(int index) {
        try {
            return this.parser.getNamespacePrefix(index);
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
    }

    public String getNamespaceURI() {
        return this.namespace;
    }

    public String getNamespaceURI(int index) {
        try {
            return this.parser.getNamespaceUri(index);
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
    }

    public String getNamespaceURI(String prefix) {
        return this.parser.getNamespace(prefix);
    }

    public String getPIData() {
        throw new UnsupportedOperationException();
    }

    public String getPITarget() {
        throw new UnsupportedOperationException();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        return this.parser.getProperty(name);
    }

    public String getText() {
        return this.parser.getText();
    }

    public char[] getTextCharacters() {
        return this.parser.getText().toCharArray();
    }

    public int getTextCharacters(int start, char[] target, int sourceStart, int length) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public int getTextLength() {
        return this.getText().length();
    }

    public int getTextStart() {
        return 0;
    }

    public String getVersion() {
        return null;
    }

    public boolean hasName() {
        return this.current == 1 || this.current == 2;
    }

    public boolean hasNext() throws XMLStreamException {
        return this.current != 8 || this.current != 2 || this.parser.getDepth() != this.startDepth;
    }

    public boolean hasText() {
        return this.current == 4 || this.current == 11 || this.current == 9 || this.current == 5 || this.current == 6;
    }

    public boolean isAttributeSpecified(int index) {
        if (this.current != 1 || this.current != 10) {
            throw new IllegalStateException();
        }
        return true;
    }

    public boolean isCharacters() {
        return this.current == 4;
    }

    public boolean isEndElement() {
        return this.current == 2;
    }

    public boolean isStandalone() {
        return false;
    }

    public boolean isStartElement() {
        return this.current == 1;
    }

    public boolean isWhiteSpace() {
        return this.current == 6;
    }

    public int next() throws XMLStreamException {
        try {
            this.current = this.xmlpullToStaxEvent(this.parser.next());
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            e.printStackTrace();
            throw new XMLStreamException(e);
        }
        return this.current;
    }

    protected int xmlpullToStaxEvent(int xpe) {
        if (xpe == 5) {
            return 12;
        }
        if (xpe == 9) {
            return 5;
        }
        if (xpe == 10) {
            return 5;
        }
        if (xpe == 1) {
            return 8;
        }
        if (xpe == 3) {
            return 2;
        }
        if (xpe == 6) {
            return 15;
        }
        if (xpe == 7) {
            return 6;
        }
        if (xpe == 8) {
            return 3;
        }
        if (xpe == 0) {
            return 7;
        }
        if (xpe == 2) {
            this.local = this.parser.getName();
            this.prefix = this.parser.getPrefix();
            this.namespace = this.parser.getNamespace(this.prefix);
            return 1;
        }
        if (xpe == 4) {
            return 4;
        }
        throw new IllegalStateException("Unknown event type " + xpe);
    }

    public int nextTag() throws XMLStreamException {
        int eventType = this.next();
        while (eventType == 4 && this.isWhiteSpace() || eventType == 12 && this.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
            eventType = this.next();
        }
        if (eventType != 1 && eventType != 2) {
            throw new XMLStreamException("expected start or end tag", this.getLocation());
        }
        return eventType;
    }

    public void require(int index, String ns, String local) throws XMLStreamException {
        if (this.current != index) {
            throw new XMLStreamException("Event type does not match.");
        }
        if (ns != null && !this.getNamespaceURI().equals(ns)) {
            throw new XMLStreamException("Namespace does not match.");
        }
        if (local != null && !this.getLocalName().equals(local)) {
            throw new XMLStreamException("Local name does not match.");
        }
    }

    public boolean standaloneSet() {
        Boolean s = (Boolean)this.getProperty("http://xmlpull.org/v1/doc/features.html#xmldecl-standalone");
        return s != null && s != false;
    }
}

