/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.optionsdialog;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.fife.rtext.optionsdialog.LanguageOptionPanel;
import org.fife.ui.SubstanceUtils;
import org.fife.ui.WebLookAndFeelUtils;

class LanguageListCellRenderer
extends DefaultListCellRenderer {
    private JLabel possibleDelegate;
    private static final String SUBSTANCE_RENDERER_CLASS = "org.fife.rtext.optionsdialog.SubstanceLanguageListCellRenderer";

    private LanguageListCellRenderer(JLabel delegate) {
        this.possibleDelegate = delegate;
    }

    public static ListCellRenderer create() {
        JLabel delegate = null;
        if (SubstanceUtils.isSubstanceInstalled()) {
            try {
                Class<?> clazz = Class.forName(SUBSTANCE_RENDERER_CLASS);
                return (ListCellRenderer)clazz.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (WebLookAndFeelUtils.isWebLookAndFeelInstalled()) {
            delegate = (JLabel)UIManager.get("List.cellRenderer");
        }
        return new LanguageListCellRenderer(delegate);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean focused) {
        JLabel renderer = null;
        if (this.possibleDelegate != null) {
            renderer = this.possibleDelegate;
            ((ListCellRenderer)((Object)this.possibleDelegate)).getListCellRendererComponent(list, value, index, selected, focused);
        } else {
            renderer = this;
            super.getListCellRendererComponent((JList<?>)list, value, index, selected, focused);
        }
        LanguageOptionPanel.IconTextInfo iti = (LanguageOptionPanel.IconTextInfo)value;
        renderer.setIcon(iti.getIcon());
        renderer.setText(iti.getText());
        return renderer;
    }
}

