/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.generate;

import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.cassandra.stress.generate.values.Generator;

public class PartitionGenerator {
    public final double maxRowCount;
    public final double minRowCount;
    final List<Generator> partitionKey;
    final List<Generator> clusteringComponents;
    final List<Generator> valueComponents;
    final int[] clusteringDescendantAverages;
    final int[] clusteringComponentAverages;
    private final Map<String, Integer> indexMap;
    final Order order;

    public PartitionGenerator(List<Generator> partitionKey, List<Generator> clusteringComponents, List<Generator> valueComponents, Order order) {
        int i;
        this.partitionKey = partitionKey;
        this.clusteringComponents = clusteringComponents;
        this.valueComponents = valueComponents;
        this.order = order;
        this.clusteringDescendantAverages = new int[clusteringComponents.size()];
        this.clusteringComponentAverages = new int[clusteringComponents.size()];
        for (i = 0; i < this.clusteringComponentAverages.length; ++i) {
            this.clusteringComponentAverages[i] = (int)clusteringComponents.get((int)i).clusteringDistribution.average();
        }
        for (i = this.clusteringDescendantAverages.length - 1; i >= 0; --i) {
            this.clusteringDescendantAverages[i] = i < this.clusteringDescendantAverages.length - 1 ? this.clusteringComponentAverages[i + 1] * this.clusteringDescendantAverages[i + 1] : 1;
        }
        double maxRowCount = 1.0;
        double minRowCount = 1.0;
        for (Generator component : clusteringComponents) {
            maxRowCount *= (double)component.clusteringDistribution.maxValue();
            minRowCount *= (double)component.clusteringDistribution.minValue();
        }
        this.maxRowCount = maxRowCount;
        this.minRowCount = minRowCount;
        this.indexMap = new HashMap<String, Integer>();
        int i2 = 0;
        for (Generator generator : partitionKey) {
            this.indexMap.put(generator.name, --i2);
        }
        i2 = 0;
        for (Generator generator : Iterables.concat(clusteringComponents, valueComponents)) {
            this.indexMap.put(generator.name, i2++);
        }
    }

    public boolean permitNulls(int index) {
        return index >= 0 && index >= this.clusteringComponents.size();
    }

    public int indexOf(String name) {
        Integer i = this.indexMap.get(name);
        if (i == null) {
            throw new NoSuchElementException();
        }
        return i;
    }

    public ByteBuffer convert(int c, Object v) {
        if (c < 0) {
            return this.partitionKey.get((int)(-1 - c)).type.decompose(v);
        }
        if (c < this.clusteringComponents.size()) {
            return this.clusteringComponents.get((int)c).type.decompose(v);
        }
        return this.valueComponents.get((int)(c - this.clusteringComponents.size())).type.decompose(v);
    }

    public Object convert(int c, ByteBuffer v) {
        if (c < 0) {
            return this.partitionKey.get((int)(-1 - c)).type.compose(v);
        }
        if (c < this.clusteringComponents.size()) {
            return this.clusteringComponents.get((int)c).type.compose(v);
        }
        return this.valueComponents.get((int)(c - this.clusteringComponents.size())).type.compose(v);
    }

    public static enum Order {
        ARBITRARY,
        SHUFFLED,
        SORTED;

    }
}

