/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import java.util.Arrays;
import org.caffinitas.ohc.linked.AbstractDataOutput;
import org.caffinitas.ohc.linked.Hasher;

final class KeyBuffer
extends AbstractDataOutput {
    private final byte[] array;
    private int p;
    private long hash;

    KeyBuffer(int size) {
        this.array = new byte[size];
    }

    byte[] array() {
        return this.array;
    }

    int position() {
        return this.p;
    }

    int size() {
        return this.array.length;
    }

    long hash() {
        return this.hash;
    }

    KeyBuffer finish(Hasher hasher) {
        this.hash = hasher.hash(this.array);
        return this;
    }

    @Override
    public void write(int b) {
        this.array[this.p++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        System.arraycopy(b, off, this.array, this.p, len);
        this.p += len;
    }

    @Override
    public void writeShort(int v) {
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    @Override
    public void writeChar(int v) {
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    @Override
    public void writeInt(int v) {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    @Override
    public void writeLong(long v) {
        this.write((int)(v >>> 56 & 0xFFL));
        this.write((int)(v >>> 48 & 0xFFL));
        this.write((int)(v >>> 40 & 0xFFL));
        this.write((int)(v >>> 32 & 0xFFL));
        this.write((int)(v >>> 24 & 0xFFL));
        this.write((int)(v >>> 16 & 0xFFL));
        this.write((int)(v >>> 8 & 0xFFL));
        this.write((int)(v & 0xFFL));
    }

    @Override
    public void writeFloat(float v) {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyBuffer keyBuffer = (KeyBuffer)o;
        return Arrays.equals(this.array, keyBuffer.array);
    }

    public int hashCode() {
        return (int)this.hash;
    }
}

