/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.logging.jul;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.logging.LoggerInfo;

@SuppressForbidden(reason="class is specific to java.util.logging")
public class JulInfo
extends LoggerInfo {
    private static final Level[] LEVELS = new Level[]{null, Level.FINEST, Level.FINE, Level.CONFIG, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF};
    final Logger logger;

    public JulInfo(String name, Logger logger) {
        super(name);
        this.logger = logger;
    }

    @Override
    public String getLevel() {
        if (this.logger == null) {
            return null;
        }
        Level level = this.logger.getLevel();
        if (level != null) {
            return level.getName();
        }
        for (Level l : LEVELS) {
            if (l == null || !this.logger.isLoggable(l)) continue;
            return l.getName();
        }
        return Level.OFF.getName();
    }

    @Override
    public boolean isSet() {
        return this.logger != null && this.logger.getLevel() != null;
    }
}

