/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.ltr.model.LTRScoringModel;
import org.apache.solr.ltr.model.ModelException;

public class ModelStore {
    private final Map<String, LTRScoringModel> availableModels = new HashMap<String, LTRScoringModel>();

    public synchronized LTRScoringModel getModel(String name) {
        return this.availableModels.get(name);
    }

    public void clear() {
        this.availableModels.clear();
    }

    public List<LTRScoringModel> getModels() {
        ArrayList<LTRScoringModel> availableModelsValues = new ArrayList<LTRScoringModel>(this.availableModels.values());
        return Collections.unmodifiableList(availableModelsValues);
    }

    public String toString() {
        return "ModelStore [availableModels=" + this.availableModels.keySet() + "]";
    }

    public LTRScoringModel delete(String modelName) {
        return this.availableModels.remove(modelName);
    }

    public synchronized void addModel(LTRScoringModel modeldata) throws ModelException {
        String name = modeldata.getName();
        if (this.availableModels.containsKey(name)) {
            throw new ModelException("model '" + name + "' already exists. Please use a different name");
        }
        this.availableModels.put(modeldata.getName(), modeldata);
    }
}

