/*
 * Decompiled with CFR 0.152.
 */
package phase;

import phase.CodedSteps;
import phase.LowFreqPbwtPhaseIbs;
import phase.PhaseData;
import vcf.XRefGT;

public final class LowFreqPhaseIbs {
    private final PhaseData phaseData;
    private final XRefGT allHaps;
    private final LowFreqPbwtPhaseIbs fwdPhaseIbs;
    private final LowFreqPbwtPhaseIbs bwdPhaseIbs;

    public LowFreqPhaseIbs(PhaseData phaseData) {
        CodedSteps codedSteps = phaseData.codedSteps();
        this.phaseData = phaseData;
        this.allHaps = codedSteps.allHaps();
        this.fwdPhaseIbs = new LowFreqPbwtPhaseIbs(phaseData, codedSteps, false);
        this.bwdPhaseIbs = new LowFreqPbwtPhaseIbs(phaseData, codedSteps, true);
    }

    public PhaseData phaseData() {
        return this.phaseData;
    }

    public XRefGT allHaps() {
        return this.allHaps;
    }

    public int fwdIbsHap(int n, int n2) {
        return this.fwdPhaseIbs.ibsHap(n, n2);
    }

    public int bwdIbsHap(int n, int n2) {
        return this.bwdPhaseIbs.ibsHap(n, n2);
    }
}

