/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class DeleteKeyPair
extends BaseCmd {
    public DeleteKeyPair(String[] args) {
        super("ec2delkey", "ec2-delete-keypair");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        return new Options();
    }

    protected String getOptionString() {
        return "KEY";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Delete an existing keypair");
        System.out.println("     The KEY parameter specifies the name of the keypair to delete.");
    }

    public void printOptions() {
        super.printOptions();
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("KEY");
        String keyName = this.getNonOptions()[0];
        this.warnIfTooManyNonOptions();
        RequestResultPair rsp = jec2.deleteKeyPair(keyName);
        if (((Boolean)rsp.getResponse()).booleanValue()) {
            out.outputKeyID(System.out, keyName);
            out.printRequestId(System.out, (RequestResult)rsp);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        new DeleteKeyPair(args).invoke();
    }
}

