/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.multi.event;

import org.jets3t.service.model.StorageObject;
import org.jets3t.service.multi.ThreadWatcher;
import org.jets3t.service.multi.event.ServiceEvent;

public class UpdateACLEvent
extends ServiceEvent {
    private StorageObject[] objects = null;

    private UpdateACLEvent(int eventCode, Object uniqueOperationId) {
        super(eventCode, uniqueOperationId);
    }

    public static UpdateACLEvent newErrorEvent(Throwable t, Object uniqueOperationId) {
        UpdateACLEvent event = new UpdateACLEvent(0, uniqueOperationId);
        event.setErrorCause(t);
        return event;
    }

    public static UpdateACLEvent newStartedEvent(ThreadWatcher threadWatcher, Object uniqueOperationId) {
        UpdateACLEvent event = new UpdateACLEvent(1, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static UpdateACLEvent newInProgressEvent(ThreadWatcher threadWatcher, StorageObject[] completedObjects, Object uniqueOperationId) {
        UpdateACLEvent event = new UpdateACLEvent(3, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        event.setObjects(completedObjects);
        return event;
    }

    public static UpdateACLEvent newCompletedEvent(Object uniqueOperationId) {
        UpdateACLEvent event = new UpdateACLEvent(2, uniqueOperationId);
        return event;
    }

    public static UpdateACLEvent newCancelledEvent(StorageObject[] incompletedObjects, Object uniqueOperationId) {
        UpdateACLEvent event = new UpdateACLEvent(4, uniqueOperationId);
        event.setObjects(incompletedObjects);
        return event;
    }

    public static UpdateACLEvent newIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors, Object uniqueOperationId) {
        UpdateACLEvent event = new UpdateACLEvent(5, uniqueOperationId);
        event.setIgnoredErrors(ignoredErrors);
        return event;
    }

    private void setObjects(StorageObject[] objects) {
        this.objects = objects;
    }

    public StorageObject[] getObjectsWithUpdatedACL() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Completed Objects are only available from EVENT_IN_PROGRESS events");
        }
        return this.objects;
    }

    public StorageObject[] getCancelledObjects() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled Objects are  only available from EVENT_CANCELLED events");
        }
        return this.objects;
    }
}

