/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.demos.perspective;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import org.flexdock.demos.util.DemoUtility;
import org.flexdock.docking.DockableFactory;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.drag.effects.EffectsManager;
import org.flexdock.docking.drag.preview.GhostPreview;
import org.flexdock.docking.state.PersistenceException;
import org.flexdock.perspective.LayoutSequence;
import org.flexdock.perspective.Perspective;
import org.flexdock.perspective.PerspectiveFactory;
import org.flexdock.perspective.PerspectiveManager;
import org.flexdock.perspective.actions.OpenPerspectiveAction;
import org.flexdock.perspective.persist.FilePersistenceHandler;
import org.flexdock.perspective.persist.Persister;
import org.flexdock.perspective.persist.xml.XMLPersister;
import org.flexdock.util.SwingUtility;
import org.flexdock.view.View;
import org.flexdock.view.Viewport;
import org.flexdock.view.actions.DefaultDisplayAction;

public class XMLPerspectivesDemo
extends JFrame
implements DockingConstants {
    public static final String PERSPECTIVE_FILE = "PerspectiveDemo.xml";
    private static final String MAIN_VIEW = "main.view";
    private static final String BIRD_VIEW = "bird.view";
    private static final String MESSAGE_VIEW = "message.log";
    private static final String PROBLEM_VIEW = "problem";
    private static final String CONSOLE_VIEW = "console";
    private static final String P1 = "p1";

    public static void main(String[] args) {
        SwingUtility.setPlaf(UIManager.getSystemLookAndFeelClassName());
        XMLPerspectivesDemo.configureDocking();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                XMLPerspectivesDemo.runGUI();
            }
        });
    }

    private static void runGUI() {
        XMLPerspectivesDemo flexDockDemo = new XMLPerspectivesDemo();
        flexDockDemo.setSize(800, 600);
        SwingUtility.centerOnScreen(flexDockDemo);
        DemoUtility.setCloseOperation(flexDockDemo);
        DockingManager.restoreLayout();
        flexDockDemo.setVisible(true);
    }

    public XMLPerspectivesDemo() {
        super("FlexDock Demo");
        this.setContentPane(this.createContentPane());
        this.setJMenuBar(this.createApplicationMenuBar());
    }

    private JPanel createContentPane() {
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Viewport viewport = new Viewport();
        contentPane.add((Component)viewport, "Center");
        return contentPane;
    }

    private JMenuBar createApplicationMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu showViewMenu = new JMenu("Show View");
        showViewMenu.add(new DefaultDisplayAction(BIRD_VIEW));
        showViewMenu.add(new DefaultDisplayAction(MESSAGE_VIEW));
        showViewMenu.add(new DefaultDisplayAction(PROBLEM_VIEW));
        showViewMenu.add(new DefaultDisplayAction(CONSOLE_VIEW));
        JMenu perspectiveMenu = new JMenu("Perspective");
        perspectiveMenu.add(new OpenPerspectiveAction(P1));
        menuBar.add(showViewMenu);
        menuBar.add(perspectiveMenu);
        return menuBar;
    }

    private static void configureDocking() {
        DockingManager.setDockableFactory(new ViewFactory());
        DockingManager.setFloatingEnabled(true);
        EffectsManager.setPreview(new GhostPreview());
        PerspectiveManager.setFactory(new DemoPerspectiveFactory());
        PerspectiveManager.setRestoreFloatingOnLoad(true);
        PerspectiveManager mgr = PerspectiveManager.getInstance();
        FilePersistenceHandler persister = new FilePersistenceHandler(new File(FilePersistenceHandler.DEFAULT_PERSPECTIVE_DIR, PERSPECTIVE_FILE), (Persister)XMLPersister.newDefaultInstance());
        PerspectiveManager.setPersistenceHandler(persister);
        try {
            DockingManager.loadLayoutModel();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (PersistenceException ex) {
            ex.printStackTrace();
        }
        DockingManager.setAutoPersist(true);
    }

    private static class ViewFactory
    extends DockableFactory.Stub {
        private ViewFactory() {
        }

        public Component getDockableComponent(String dockableId) {
            if (XMLPerspectivesDemo.MAIN_VIEW.equals(dockableId)) {
                return ViewFactory.createMainView();
            }
            if (XMLPerspectivesDemo.BIRD_VIEW.equals(dockableId)) {
                return this.createView(XMLPerspectivesDemo.BIRD_VIEW, "Bird View");
            }
            if (XMLPerspectivesDemo.MESSAGE_VIEW.equals(dockableId)) {
                return this.createView(XMLPerspectivesDemo.MESSAGE_VIEW, "Message Log");
            }
            if (XMLPerspectivesDemo.PROBLEM_VIEW.equals(dockableId)) {
                return this.createView(XMLPerspectivesDemo.PROBLEM_VIEW, "Problems");
            }
            if (XMLPerspectivesDemo.CONSOLE_VIEW.equals(dockableId)) {
                return this.createView(XMLPerspectivesDemo.CONSOLE_VIEW, "Console");
            }
            return null;
        }

        private View createView(String id, String text) {
            View view = new View(id, text);
            view.addAction("close");
            view.addAction("pin");
            JPanel panel = new JPanel();
            panel.setBorder(new LineBorder(Color.GRAY, 1));
            JTextField textField = new JTextField(text);
            textField.setPreferredSize(new Dimension(100, 20));
            panel.add(textField);
            view.setContentPane(panel);
            return view;
        }

        private static View createMainView() {
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.addTab("Sample1", new JTextArea("Sample1"));
            tabbedPane.addTab("Sample2", new JTextArea("Sample2"));
            tabbedPane.addTab("Sample3", new JTextArea("Sample3"));
            View mainView = new View(XMLPerspectivesDemo.MAIN_VIEW, null, null);
            mainView.setTerritoryBlocked("CENTER", true);
            mainView.setTitlebar(null);
            mainView.setContentPane(new JScrollPane(tabbedPane));
            return mainView;
        }
    }

    private static class DemoPerspectiveFactory
    implements PerspectiveFactory {
        private DemoPerspectiveFactory() {
        }

        public Perspective getPerspective(String persistentId) {
            if (XMLPerspectivesDemo.P1.equals(persistentId)) {
                return this.createPerspective1();
            }
            return null;
        }

        private Perspective createPerspective1() {
            Perspective perspective = new Perspective(XMLPerspectivesDemo.P1, "Perspective1");
            LayoutSequence sequence = perspective.getInitialSequence(true);
            sequence.add(XMLPerspectivesDemo.MAIN_VIEW);
            sequence.add(XMLPerspectivesDemo.BIRD_VIEW, XMLPerspectivesDemo.MAIN_VIEW, "EAST", 0.3f);
            sequence.add(XMLPerspectivesDemo.MESSAGE_VIEW, XMLPerspectivesDemo.MAIN_VIEW, "WEST", 0.3f);
            sequence.add(XMLPerspectivesDemo.PROBLEM_VIEW, XMLPerspectivesDemo.MESSAGE_VIEW);
            sequence.add(XMLPerspectivesDemo.CONSOLE_VIEW, XMLPerspectivesDemo.MESSAGE_VIEW);
            return perspective;
        }
    }
}

