/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework;

import com.google.common.collect.Lists;
import com.intellij.javascript.testFramework.AbstractTestFileStructureBuilder;
import com.intellij.javascript.testFramework.JsTestFileStructureBuilderProvider;
import com.intellij.javascript.testFramework.TestFileStructurePack;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestFileStructureManager {
    private static final Logger LOG = Logger.getInstance(TestFileStructureManager.class);
    private static final Key<CachedValue<TestFileStructurePack>> TEST_FILE_STRUCTURE_REGISTRY_KEY = Key.create((String)TestFileStructurePack.class.getName());

    private TestFileStructureManager() {
    }

    @Nullable
    public static TestFileStructurePack fetchTestFileStructurePackByJsFile(JSFile jsFile) {
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)jsFile.getProject());
        return (TestFileStructurePack)cachedValuesManager.getCachedValue((UserDataHolder)jsFile, TEST_FILE_STRUCTURE_REGISTRY_KEY, () -> {
            TestFileStructurePack pack = TestFileStructureManager.createTestFileStructurePack(jsFile);
            return CachedValueProvider.Result.create((Object)pack, (Object[])new Object[]{jsFile});
        }, false);
    }

    @NotNull
    private static TestFileStructurePack createTestFileStructurePack(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            TestFileStructureManager.$$$reportNull$$$0(0);
        }
        long startTimeNano = System.nanoTime();
        JsTestFileStructureBuilderProvider[] providers = (JsTestFileStructureBuilderProvider[])JsTestFileStructureBuilderProvider.EP_NAME.getExtensions();
        ArrayList fileStructures = Lists.newArrayListWithExpectedSize((int)providers.length);
        for (JsTestFileStructureBuilderProvider provider : providers) {
            AbstractTestFileStructureBuilder builder = provider.getTestFileStructureBuilder();
            Object testFileStructure = builder.fetchCachedTestFileStructure(jsFile);
            fileStructures.add(testFileStructure);
        }
        long durationNano = System.nanoTime() - startTimeNano;
        if (durationNano > 50000000L) {
            String message = String.format("JsTestDriver: Creating TestFileStructurePack for %s took %.2f ms", jsFile.getName(), (double)durationNano / 1000000.0);
            LOG.info(message);
        }
        TestFileStructurePack testFileStructurePack = new TestFileStructurePack(fileStructures);
        if (testFileStructurePack == null) {
            TestFileStructureManager.$$$reportNull$$$0(1);
        }
        return testFileStructurePack;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/TestFileStructureManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/TestFileStructureManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestFileStructurePack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTestFileStructurePack";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

