/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.dvcs.MultiRootMessage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.commands.GitAuthenticationListener;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitFetchResult;
import git4idea.util.GitUIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class GitFetcher {
    private static final Logger LOG = Logger.getInstance(GitFetcher.class);
    private final Project myProject;
    private final GitRepositoryManager myRepositoryManager;
    private final ProgressIndicator myProgressIndicator;
    private final boolean myFetchAll;
    private final GitVcs myVcs;
    private final Collection<Exception> myErrors;

    public GitFetcher(@NotNull Project project, @NotNull ProgressIndicator progressIndicator, boolean fetchAll) {
        if (project == null) {
            GitFetcher.$$$reportNull$$$0(0);
        }
        if (progressIndicator == null) {
            GitFetcher.$$$reportNull$$$0(1);
        }
        this.myErrors = new ArrayList<Exception>();
        this.myProject = project;
        this.myProgressIndicator = progressIndicator;
        this.myFetchAll = fetchAll;
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.myVcs = GitVcs.getInstance(project);
    }

    @Deprecated
    public GitFetchResult fetch(@NotNull GitRepository repository) {
        if (repository == null) {
            GitFetcher.$$$reportNull$$$0(2);
        }
        GitFetchResult fetchResult = this.myFetchAll ? GitFetcher.fetchAll(repository) : this.fetchCurrentRemote(repository);
        repository.update();
        repository.getRepositoryFiles().refreshTagsFiles();
        return fetchResult;
    }

    @Deprecated
    @NotNull
    public GitFetchResult fetch(@NotNull VirtualFile root, @NotNull String remoteName, @Nullable String branch) {
        GitRepository repository;
        if (root == null) {
            GitFetcher.$$$reportNull$$$0(3);
        }
        if (remoteName == null) {
            GitFetcher.$$$reportNull$$$0(4);
        }
        if ((repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root)) == null) {
            GitFetchResult gitFetchResult = GitFetcher.logError("Repository can't be null for " + root, ((Object)((Object)this.myRepositoryManager)).toString());
            if (gitFetchResult == null) {
                GitFetcher.$$$reportNull$$$0(5);
            }
            return gitFetchResult;
        }
        GitRemote remote = GitUtil.findRemoteByName(repository, remoteName);
        if (remote == null) {
            GitFetchResult gitFetchResult = GitFetcher.logError("Couldn't find remote with the name " + remoteName, null);
            if (gitFetchResult == null) {
                GitFetcher.$$$reportNull$$$0(6);
            }
            return gitFetchResult;
        }
        GitFetchResult gitFetchResult = this.fetchRemote(repository, remote, branch);
        if (gitFetchResult == null) {
            GitFetcher.$$$reportNull$$$0(7);
        }
        return gitFetchResult;
    }

    private static GitFetchResult logError(@NotNull String message, @Nullable String additionalInfo) {
        if (message == null) {
            GitFetcher.$$$reportNull$$$0(8);
        }
        String addInfo = additionalInfo != null ? "\n" + additionalInfo : "";
        LOG.error(message + addInfo);
        return GitFetchResult.error(message);
    }

    @NotNull
    private GitFetchResult fetchCurrentRemote(@NotNull GitRepository repository) {
        FetchParams fetchParams;
        if (repository == null) {
            GitFetcher.$$$reportNull$$$0(9);
        }
        if ((fetchParams = GitFetcher.getFetchParams(repository)).isError()) {
            GitFetchResult gitFetchResult = fetchParams.getError();
            if (gitFetchResult == null) {
                GitFetcher.$$$reportNull$$$0(10);
            }
            return gitFetchResult;
        }
        GitRemote remote = fetchParams.getRemote();
        GitFetchResult gitFetchResult = this.fetchRemote(repository, remote, null);
        if (gitFetchResult == null) {
            GitFetcher.$$$reportNull$$$0(11);
        }
        return gitFetchResult;
    }

    @NotNull
    private GitFetchResult fetchRemote(@NotNull GitRepository repository, @NotNull GitRemote remote, @Nullable String branch) {
        if (repository == null) {
            GitFetcher.$$$reportNull$$$0(12);
        }
        if (remote == null) {
            GitFetcher.$$$reportNull$$$0(13);
        }
        GitFetchResult gitFetchResult = GitFetcher.fetchNatively(repository, remote, branch);
        if (gitFetchResult == null) {
            GitFetcher.$$$reportNull$$$0(14);
        }
        return gitFetchResult;
    }

    @NotNull
    private GitFetchResult fetchCurrentBranch(@NotNull GitRepository repository) {
        FetchParams fetchParams;
        if (repository == null) {
            GitFetcher.$$$reportNull$$$0(15);
        }
        if ((fetchParams = GitFetcher.getFetchParams(repository)).isError()) {
            GitFetchResult gitFetchResult = fetchParams.getError();
            if (gitFetchResult == null) {
                GitFetcher.$$$reportNull$$$0(16);
            }
            return gitFetchResult;
        }
        GitRemote remote = fetchParams.getRemote();
        String remoteBranch = fetchParams.getRemoteBranch().getNameForRemoteOperations();
        GitFetchResult gitFetchResult = GitFetcher.fetchNatively(repository, remote, remoteBranch);
        if (gitFetchResult == null) {
            GitFetcher.$$$reportNull$$$0(17);
        }
        return gitFetchResult;
    }

    @NotNull
    private static FetchParams getFetchParams(@NotNull GitRepository repository) {
        GitLocalBranch currentBranch;
        if (repository == null) {
            GitFetcher.$$$reportNull$$$0(18);
        }
        if ((currentBranch = repository.getCurrentBranch()) == null) {
            String message = "Current branch can't be null here. \nRepository: " + repository;
            LOG.error(message);
            FetchParams fetchParams = new FetchParams(GitFetchResult.error(new Exception(message)));
            if (fetchParams == null) {
                GitFetcher.$$$reportNull$$$0(19);
            }
            return fetchParams;
        }
        GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch(repository, currentBranch);
        if (trackInfo == null) {
            String message = "Tracked info is null for branch " + currentBranch + "\n Repository: " + repository;
            LOG.error(message);
            FetchParams fetchParams = new FetchParams(GitFetchResult.error(new Exception(message)));
            if (fetchParams == null) {
                GitFetcher.$$$reportNull$$$0(20);
            }
            return fetchParams;
        }
        GitRemote remote = trackInfo.getRemote();
        FetchParams fetchParams = new FetchParams(remote, trackInfo.getRemoteBranch());
        if (fetchParams == null) {
            GitFetcher.$$$reportNull$$$0(21);
        }
        return fetchParams;
    }

    @NotNull
    private static GitFetchResult fetchAll(@NotNull GitRepository repository) {
        if (repository == null) {
            GitFetcher.$$$reportNull$$$0(22);
        }
        GitFetchResult fetchResult = GitFetchResult.success();
        for (GitRemote remote : repository.getRemotes()) {
            String url = remote.getFirstUrl();
            if (url == null) {
                LOG.error("URL is null for remote " + remote.getName());
                continue;
            }
            GitFetchResult res = GitFetcher.fetchNatively(repository, remote, null);
            res.addPruneInfo(fetchResult.getPrunedRefs());
            fetchResult = res;
            if (fetchResult.isSuccess()) continue;
            break;
        }
        GitFetchResult gitFetchResult = fetchResult;
        if (gitFetchResult == null) {
            GitFetcher.$$$reportNull$$$0(23);
        }
        return gitFetchResult;
    }

    @NotNull
    private static GitFetchResult fetchNatively(@NotNull GitRepository repository, @NotNull GitRemote remote, @Nullable String branch) {
        GitFetchResult fetchResult;
        String[] stringArray;
        if (repository == null) {
            GitFetcher.$$$reportNull$$$0(24);
        }
        if (remote == null) {
            GitFetcher.$$$reportNull$$$0(25);
        }
        Git git = Git.getInstance();
        if (branch != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = GitFetcher.getFetchSpecForBranch(branch, remote.getName());
        } else {
            stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] additionalParams = stringArray;
        GitFetchPruneDetector pruneDetector = new GitFetchPruneDetector();
        GitCommandResult result2 = git.fetch(repository, remote, Collections.singletonList(pruneDetector), additionalParams);
        if (result2.success()) {
            ((GitAuthenticationListener)BackgroundTaskUtil.syncPublisher((Project)repository.getProject(), GitAuthenticationListener.GIT_AUTHENTICATION_SUCCESS)).authenticationSucceeded(repository, remote);
            fetchResult = GitFetchResult.success();
        } else {
            fetchResult = result2.cancelled() ? GitFetchResult.cancel() : GitFetchResult.error(result2.getErrorOutputAsJoinedString());
        }
        fetchResult.addPruneInfo(pruneDetector.getPrunedRefs());
        GitFetchResult gitFetchResult = fetchResult;
        if (gitFetchResult == null) {
            GitFetcher.$$$reportNull$$$0(26);
        }
        return gitFetchResult;
    }

    private static String getRidOfPrefixIfExists(String branch) {
        if (branch.startsWith("refs/heads/")) {
            return branch.substring("refs/heads/".length());
        }
        return branch;
    }

    @NotNull
    private static String getFetchSpecForBranch(@NotNull String branch, @NotNull String remoteName) {
        if (branch == null) {
            GitFetcher.$$$reportNull$$$0(27);
        }
        if (remoteName == null) {
            GitFetcher.$$$reportNull$$$0(28);
        }
        branch = GitFetcher.getRidOfPrefixIfExists(branch);
        String string = "refs/heads/" + branch + ":" + "refs/remotes/" + remoteName + "/" + branch;
        if (string == null) {
            GitFetcher.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public Collection<Exception> getErrors() {
        Collection<Exception> collection = this.myErrors;
        if (collection == null) {
            GitFetcher.$$$reportNull$$$0(30);
        }
        return collection;
    }

    public static void displayFetchResult(@NotNull Project project, @NotNull GitFetchResult result2, @Nullable String errorNotificationTitle, @NotNull Collection<? extends Exception> errors) {
        if (project == null) {
            GitFetcher.$$$reportNull$$$0(31);
        }
        if (result2 == null) {
            GitFetcher.$$$reportNull$$$0(32);
        }
        if (errors == null) {
            GitFetcher.$$$reportNull$$$0(33);
        }
        if (result2.isSuccess()) {
            VcsNotifier.getInstance((Project)project).notifySuccess("Fetched successfully" + result2.getAdditionalInfo());
        } else if (result2.isCancelled()) {
            VcsNotifier.getInstance((Project)project).notifyMinorWarning("", "Fetch cancelled by user" + result2.getAdditionalInfo());
        } else if (result2.isNotAuthorized()) {
            String description;
            String title;
            if (errorNotificationTitle != null) {
                title = errorNotificationTitle;
                description = "Fetch failed: couldn't authorize";
            } else {
                title = "Fetch failed";
                description = "Couldn't authorize";
            }
            description = description + result2.getAdditionalInfo();
            GitUIUtil.notifyMessage(project, title, description, true, null);
        } else {
            GitUIUtil.notifyMessage(project, "Fetch failed", result2.getAdditionalInfo(), true, errors);
        }
    }

    @Deprecated
    public boolean fetchRootsAndNotify(@NotNull Collection<GitRepository> roots, @Nullable String errorNotificationTitle, boolean notifySuccess2) {
        if (roots == null) {
            GitFetcher.$$$reportNull$$$0(34);
        }
        MultiRootMessage additionalInfo = new MultiRootMessage(this.myProject, GitUtil.getRootsFromRepositories(roots), false, true);
        for (GitRepository repository : roots) {
            LOG.info("fetching " + repository);
            GitFetchResult result2 = this.fetch(repository);
            String ai = result2.getAdditionalInfo();
            if (!StringUtil.isEmptyOrSpaces((String)ai)) {
                additionalInfo.append((Object)repository.getRoot(), ai);
            }
            if (result2.isSuccess()) continue;
            ArrayList<Exception> errors = new ArrayList<Exception>(this.getErrors());
            errors.addAll(result2.getErrors());
            GitFetcher.displayFetchResult(this.myProject, result2, errorNotificationTitle, errors);
            return false;
        }
        if (notifySuccess2) {
            VcsNotifier.getInstance((Project)this.myProject).notifySuccess("Fetched successfully");
        }
        if (!additionalInfo.asString().isEmpty()) {
            VcsNotifier.getInstance((Project)this.myProject).notifyMinorInfo("Fetch details", additionalInfo.asString());
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 2: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/update/GitFetcher";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 13: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/update/GitFetcher";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fetch";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchCurrentRemote";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchRemote";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchCurrentBranch";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFetchParams";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchAll";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchNatively";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getFetchSpecForBranch";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fetch";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 29: 
            case 30: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "logError";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fetchCurrentRemote";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fetchRemote";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fetchCurrentBranch";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFetchParams";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "fetchAll";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fetchNatively";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getFetchSpecForBranch";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "displayFetchResult";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "fetchRootsAndNotify";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FetchParams {
        private GitRemote myRemote;
        private GitRemoteBranch myRemoteBranch;
        private GitFetchResult myError;

        FetchParams(GitFetchResult error) {
            this.myError = error;
        }

        FetchParams(GitRemote remote, GitRemoteBranch remoteBranch) {
            this.myRemote = remote;
            this.myRemoteBranch = remoteBranch;
        }

        boolean isError() {
            return this.myError != null;
        }

        public GitFetchResult getError() {
            return this.myError;
        }

        public GitRemote getRemote() {
            return this.myRemote;
        }

        public GitRemoteBranch getRemoteBranch() {
            return this.myRemoteBranch;
        }
    }

    private static class GitFetchPruneDetector
    implements GitLineHandlerListener {
        private static final Pattern PRUNE_PATTERN = Pattern.compile("\\s*x\\s*\\[deleted\\].*->\\s*(\\S*)");
        @NotNull
        private final Collection<String> myPrunedRefs = new ArrayList<String>();

        private GitFetchPruneDetector() {
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            Matcher matcher = PRUNE_PATTERN.matcher(line);
            if (matcher.matches()) {
                this.myPrunedRefs.add(matcher.group(1));
            }
        }

        @NotNull
        public Collection<String> getPrunedRefs() {
            Collection<String> collection = this.myPrunedRefs;
            if (collection == null) {
                GitFetchPruneDetector.$$$reportNull$$$0(0);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetcher$GitFetchPruneDetector", "getPrunedRefs"));
        }
    }
}

