/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deploymentSource;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.agent.DockerUtil;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import icons.DockerIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerImageDeploymentSourceType
extends DockerSingletonDeploymentSourceType {
    static final String ID = "docker-image";

    public static DockerImageDeploymentSourceType getInstance() {
        return (DockerImageDeploymentSourceType)DockerImageDeploymentSourceType.findExtension(DockerImageDeploymentSourceType.class);
    }

    public DockerImageDeploymentSourceType() {
        super(ID, DockerBundle.getText("DockerImageDeploymentSourceType.name", new Object[0]), DockerIcons.SingleImage);
    }

    @Override
    @NotNull
    public String getPresentableDeploymentName(@NotNull DockerDeploymentConfiguration configuration, @Nullable DockerApplicationRuntime runtime) {
        if (configuration == null) {
            DockerImageDeploymentSourceType.$$$reportNull$$$0(0);
        }
        String namePiece = DockerImageDeploymentSourceType.getPresentableContainerNamePiece(configuration, runtime);
        if (runtime != null) {
            String string = namePiece;
            if (string == null) {
                DockerImageDeploymentSourceType.$$$reportNull$$$0(1);
            }
            return string;
        }
        String shortTag = DockerUtil.shortedId((String)configuration.getImageTag());
        String string = DockerBundle.getText("DockerImageDeploymentSourceType.deploymentName", namePiece, shortTag);
        if (string == null) {
            DockerImageDeploymentSourceType.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public String suggestConfigurationName(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            DockerImageDeploymentSourceType.$$$reportNull$$$0(3);
        }
        return DockerBundle.getText("DockerImageDeploymentSourceType.suggestRunConfigurationName", new Object[0]);
    }

    @Override
    public void checkDeploymentConfiguration(@NotNull Project project, @NotNull DockerDeploymentConfiguration configuration) throws RuntimeConfigurationException {
        if (project == null) {
            DockerImageDeploymentSourceType.$$$reportNull$$$0(4);
        }
        if (configuration == null) {
            DockerImageDeploymentSourceType.$$$reportNull$$$0(5);
        }
        super.checkDeploymentConfiguration(project, configuration);
        if (StringUtil.isEmpty((String)configuration.getImageTag())) {
            throw new RuntimeConfigurationError(DockerBundle.getText("DockerImageDeploymentSourceType.error.image.id.required", new Object[0]));
        }
        DockerImageDeploymentSourceType.checkImageTagFormat(configuration);
        DockerImageDeploymentSourceType.checkContainerNameFormat(configuration);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/deploymentSource/DockerImageDeploymentSourceType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/deploymentSource/DockerImageDeploymentSourceType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableDeploymentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableDeploymentName";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "suggestConfigurationName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkDeploymentConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

