/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.calculation;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.util.Consumer;
import com.intellij.util.Parent;
import com.jetbrains.nodejs.run.profile.cpu.CallHolder;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLineFileDescriptor;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8ProfileLine
implements CallHolder,
Parent<V8ProfileLine> {
    private int myTotalTicks;
    private int myTotalTensPercent;
    private int mySelfTicks;
    private int mySelfTensPercent;
    private final V8CpuLogCall myCall;
    @Nullable
    private final V8ProfileLine myParent;
    private final List<V8ProfileLine> myChildren;
    private final int myOffset;
    private int myRecursionCount;
    private static final int INHERITANCE_STEP = 2;

    public V8ProfileLine(int totalTicks, int totalTensPercent, int selfTicks, int selfTensPercent, @Nullable V8ProfileLine parent, int offset, V8CpuLogCall call) {
        this.myTotalTicks = totalTicks;
        this.myTotalTensPercent = totalTensPercent;
        this.mySelfTicks = selfTicks;
        this.mySelfTensPercent = selfTensPercent;
        this.myParent = parent;
        this.myOffset = offset;
        this.myChildren = new ArrayList<V8ProfileLine>();
        this.myCall = call;
    }

    public V8ProfileLine(int totalTicks, int totalTensPercent, int selfTicks, int selfTensPercent, @Nullable V8ProfileLine parent, int offset, String text, long stringId) {
        this(totalTicks, totalTensPercent, selfTicks, selfTensPercent, parent, offset, V8CpuLogCall.create(text, stringId));
    }

    public V8ProfileLine cloneWithoutChildren(@Nullable V8ProfileLine parent) {
        V8ProfileLine copy = new V8ProfileLine(this.getTotalTicks(), this.getTotalTensPercent(), this.getSelfTicks(), this.getSelfTensPercent(), parent, this.getOffset(), this.myCall.cloneMe());
        copy.setPresentation(this.myCall.getPresentation());
        if (parent != null) {
            parent.myChildren.add(copy);
        }
        return copy;
    }

    @Override
    public V8CpuLogCall getCall() {
        return this.myCall;
    }

    public void setTotalTicks(int totalTicks) {
        this.myTotalTicks = totalTicks;
    }

    public void setTotalTensPercent(int totalTensPercent) {
        this.myTotalTensPercent = totalTensPercent;
    }

    public void setSelfTicks(int selfTicks) {
        this.mySelfTicks = selfTicks;
    }

    public void setSelfTensPercent(int selfTensPercent) {
        this.mySelfTensPercent = selfTensPercent;
    }

    public void setIsInternal(boolean value) {
        this.myCall.setNotNavigatable(value);
    }

    public boolean isInternal() {
        return this.myCall.isNative() || this.myCall.isNotNavigatable();
    }

    public Navigatable[] getNavigatables(Project project) {
        if (this.myCall.getDescriptor() == null) {
            return null;
        }
        return this.myCall.getDescriptor().getNavigatables(project, this.myCall.getFunctionName(), this.myCall.isNative());
    }

    public boolean isLocalCode() {
        return this.myCall.isLocal();
    }

    public String toString() {
        return this.myCall.getPresentation();
    }

    public void setPresentation(String presentation) {
        this.myCall.setPresentation(presentation);
    }

    public String getPresentation(boolean fullPath) {
        return this.myCall.getPresentation(fullPath);
    }

    private static V8ProfileLine createLineOld(Parser parser, int offset, @Nullable V8ProfileLine parent) {
        V8ProfileLine line = new V8ProfileLine(parser.getTotalTicks(), parser.getTotalTensPercent(), parser.getSelfTicks(), parser.getSelfTensPercent(), parent, offset, parser.getCallText(), 0L);
        if (parent != null) {
            parent.myChildren.add(line);
        }
        return line;
    }

    public static V8ProfileLine createLine(@NotNull String text, @Nullable V8ProfileLine parent, long stringId) {
        if (text == null) {
            V8ProfileLine.$$$reportNull$$$0(0);
        }
        Parser parser = new Parser(text);
        parser.parse();
        V8ProfileLine line = new V8ProfileLine(0, 0, 0, 0, parent, 0, parser.getCallText(), stringId);
        if (parent != null) {
            parent.myChildren.add(line);
        }
        return line;
    }

    public int getTotalTicks() {
        return this.myTotalTicks;
    }

    public int getTotalTensPercent() {
        return this.myTotalTensPercent;
    }

    public int getSelfTicks() {
        return this.mySelfTicks;
    }

    public int getSelfTensPercent() {
        return this.mySelfTensPercent;
    }

    public ExecKind getExecKind() {
        return this.myCall.getExecKind();
    }

    public String getFunctionName() {
        return this.myCall.getFunctionName();
    }

    public boolean isNative() {
        return this.myCall.isNative();
    }

    @Nullable
    public V8ProfileLine getParent() {
        return this.myParent;
    }

    public List<V8ProfileLine> getChildren() {
        return this.myChildren;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public V8ProfileLineFileDescriptor getFileDescriptor() {
        return this.myCall.getDescriptor();
    }

    public String getNotParsedCallable() {
        return this.myCall.getNotParsedCallable();
    }

    public int getRecursionCount() {
        return this.myRecursionCount;
    }

    public void setRecursionCount(int recursionCount) {
        this.myRecursionCount = recursionCount;
    }

    public static void dfs(V8ProfileLine root, Consumer<? super V8ProfileLine> consumer) {
        ArrayDeque<V8ProfileLine> queue = new ArrayDeque<V8ProfileLine>();
        queue.addFirst(root);
        while (!queue.isEmpty()) {
            V8ProfileLine line = (V8ProfileLine)queue.removeFirst();
            consumer.consume((Object)line);
            List<V8ProfileLine> children = line.getChildren();
            for (int i = children.size() - 1; i >= 0; --i) {
                queue.addFirst(children.get(i));
            }
        }
    }

    private static Integer parseInt(@NotNull String s) {
        if (s == null) {
            V8ProfileLine.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmptyOrSpaces((String)s)) {
            return null;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Integer parseTensPercent(@NotNull String s) {
        if (s == null) {
            V8ProfileLine.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmptyOrSpaces((String)s)) {
            return null;
        }
        if (!s.endsWith("%")) {
            return null;
        }
        int dot = (s = s.substring(0, s.length() - 1)).indexOf(46);
        if (dot < 0) {
            Integer integer = V8ProfileLine.parseInt(s);
            return integer == null ? null : Integer.valueOf(integer * 10);
        }
        if (dot == 0) {
            Integer tens = V8ProfileLine.getTens(s.substring(1));
            return tens == null ? null : tens;
        }
        Integer integer = V8ProfileLine.parseInt(s.substring(0, dot));
        Integer tens = V8ProfileLine.getTens(s.substring(dot + 1));
        return integer == null || tens == null ? null : Integer.valueOf(integer * 10 + tens);
    }

    private static Integer getTens(@NotNull String s) {
        Integer tens;
        if (s == null) {
            V8ProfileLine.$$$reportNull$$$0(3);
        }
        if ((tens = V8ProfileLine.parseInt(s.substring(0, 1))) == null) {
            return null;
        }
        return tens;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/calculation/V8ProfileLine";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createLine";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseInt";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parseTensPercent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getTens";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum ExecKind {
        Function,
        Stub,
        LazyCompile,
        Script,
        Eval,
        unknown;


        @NotNull
        public static ExecKind safeValueOf(@NotNull String s) {
            ExecKind execKind;
            if (s == null) {
                ExecKind.$$$reportNull$$$0(0);
            }
            try {
                execKind = ExecKind.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                ExecKind execKind2 = unknown;
                if (execKind2 == null) {
                    ExecKind.$$$reportNull$$$0(2);
                }
                return execKind2;
            }
            if (execKind == null) {
                ExecKind.$$$reportNull$$$0(1);
            }
            return execKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/nodejs/run/profile/cpu/calculation/V8ProfileLine$ExecKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/calculation/V8ProfileLine$ExecKind";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "safeValueOf";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "safeValueOf";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Parser {
        @NotNull
        final String myLine;
        private final boolean myParseSelfTicks;
        private final boolean myParseSelfPercent;
        private final boolean myOnlyLine;
        private Integer myTotalTicks;
        private Integer myTotalTensPercent;
        private Integer mySelfTicks;
        private Integer mySelfTensPercent;
        private int myOffset;
        private String myCallText;
        private int myPosition;
        private boolean myValid;

        public Parser(@NotNull String line) {
            if (line == null) {
                Parser.$$$reportNull$$$0(0);
            }
            this.mySelfTicks = 0;
            this.mySelfTensPercent = 0;
            this.myOffset = 0;
            this.myCallText = "";
            this.myLine = line;
            this.myParseSelfTicks = false;
            this.myParseSelfPercent = false;
            this.myOnlyLine = true;
        }

        public Parser(@NotNull String line, boolean ticks, boolean percent) {
            if (line == null) {
                Parser.$$$reportNull$$$0(1);
            }
            this.mySelfTicks = 0;
            this.mySelfTensPercent = 0;
            this.myOffset = 0;
            this.myCallText = "";
            this.myLine = line;
            this.myParseSelfTicks = ticks;
            this.myParseSelfPercent = percent;
            this.myOnlyLine = false;
        }

        public void parse() {
            if (this.myLine.isEmpty()) {
                return;
            }
            this.myPosition = 0;
            if (!this.myOnlyLine) {
                this.myTotalTicks = V8ProfileLine.parseInt(this.word());
                if (this.myTotalTicks == null) {
                    return;
                }
                this.myTotalTensPercent = V8ProfileLine.parseTensPercent(this.word());
                if (this.myTotalTensPercent == null) {
                    return;
                }
                if (this.myParseSelfTicks && (this.mySelfTicks = V8ProfileLine.parseInt(this.word())) == null) {
                    return;
                }
                if (this.myParseSelfPercent && (this.mySelfTensPercent = V8ProfileLine.parseTensPercent(this.word())) == null) {
                    return;
                }
            }
            this.readOffset();
            this.myCallText = StringUtil.notNullize((String)this.myLine.substring(this.myPosition));
            this.myValid = true;
        }

        public String getCallText() {
            return this.myCallText;
        }

        public Integer getTotalTicks() {
            return Parser.nonNullize(this.myTotalTicks);
        }

        public Integer getTotalTensPercent() {
            return Parser.nonNullize(this.myTotalTensPercent);
        }

        public Integer getSelfTicks() {
            return Parser.nonNullize(this.mySelfTicks);
        }

        private static int nonNullize(Integer integer) {
            return integer == null ? 0 : integer;
        }

        public Integer getSelfTensPercent() {
            return Parser.nonNullize(this.mySelfTensPercent);
        }

        public int getOffset() {
            return this.myOffset;
        }

        public int getPosition() {
            return this.myPosition;
        }

        public boolean isValid() {
            return this.myValid;
        }

        private void readOffset() {
            int cnt = 1;
            while (this.myPosition < this.myLine.length() && this.myLine.charAt(this.myPosition) == ' ') {
                ++this.myPosition;
                ++cnt;
            }
            this.myOffset = cnt;
            this.myValid = this.myPosition < this.myLine.length();
        }

        private String word() {
            while (this.myPosition < this.myLine.length() && this.myLine.charAt(this.myPosition) == ' ') {
                ++this.myPosition;
            }
            int idx = this.myLine.indexOf(32, this.myPosition);
            if (idx == -1) {
                int val = this.myPosition;
                this.myPosition = this.myLine.length();
                return this.myLine.substring(val);
            }
            String word = this.myLine.substring(this.myPosition, idx).trim();
            this.myPosition = idx + 1;
            return word;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/jetbrains/nodejs/run/profile/cpu/calculation/V8ProfileLine$Parser", "<init>"));
        }
    }

    public static class TreeParser {
        private final V8ProfileLine myTop;
        @NotNull
        private final Project myProject;
        private V8ProfileLine myCurrentParent;
        private boolean myParseSelfTicks;
        private boolean myParseSelfPercent;

        public TreeParser(@NotNull Project project) {
            if (project == null) {
                TreeParser.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            this.myCurrentParent = this.myTop = new V8ProfileLine(-1, -1, -1, -1, null, 0, "", -1L);
        }

        public void setParseSelfTicks(boolean parseSelfTicks) {
            this.myParseSelfTicks = parseSelfTicks;
        }

        public void setParseSelfPercent(boolean parseSelfPercent) {
            this.myParseSelfPercent = parseSelfPercent;
        }

        public void parseLines(@NotNull List<String> lines) throws ExecutionException {
            if (lines == null) {
                TreeParser.$$$reportNull$$$0(1);
            }
            for (String string : lines) {
                if (StringUtil.isEmptyOrSpaces((String)string)) continue;
                this.parseNextLine(string);
            }
        }

        public void parseNextLine(@NotNull String line) throws ExecutionException {
            if (line == null) {
                TreeParser.$$$reportNull$$$0(2);
            }
            Parser parser = new Parser(line, this.myParseSelfTicks, this.myParseSelfPercent);
            parser.parse();
            if (!parser.isValid()) {
                if (this.myTop.getChildren().isEmpty()) {
                    return;
                }
                throw new ExecutionException("Bad tick output format. Can not parse line '" + line + "'");
            }
            int offset = parser.getOffset();
            if (offset == this.myCurrentParent.getOffset()) {
                if (this.myCurrentParent.getParent() == null) {
                    throw new ExecutionException("Bad tick output format. (2) Do not know whose child is line '" + line + "'");
                }
                this.myCurrentParent = V8ProfileLine.createLineOld(parser, offset, this.myCurrentParent.getParent());
                return;
            }
            if (offset > this.myCurrentParent.getOffset()) {
                if (offset - this.myCurrentParent.getOffset() > 2) {
                    throw new ExecutionException("Bad tick output format. (3) Do not know whose child is line '" + line + "'");
                }
                this.myCurrentParent = V8ProfileLine.createLineOld(parser, offset, this.myCurrentParent);
                return;
            }
            for (int steps = this.myCurrentParent.getOffset() - offset + 2; this.myCurrentParent != null && steps > 0; steps -= 2) {
                this.myCurrentParent = this.myCurrentParent.getParent();
            }
            if (this.myCurrentParent == null) {
                throw new ExecutionException("Bad tick output format. (4) Do not know whose child is line '" + line + "'");
            }
            this.myCurrentParent = V8ProfileLine.createLineOld(parser, offset, this.myCurrentParent);
        }

        public V8ProfileLine getTop() {
            return this.myTop;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lines";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/calculation/V8ProfileLine$TreeParser";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseLines";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseNextLine";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TopCalledParser {
        @NotNull
        private final Project myProject;
        final List<Pair<String, List<V8ProfileLine>>> myData;

        public TopCalledParser(@NotNull Project project) {
            if (project == null) {
                TopCalledParser.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            this.myData = new ArrayList<Pair<String, List<V8ProfileLine>>>();
        }

        public void parseLines(@NotNull List<String> lines) throws ExecutionException {
            if (lines == null) {
                TopCalledParser.$$$reportNull$$$0(1);
            }
            String currentGroup = null;
            ArrayList<V8ProfileLine> currentLines = new ArrayList<V8ProfileLine>();
            for (int i = 1; i < lines.size(); ++i) {
                String string = lines.get(i).trim();
                if (string.startsWith("ticks ") || StringUtil.isEmptyOrSpaces((String)string)) continue;
                if (string.startsWith("[")) {
                    int idx = string.indexOf("]");
                    if (idx < 0) {
                        throw new ExecutionException("Bad tick output format. Can not parse group name in line '" + string + "'");
                    }
                    if (!currentLines.isEmpty() && currentGroup == null) {
                        throw new ExecutionException("Bad tick output format. Top called lines without a group before line '" + string + "'");
                    }
                    if (currentGroup != null && !currentLines.isEmpty()) {
                        this.myData.add((Pair<String, List<V8ProfileLine>>)Pair.create((Object)currentGroup, currentLines));
                        currentLines = new ArrayList();
                        currentGroup = null;
                    }
                    currentGroup = string.substring(1, idx);
                    continue;
                }
                Parser parser = new Parser(string, false, true);
                parser.parse();
                if (parser.getTotalTicks() == null || parser.getTotalTensPercent() == null) {
                    throw new ExecutionException("Bad tick output format. Cannot parse line '" + string + "'");
                }
                V8ProfileLine line = V8ProfileLine.createLineOld(parser, 0, null);
                currentLines.add(line);
            }
            if (!currentLines.isEmpty()) {
                if (currentGroup == null) {
                    throw new ExecutionException("Bad tick output format. Top called lines without a group before line '" + currentLines.get(0) + "'");
                }
                this.myData.add((Pair<String, List<V8ProfileLine>>)Pair.create(currentGroup, currentLines));
            }
            for (Pair<String, List<V8ProfileLine>> pair : this.myData) {
                V8ProfileLine line;
                if (((List)pair.getSecond()).size() != 1 || !StringUtil.isEmptyOrSpaces((String)(line = (V8ProfileLine)((List)pair.getSecond()).get(0)).toString())) continue;
                line.setPresentation("<total>");
                line.setIsInternal(true);
            }
        }

        public List<Pair<String, List<V8ProfileLine>>> getData() {
            return this.myData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lines";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/calculation/V8ProfileLine$TopCalledParser";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseLines";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

