/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation.diff;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import gnu.trove.TLongArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class SnapshotObjectsComparator {
    private final V8CachingReader myBaseReader;
    private final V8CachingReader myChangedReader;
    private final TLongArrayList myBaseSnapshotIds;
    private final TLongArrayList myChangedSnapshotIds;
    private final boolean myIsSystemAggregate;
    private final Map<Long, Long> myBaseSnapshotIdToId;
    private final Map<Long, Long> myBaseEquivalentToChanged;
    private final Set<Long> myTakenBase;

    SnapshotObjectsComparator(V8CachingReader baseReader, V8CachingReader changedReader, TLongArrayList baseSnapshotIds, TLongArrayList changedSnapshotIds, List<Long> baseChildren, boolean isSystemAggregate) {
        this.myBaseReader = baseReader;
        this.myChangedReader = changedReader;
        this.myBaseSnapshotIds = baseSnapshotIds;
        this.myChangedSnapshotIds = changedSnapshotIds;
        this.myIsSystemAggregate = isSystemAggregate;
        this.myBaseSnapshotIdToId = new HashMap();
        for (Long child : baseChildren) {
            this.myBaseSnapshotIdToId.put(this.myBaseSnapshotIds.get(child.intValue()), child);
        }
        this.myBaseEquivalentToChanged = new HashMap();
        this.myTakenBase = new HashSet<Long>();
    }

    public Long getBaseForChanged(Long changedId) {
        Long saved = this.myBaseEquivalentToChanged.get(changedId);
        if (saved != null && saved >= 0L) {
            return saved;
        }
        Long baseId = this.myBaseSnapshotIdToId.get(this.myChangedSnapshotIds.get(changedId.intValue()));
        if (baseId != null && (!this.myIsSystemAggregate || this.compareNames(baseId, changedId))) {
            this.myBaseEquivalentToChanged.put(changedId, baseId);
            this.myTakenBase.add(baseId);
            return baseId;
        }
        this.myBaseEquivalentToChanged.put(changedId, -1L);
        return null;
    }

    private boolean compareNames(Long baseId, Long changedId) {
        String changedName = this.myChangedReader.getString(this.myChangedReader.getNode(changedId).getNameId());
        String baseName = this.myBaseReader.getString(this.myBaseReader.getNode(baseId).getNameId());
        return Comparing.equal((String)changedName, (String)baseName);
    }

    public boolean haveEquivalent(Long baseId) {
        return this.myTakenBase.contains(baseId);
    }
}

