/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerPathForm;
import com.jetbrains.php.composer.ComposerPhpInterpretersCombo;
import com.jetbrains.php.composer.ComposerUtils;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerExecutionForm {
    private JPanel myMainPanel;
    private JPanel myLocalInstallationPanel;
    private JBRadioButton myLocalRadioButton;
    private ComposerPhpInterpretersCombo myPhpInterpreterComboBox;
    private TextFieldWithBrowseButton myPathTextField;
    private JBCheckBox myDownloadCheckBox;
    private JPanel myGlobalInstallationPanel;
    private JBRadioButton myGlobalRadioButton;
    private TextFieldWithBrowseButton myExecutableTextField;
    private final Project myProject;
    private final boolean isVisible;
    private final boolean isShowDownloadOption;
    private String myInterpreterName;

    public ComposerExecutionForm(Project project, final @Nullable Runnable validationListener, boolean visible, boolean showDownloadOption) {
        this.myProject = project;
        this.isVisible = visible;
        this.isShowDownloadOption = showDownloadOption;
        this.$$$setupUI$$$();
        if (!this.isVisible) {
            this.myMainPanel.setVisible(false);
            return;
        }
        if (!this.isShowDownloadOption) {
            this.myDownloadCheckBox.setVisible(false);
            this.myDownloadCheckBox.setSelected(false);
        }
        this.myPathTextField.addActionListener(ComposerUtils.createPharBrowserListener(this.myPathTextField, this.myMainPanel));
        this.myExecutableTextField.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(PhpBundle.message("framework.composer.path.dialog.path.to.composer", new Object[0]), PhpBundle.message("framework.composer.path.dialog.specify.composer.executable", new Object[0]), (ComponentWithBrowseButton)this.myExecutableTextField, null, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            @Nullable
            protected VirtualFile getInitialFile() {
                VirtualFile file;
                String text = ComposerExecutionForm.this.myExecutableTextField.getText();
                if (!SystemInfo.isWindows && StringUtil.isEmpty((String)text) && (file = LocalFileSystem.getInstance().findFileByPath("usr/local/bin/composer")) != null) {
                    return file;
                }
                return super.getInitialFile();
            }
        });
        this.myDownloadCheckBox.addActionListener(e -> {
            boolean enabled = !this.myDownloadCheckBox.isSelected();
            this.myPathTextField.setEnabled(enabled);
            if (!enabled) {
                this.myPathTextField.setText("");
            }
        });
        this.myGlobalRadioButton.addActionListener(e -> this.selectGlobalInstallation(true));
        this.myLocalRadioButton.addActionListener(e -> this.selectGlobalInstallation(false));
        if (validationListener != null) {
            this.myPhpInterpreterComboBox.getComboBox().addActionListener(e -> validationListener.run());
            DocumentAdapter listener = new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    validationListener.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/composer/ComposerExecutionForm$2", "textChanged"));
                }
            };
            this.myPathTextField.getTextField().getDocument().addDocumentListener((DocumentListener)listener);
            this.myExecutableTextField.getTextField().getDocument().addDocumentListener((DocumentListener)listener);
            this.myDownloadCheckBox.addActionListener(e -> validationListener.run());
        }
    }

    private void selectGlobalInstallation(boolean global) {
        UIUtil.setEnabled((Component)this.myGlobalInstallationPanel, (boolean)global, (boolean)true, (boolean)true);
        UIUtil.setEnabled((Component)this.myLocalInstallationPanel, (!global ? 1 : 0) != 0, (boolean)true, (boolean)true);
        this.myGlobalRadioButton.setEnabled(true);
        this.myLocalRadioButton.setEnabled(true);
    }

    private void createUIComponents() {
        this.myPhpInterpreterComboBox = new ComposerPhpInterpretersCombo(this.myProject);
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void addDataListener(final Runnable listener) {
        if (!this.isVisible) {
            return;
        }
        ActionListener actionListener = e -> listener.run();
        this.myGlobalRadioButton.addActionListener(actionListener);
        this.myLocalRadioButton.addActionListener(actionListener);
        this.myPhpInterpreterComboBox.getComboBox().addActionListener(actionListener);
        DocumentAdapter documentAdapter = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                listener.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/composer/ComposerExecutionForm$3", "textChanged"));
            }
        };
        this.myPathTextField.getTextField().getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.myDownloadCheckBox.addActionListener(e -> listener.run());
        this.myExecutableTextField.getTextField().getDocument().addDocumentListener((DocumentListener)documentAdapter);
    }

    public boolean isModified(ComposerDataService service) {
        if (!this.isVisible) {
            return false;
        }
        ComposerDataService.ExecutionData executionData = service.getComposerExecutionData();
        if (this.myGlobalRadioButton.isSelected() != executionData.useExecutable()) {
            return true;
        }
        if (this.myGlobalRadioButton.isSelected()) {
            if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)executionData.executablePath), (CharSequence)StringUtil.nullize((String)this.myExecutableTextField.getText()))) {
                return true;
            }
        } else {
            if (this.myPhpInterpreterComboBox.isModified(this.myInterpreterName)) {
                return true;
            }
            if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)executionData.pharPath), (CharSequence)StringUtil.nullize((String)this.myPathTextField.getText()))) {
                return true;
            }
            if (this.myDownloadCheckBox.isSelected() != service.shouldDownload()) {
                return true;
            }
        }
        return false;
    }

    public void apply(ComposerDataService service) {
        if (!this.isVisible) {
            return;
        }
        this.myInterpreterName = this.myPhpInterpreterComboBox.getSelectedItemName();
        service.setExecutionData(this.getExecutionData());
        service.setShouldDownloadPhar(this.myDownloadCheckBox.isSelected());
    }

    @NotNull
    public ComposerDataService.ExecutionData getExecutionData() {
        ComposerDataService.ExecutionData executionData = ComposerDataService.constructExecutionData(this.myGlobalRadioButton.isSelected(), this.myExecutableTextField.getText(), this.myPhpInterpreterComboBox.getInterpreterId(), this.myPathTextField.getText());
        if (executionData == null) {
            ComposerExecutionForm.$$$reportNull$$$0(0);
        }
        return executionData;
    }

    public void reset(ComposerDataService service) {
        if (!this.isVisible) {
            return;
        }
        this.myDownloadCheckBox.setSelected(false);
        ComposerDataService.ExecutionData executionData = service.getComposerExecutionData();
        this.reset(executionData);
    }

    private void reset(ComposerDataService.ExecutionData executionData) {
        if (executionData.useExecutable()) {
            this.myGlobalRadioButton.setSelected(true);
            this.selectGlobalInstallation(true);
            this.myPhpInterpreterComboBox.reset(null);
            this.myInterpreterName = null;
            this.myPathTextField.setText(null);
            this.myExecutableTextField.setText(executionData.executablePath);
        } else {
            this.myLocalRadioButton.setSelected(true);
            this.selectGlobalInstallation(false);
            this.myPhpInterpreterComboBox.setInterpreterId(executionData.interpreterId);
            this.myInterpreterName = this.myPhpInterpreterComboBox.getSelectedItemName();
            this.myPathTextField.setText(StringUtil.notNullize((String)executionData.pharPath));
            this.myExecutableTextField.setText("composer");
        }
    }

    public void resetOrGuessDefaults(ComposerDataService service) {
        if (!this.isVisible) {
            return;
        }
        ComposerDataService.ExecutionData executionData = service.getComposerExecutionData();
        if (executionData.isDefault()) {
            String validateGlobal = ComposerPathForm.validateExecutableFromPath("composer");
            if (validateGlobal == null) {
                this.reset(ComposerDataService.constructExecutionData(true, "composer", null, null));
                this.myDownloadCheckBox.setSelected(false);
                return;
            }
            if (this.isShowDownloadOption) {
                this.reset(ComposerDataService.constructExecutionData(false, null, null, null));
                this.myDownloadCheckBox.setSelected(true);
                this.myPathTextField.setEnabled(false);
                return;
            }
        }
        this.reset(service);
    }

    public ValidationInfo validate() {
        if (!this.isVisible) {
            return null;
        }
        if (this.myGlobalRadioButton.isSelected()) {
            return ComposerPathForm.validateComposerExecutablePath(this.myExecutableTextField);
        }
        ValidationInfo info = this.myPhpInterpreterComboBox.validateInterpreter();
        if (info != null) {
            return info;
        }
        if (!this.myDownloadCheckBox.isSelected()) {
            return ComposerPathForm.validateComposerPharPath(this.myPathTextField);
        }
        return null;
    }

    public boolean isDownloadPhar() {
        return this.myDownloadCheckBox.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/composer/ComposerExecutionForm", "getExecutionData"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBRadioButton jBRadioButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JBCheckBox jBCheckBox;
        JBRadioButton jBRadioButton2;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myLocalInstallationPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 3, null, null, null, 0, true));
        ComposerPhpInterpretersCombo composerPhpInterpretersCombo = this.myPhpInterpreterComboBox;
        jPanel2.add((Component)((Object)composerPhpInterpretersCombo), new GridConstraints(2, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/PhpBundle").getString("framework.composer.add.dependency.settings.interpreter.label"));
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myLocalRadioButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setText("composer.phar");
        jPanel2.add((Component)jBRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDownloadCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(false);
        jBCheckBox.setText("Download composer.phar from getcomposer.org");
        jPanel2.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null, 1));
        this.myPathTextField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton2.setText("");
        jPanel2.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myGlobalInstallationPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 3, null, null, null, 0, true));
        this.myExecutableTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myGlobalRadioButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("'composer' executable");
        jPanel.add((Component)jBRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

