/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.connection;

import com.intellij.openapi.util.Version;
import com.intellij.util.Consumer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.connection.InputReader;
import com.jetbrains.php.debug.connection.OutputWriter;
import com.jetbrains.php.debug.connection.PhpDebugConnection;
import com.jetbrains.php.debug.xdebug.connection.XdebugConnectionConfigurator;
import com.jetbrains.php.debug.xdebug.dbgp.DbgpUtil;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ContextNamesRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ContextNamesResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpInputMessage;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpOutputMessage;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ErrorResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.EvalRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.InitNotification;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StatusRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StatusResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StepIntoRequest;
import com.jetbrains.php.debug.xdebug.debugger.XdebugConnectionDetacher;
import com.jetbrains.php.debug.xdebug.handlers.DbgpBooleanEvalResponseHandler;
import com.jetbrains.php.debug.xdebug.handlers.DbgpResponseHandler;
import com.jetbrains.php.debug.xdebug.handlers.DbgpStringEvalResponseHadler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XdebugConnection
extends PhpDebugConnection<DbgpInputMessage, DbgpOutputMessage> {
    private static final String CHARSET_ENCODE = "UTF-8";
    private String mySessionId;
    private String myFileName;
    private Version myEngineVersion;
    private final AtomicReference<Map<Integer, String>> myContexts;

    public XdebugConnection(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) {
        if (inputStream == null) {
            XdebugConnection.$$$reportNull$$$0(0);
        }
        if (outputStream == null) {
            XdebugConnection.$$$reportNull$$$0(1);
        }
        super(inputStream, outputStream);
        this.myContexts = new AtomicReference<Object>(null);
        this.mySessionId = "";
        this.myFileName = "";
        this.myEngineVersion = null;
    }

    @Override
    public void init() throws IOException {
        DbgpInputMessage message = (DbgpInputMessage)this.myInputReader.read();
        this.logMessage(message, "<-");
        if (message instanceof InitNotification) {
            InitNotification initNotification = (InitNotification)message;
            this.mySessionId = initNotification.getSessionId();
            this.myFileName = initNotification.getFileUri();
            this.myEngineVersion = Version.parseVersion((String)initNotification.getEngineVersion());
        }
    }

    @Nullable
    public Version getEngineVersion() {
        return this.myEngineVersion;
    }

    @Override
    @NotNull
    public String getSessionId() {
        String string = this.mySessionId;
        if (string == null) {
            XdebugConnection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFilePath() {
        String string = this.myFileName;
        if (string == null) {
            XdebugConnection.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void loadContextNames(final Consumer<Map<Integer, String>> onContextNamesLoaded) {
        if (this.myContexts.get() == null) {
            this.send(new ContextNamesRequest(), new DbgpResponseHandler<ContextNamesResponse>(){

                @Override
                public void onSuccessResponse(@NotNull ContextNamesResponse message) {
                    if (message == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Map<Integer, String> contexts = message.getContexts();
                    if (XdebugConnection.this.myContexts.get() == null) {
                        XdebugConnection.this.myContexts.compareAndSet(null, contexts);
                    }
                    onContextNamesLoaded.consume(contexts);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/xdebug/connection/XdebugConnection$1", "onSuccessResponse"));
                }
            });
        } else {
            onContextNamesLoaded.consume(this.myContexts.get());
        }
    }

    @Override
    public void startDetach() {
        XdebugConnectionDetacher detacher = new XdebugConnectionDetacher(this);
        detacher.init();
    }

    @Override
    @NotNull
    protected InputReader<DbgpInputMessage> createInputReader(InputStream in) {
        MyInputReader myInputReader = new MyInputReader(in);
        if (myInputReader == null) {
            XdebugConnection.$$$reportNull$$$0(4);
        }
        return myInputReader;
    }

    @Override
    @NotNull
    protected OutputWriter<DbgpOutputMessage> createOutputWriter(OutputStream out) {
        MyOutputWriter myOutputWriter = new MyOutputWriter(out);
        if (myOutputWriter == null) {
            XdebugConnection.$$$reportNull$$$0(5);
        }
        return myOutputWriter;
    }

    @Override
    public void evalBoolean(@NotNull String booleanExpression, @NotNull String encoding, final @NotNull PhpDebugProcess.BooleanEvaluateCallback callback) {
        if (booleanExpression == null) {
            XdebugConnection.$$$reportNull$$$0(6);
        }
        if (encoding == null) {
            XdebugConnection.$$$reportNull$$$0(7);
        }
        if (callback == null) {
            XdebugConnection.$$$reportNull$$$0(8);
        }
        this.send(new EvalRequest(booleanExpression, encoding), new DbgpBooleanEvalResponseHandler(CHARSET_ENCODE){

            @Override
            public void onEval(boolean value) {
                callback.evaluated(value);
            }

            @Override
            public void onEvalError(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    2.$$$reportNull$$$0(0);
                }
                callback.errorOccurred();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/jetbrains/php/debug/xdebug/connection/XdebugConnection$2", "onEvalError"));
            }
        });
    }

    @Override
    public void evalString(@NotNull String expression, @NotNull String encoding, final @NotNull PhpDebugProcess.StringEvaluateCallback callback) {
        if (expression == null) {
            XdebugConnection.$$$reportNull$$$0(9);
        }
        if (encoding == null) {
            XdebugConnection.$$$reportNull$$$0(10);
        }
        if (callback == null) {
            XdebugConnection.$$$reportNull$$$0(11);
        }
        String castedExpression = String.format("(string)(%1$s)", expression);
        this.send(new EvalRequest(castedExpression, encoding), new DbgpStringEvalResponseHadler(CHARSET_ENCODE){

            @Override
            public void onEval(@NotNull String value) {
                if (value == null) {
                    3.$$$reportNull$$$0(0);
                }
                callback.evaluated(value);
            }

            @Override
            public void onEvalError(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    3.$$$reportNull$$$0(1);
                }
                callback.errorOccurred();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/connection/XdebugConnection$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onEval";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onEvalError";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    protected void initialize(@NotNull PhpDebugProcess.InitializeCallback callback, boolean isExternalConnection) {
        if (callback == null) {
            XdebugConnection.$$$reportNull$$$0(12);
        }
        XdebugConnectionConfigurator.create(isExternalConnection).configure(this, () -> {
            if (callback == null) {
                XdebugConnection.$$$reportNull$$$0(18);
            }
            XdebugConnection.checkStatus(this, callback);
        });
    }

    private static void checkStatus(final @NotNull XdebugConnection connection, final @NotNull PhpDebugProcess.InitializeCallback callback) {
        if (connection == null) {
            XdebugConnection.$$$reportNull$$$0(13);
        }
        if (callback == null) {
            XdebugConnection.$$$reportNull$$$0(14);
        }
        connection.send(new StatusRequest(), new DbgpResponseHandler<StatusResponse>(){

            @Override
            public void onSuccessResponse(@NotNull StatusResponse message) {
                if (message == null) {
                    4.$$$reportNull$$$0(0);
                }
                switch (message.getStatus()) {
                    case STARTING: {
                        XdebugConnection.stepInto(connection, callback, false);
                        break;
                    }
                    case BREAK: {
                        XdebugConnection.stepInto(connection, callback, true);
                        break;
                    }
                    default: {
                        callback.errorOccurred(PhpBundle.message("debug.zend.error.title.cannot.accept.external.xdebug.connection", new Object[0]), PhpBundle.message("debug.xdebug.error.unsupported.protocol.version", new Object[0]));
                    }
                }
            }

            @Override
            public void onErrorResponse(@NotNull ErrorResponse errorResponse) {
                if (errorResponse == null) {
                    4.$$$reportNull$$$0(1);
                }
                callback.errorOccurred(PhpBundle.message("debug.zend.error.title.cannot.accept.external.xdebug.connection", new Object[0]), PhpBundle.message("debug.xdebug.error.unsupported.protocol.version", new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorResponse";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/connection/XdebugConnection$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onSuccessResponse";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onErrorResponse";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void stepInto(@NotNull XdebugConnection connection, final @NotNull PhpDebugProcess.InitializeCallback callback, final boolean isJitMode) {
        if (connection == null) {
            XdebugConnection.$$$reportNull$$$0(15);
        }
        if (callback == null) {
            XdebugConnection.$$$reportNull$$$0(16);
        }
        connection.send(new StepIntoRequest(), new DbgpResponseHandler<StatusResponse>(){

            @Override
            public void onSuccessResponse(@NotNull StatusResponse message) {
                if (message == null) {
                    5.$$$reportNull$$$0(0);
                }
                callback.initialized(isJitMode);
            }

            @Override
            public void onErrorResponse(@NotNull ErrorResponse errorResponse) {
                if (errorResponse == null) {
                    5.$$$reportNull$$$0(1);
                }
                callback.errorOccurred(PhpBundle.message("debug.zend.error.title.cannot.accept.external.xdebug.connection", new Object[0]), PhpBundle.message("debug.xdebug.error.unsupported.protocol.version", new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorResponse";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/connection/XdebugConnection$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onSuccessResponse";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onErrorResponse";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    protected void handleClassCastException(@NotNull ClassCastException e) {
        if (e == null) {
            XdebugConnection.$$$reportNull$$$0(17);
        }
        LOG.error("Can not handle debugger response due to wrong response type.\nPlease, report the issue with attached xdebug log. You can generate it by enabling 'xdebug.remote_log=<path_to_log>' option in php.ini.", (Throwable)e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/connection/XdebugConnection";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "booleanExpression";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/connection/XdebugConnection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createInputReader";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createOutputWriter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "evalBoolean";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "evalString";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkStatus";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "stepInto";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "handleClassCastException";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$initialize$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyOutputWriter
    implements OutputWriter<DbgpOutputMessage> {
        private final Writer myWriter;

        public MyOutputWriter(@NotNull OutputStream outputStream) {
            if (outputStream == null) {
                MyOutputWriter.$$$reportNull$$$0(0);
            }
            this.myWriter = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        }

        @Override
        public void write(DbgpOutputMessage output) throws IOException {
            output.serialize(this.myWriter);
            this.myWriter.write(0);
            this.myWriter.flush();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputStream", "com/jetbrains/php/debug/xdebug/connection/XdebugConnection$MyOutputWriter", "<init>"));
        }
    }

    public static class MyInputReader
    implements InputReader<DbgpInputMessage> {
        private final InputStream myInputStream;

        public MyInputReader(@NotNull InputStream inputStream) {
            if (inputStream == null) {
                MyInputReader.$$$reportNull$$$0(0);
            }
            this.myInputStream = inputStream;
        }

        @Override
        @NotNull
        public DbgpInputMessage read() throws IOException {
            DbgpInputMessage dbgpInputMessage = DbgpUtil.readMessage(this.myInputStream);
            if (dbgpInputMessage == null) {
                MyInputReader.$$$reportNull$$$0(1);
            }
            return dbgpInputMessage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputStream";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/xdebug/connection/XdebugConnection$MyInputReader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/xdebug/connection/XdebugConnection$MyInputReader";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "read";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

