/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocElementType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import org.jetbrains.annotations.NotNull;

public final class PhpCodeValidationUtil {
    static final TokenSet CONSTANT_SCALARS_ONLY = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{PhpElementTypes.NS_REFERENCE, PhpElementTypes.CONSTANT_REF, PhpElementTypes.CLASS_REFERENCE, PhpElementTypes.CLASS_CONSTANT_REFERENCE, PhpElementTypes.NUMBER, PhpElementTypes.STRING, PhpElementTypes.HEREDOC}), PhpElementTypes.UNARY_EXPRESSIONS});
    static final TokenSet CONSTANT_SCALAR_EXPRESSIONS = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{PhpElementTypes.STATIC_SCALAR, PhpElementTypes.ARRAY_ACCESS_EXPRESSION, PhpElementTypes.ARRAY_INDEX, PhpElementTypes.ARRAY_CREATION_EXPRESSION, PhpElementTypes.HASH_ARRAY_ELEMENT, PhpElementTypes.ARRAY_KEY, PhpElementTypes.ARRAY_VALUE, PhpElementTypes.PARENTHESIZED_EXPRESSION, PhpElementTypes.TERNARY_EXPRESSION}), CONSTANT_SCALARS_ONLY, PhpElementTypes.BINARY_EXPRESSIONS});
    static final TokenSet PARAMETER_EXPRESSIONS = TokenSet.orSet((TokenSet[])new TokenSet[]{CONSTANT_SCALAR_EXPRESSIONS, TokenSet.create((IElementType[])new IElementType[]{PhpElementTypes.FUNCTION_CALL, PhpElementTypes.PARAMETER_LIST})});

    private PhpCodeValidationUtil() {
    }

    public static boolean isAllowedAsFieldDefaultValue(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpCodeValidationUtil.$$$reportNull$$$0(0);
        }
        final PhpLanguageLevel level = PhpProjectConfigurationFacade.getInstance(expression.getProject()).getLanguageLevel();
        final Ref isAllowed = new Ref((Object)true);
        expression.accept((PsiElementVisitor)new PhpElementVisitor(){

            public void visitPhpConstantReference(ConstantReference reference) {
            }

            public void visitPhpClassConstantReference(ClassConstantReference constantReference) {
            }

            public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
                if (expression.getChildren().length != 0) {
                    isAllowed.set((Object)false);
                }
            }

            public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
                expression.acceptChildren((PsiElementVisitor)this);
            }

            public void visitPhpExpression(PhpExpression expression) {
                IElementType expressionType = expression.getNode().getElementType();
                if (!PhpElementTypes.NUMBER.equals(expressionType)) {
                    super.visitPhpExpression(expression);
                }
            }

            public void visitPhpUnaryExpression(UnaryExpression expr) {
                IElementType firstPsiChildType;
                PhpPsiElement firstPsiChild;
                IElementType operationType;
                if (level.hasFeature(PhpLanguageFeature.CONSTANT_SCALAR_EXPRESSIONS)) {
                    return;
                }
                PsiElement operation = expr.getOperation();
                if (operation != null && (PhpTokenTypes.opMINUS.equals(operationType = operation.getNode().getElementType()) || PhpTokenTypes.opPLUS.equals(operationType)) && (firstPsiChild = expr.getFirstPsiChild()) != null && PhpElementTypes.NUMBER.equals(firstPsiChildType = firstPsiChild.getNode().getElementType())) {
                    return;
                }
                isAllowed.set((Object)false);
            }

            public void visitPhpElement(PhpPsiElement element) {
                IElementType elementType = element.getNode().getElementType();
                if (PhpElementTypes.HASH_ARRAY_ELEMENT.equals(elementType) || PhpElementTypes.ARRAY_KEY.equals(elementType) || PhpElementTypes.ARRAY_VALUE.equals(elementType) || level.hasFeature(PhpLanguageFeature.CONSTANT_SCALAR_EXPRESSIONS) && (PhpElementTypes.ARRAY_INDEX.equals(elementType) || PhpElementTypes.ARRAY_ACCESS_EXPRESSION.equals(elementType) || PhpElementTypes.BINARY_EXPRESSIONS.contains(elementType) || PhpElementTypes.UNARY_EXPRESSIONS.contains(elementType) || PhpElementTypes.TERNARY_EXPRESSION == elementType || PhpElementTypes.PARENTHESIZED_EXPRESSION == elementType)) {
                    element.acceptChildren((PsiElementVisitor)this);
                } else if (!(element instanceof PhpDocComment)) {
                    isAllowed.set((Object)false);
                }
            }
        });
        return (Boolean)isAllowed.get();
    }

    public static boolean isAllowedAsConstantValue(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpCodeValidationUtil.$$$reportNull$$$0(1);
        }
        if (PhpPsiUtil.isOfType(expression, PhpElementTypes.HASH_ARRAY_ELEMENT)) {
            return false;
        }
        PhpLanguageLevel level = PhpProjectConfigurationFacade.getInstance(expression.getProject()).getLanguageLevel();
        TokenSet check = level.hasFeature(PhpLanguageFeature.CONSTANT_SCALAR_EXPRESSIONS) ? CONSTANT_SCALAR_EXPRESSIONS : CONSTANT_SCALARS_ONLY;
        return PhpCodeValidationUtil.checkExpression(expression, check);
    }

    private static boolean checkExpression(@NotNull PsiElement expression, final TokenSet allowed) {
        if (expression == null) {
            PhpCodeValidationUtil.$$$reportNull$$$0(2);
        }
        final Ref isAllowed = new Ref((Object)true);
        expression.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                IElementType type = element.getNode().getElementType();
                if (!(element instanceof PhpDocComment || type instanceof PhpDocElementType || !(element instanceof PhpPsiElement) || element instanceof PhpDocTag || allowed.contains(type))) {
                    isAllowed.set((Object)false);
                    this.stopWalking();
                }
                super.visitElement(element);
            }
        });
        return (Boolean)isAllowed.get();
    }

    public static boolean isAllowedAsStaticValue(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpCodeValidationUtil.$$$reportNull$$$0(3);
        }
        return PhpCodeValidationUtil.checkExpression(expression, CONSTANT_SCALAR_EXPRESSIONS);
    }

    public static boolean isAllowedAsParameterValue(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpCodeValidationUtil.$$$reportNull$$$0(4);
        }
        if (!(expression instanceof PhpExpression) || !PhpRefactoringUtil.isExtractableExpression((PhpExpression)expression)) {
            return false;
        }
        return PhpCodeValidationUtil.checkExpression(expression, PARAMETER_EXPRESSIONS);
    }

    public static boolean isAllowedAsClassConstantValue(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpCodeValidationUtil.$$$reportNull$$$0(5);
        }
        return PhpCodeValidationUtil.isAllowedAsConstantValue(expression);
    }

    public static boolean isAllowedAsNamespaceConstantValue(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpCodeValidationUtil.$$$reportNull$$$0(6);
        }
        return PhpCodeValidationUtil.isAllowedAsConstantValue(expression);
    }

    public static boolean isAllowedAsParameterDefaultValue(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpCodeValidationUtil.$$$reportNull$$$0(7);
        }
        if (expression instanceof ArrayCreationExpression) {
            return true;
        }
        return PhpCodeValidationUtil.isAllowedAsConstantValue(expression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "expression";
        objectArray2[1] = "com/jetbrains/php/lang/PhpCodeValidationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllowedAsFieldDefaultValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllowedAsConstantValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllowedAsStaticValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllowedAsParameterValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllowedAsClassConstantValue";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllowedAsNamespaceConstantValue";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllowedAsParameterDefaultValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

