/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddTagBaseQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class PhpDocMissingReturnTagInspection
extends PhpInspection {
    private static final String MESSAGE = PhpBundle.message("inspection.doc.missing.return.tag.problem", new Object[0]);
    private static final AddReturnTagQuickFix ADD_RETURN_TAG_QUICK_FIX = new AddReturnTagQuickFix();
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{ADD_RETURN_TAG_QUICK_FIX};
    public static final String ADD_RETURN_TAG_FIX_NAME = ADD_RETURN_TAG_QUICK_FIX.getFamilyName();
    public boolean SKIP_ON_EMPTY_PHPDOC = true;
    public boolean SKIP_ON_PRESENT_TYPE_HINT = false;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDocMissingReturnTagInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                PhpDocComment docComment = function.getDocComment();
                if (docComment == null || function instanceof Method && docComment.hasInheritDocTag() || PhpDocUtil.hasOnlyNoInspectionTag(docComment)) {
                    return;
                }
                PhpDocReturnTag returnTag = docComment.getReturnTag();
                if (returnTag != null || PhpDocMissingReturnTagInspection.this.SKIP_ON_EMPTY_PHPDOC && docComment.getParamTags().isEmpty()) {
                    return;
                }
                if (function instanceof Method && (((Method)function).getMethodType(false) == Method.MethodType.CONSTRUCTOR || "__destruct".equalsIgnoreCase(function.getName()))) {
                    return;
                }
                if (PhpDocMissingReturnTagInspection.this.SKIP_ON_PRESENT_TYPE_HINT && function.getReturnType() != null) {
                    return;
                }
                PhpType functionType = PhpDocUtil.getReturnType(function);
                if (!functionType.isEmpty() && !PhpType.VOID.equals((Object)functionType.filterUnknown())) {
                    holder.registerProblem((PsiElement)docComment, MESSAGE, FIXES);
                }
            }

            public void visitPhpMethod(Method method) {
                this.visitPhpFunction((Function)method);
            }
        };
        if (phpElementVisitor == null) {
            PhpDocMissingReturnTagInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocMissingReturnTagInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocMissingReturnTagInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class OptionsPanel {
        private JPanel myOptionsPanel;
        private JCheckBox mySkipOnEmpty;
        private JCheckBox mySkipOnPresentTypeHint;

        private OptionsPanel() {
            this.$$$setupUI$$$();
            this.mySkipOnEmpty.setSelected(PhpDocMissingReturnTagInspection.this.SKIP_ON_EMPTY_PHPDOC);
            this.mySkipOnEmpty.getModel().addChangeListener(e -> {
                PhpDocMissingReturnTagInspection.this.SKIP_ON_EMPTY_PHPDOC = this.mySkipOnEmpty.isSelected();
            });
            this.mySkipOnPresentTypeHint.setSelected(PhpDocMissingReturnTagInspection.this.SKIP_ON_PRESENT_TYPE_HINT);
            this.mySkipOnPresentTypeHint.getModel().addChangeListener(e -> {
                PhpDocMissingReturnTagInspection.this.SKIP_ON_PRESENT_TYPE_HINT = this.mySkipOnPresentTypeHint.isSelected();
            });
        }

        private JPanel getComponent() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JPanel jPanel;
            this.myOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JBCheckBox jBCheckBox = new JBCheckBox();
            this.mySkipOnEmpty = jBCheckBox;
            jBCheckBox.setSelected(true);
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.doc.missing.return.tag.option.skip.on.empty"));
            jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            JBCheckBox jBCheckBox2 = new JBCheckBox();
            this.mySkipOnPresentTypeHint = jBCheckBox2;
            jBCheckBox2.setSelected(false);
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.doc.missing.return.tag.option.skip.on.present.type.hint"));
            jPanel.add((Component)jBCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private static class AddReturnTagQuickFix
    extends PhpAddTagBaseQuickFix<Function> {
        private AddReturnTagQuickFix() {
        }

        @Override
        @NotNull
        protected String getTagName() {
            if ("@return" == null) {
                AddReturnTagQuickFix.$$$reportNull$$$0(0);
            }
            return "@return";
        }

        @Override
        @NotNull
        protected Function getOwner(@NotNull PsiElement element) {
            if (element == null) {
                AddReturnTagQuickFix.$$$reportNull$$$0(1);
            }
            Function function = (Function)((PhpDocComment)element).getOwner();
            if (function == null) {
                AddReturnTagQuickFix.$$$reportNull$$$0(2);
            }
            return function;
        }

        @Override
        @NotNull
        protected PhpDocComment getDocComment(@NotNull PsiElement element) {
            if (element == null) {
                AddReturnTagQuickFix.$$$reportNull$$$0(3);
            }
            PhpDocComment phpDocComment = (PhpDocComment)element;
            if (phpDocComment == null) {
                AddReturnTagQuickFix.$$$reportNull$$$0(4);
            }
            return phpDocComment;
        }

        @Override
        @NotNull
        protected PsiElement getTag(@NotNull Project project, @NotNull Function owner, @NotNull PsiElement element) {
            if (project == null) {
                AddReturnTagQuickFix.$$$reportNull$$$0(5);
            }
            if (owner == null) {
                AddReturnTagQuickFix.$$$reportNull$$$0(6);
            }
            if (element == null) {
                AddReturnTagQuickFix.$$$reportNull$$$0(7);
            }
            String template = "/**\n* @return " + PhpDocUtil.getTypePresentation(project, PhpDocUtil.getReturnType(owner), PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)owner)) + "\n*/";
            PhpDocReturnTag phpDocReturnTag = PhpPsiElementFactory.createFromText(project, PhpDocReturnTag.class, template);
            if (phpDocReturnTag == null) {
                AddReturnTagQuickFix.$$$reportNull$$$0(8);
            }
            return phpDocReturnTag;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocMissingReturnTagInspection$AddReturnTagQuickFix";
                    break;
                }
                case 1: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTagName";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocMissingReturnTagInspection$AddReturnTagQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOwner";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDocComment";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTag";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getOwner";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getDocComment";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getTag";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

