/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import org.jetbrains.annotations.NotNull;

public abstract class PhpCaseSensitiveQuickFix
extends PhpQuickFixBase {
    public static final String NAME = "quickfix.case.sensitive.name";
    protected String myResolvedName;

    public PhpCaseSensitiveQuickFix(String resolvedName) {
        this.myResolvedName = resolvedName;
    }

    public void doSimpleComittedReplace(@NotNull Project project, PhpReference reference) {
        PsiDocumentManager documentManager;
        Document document;
        if (project == null) {
            PhpCaseSensitiveQuickFix.$$$reportNull$$$0(0);
        }
        if ((document = (documentManager = PsiDocumentManager.getInstance((Project)project)).getDocument(reference.getContainingFile())) != null) {
            PhpCaseSensitiveQuickFix.simpleUncomittedReplace(reference, this.myResolvedName, document);
            documentManager.commitDocument(document);
        }
    }

    public static void simpleUncomittedReplace(PhpReference reference, String resolvedName, Document document) {
        ASTNode nameNode;
        if (document != null && (nameNode = reference.getNameNode()) != null) {
            TextRange textRange = nameNode.getTextRange();
            document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)resolvedName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/lang/inspections/quickfix/PhpCaseSensitiveQuickFix", "doSimpleComittedReplace"));
    }
}

