/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.array;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.intentions.array.PhpConvertArraySyntaxBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import org.jetbrains.annotations.NotNull;

public class PhpConvertToTraditionalArraySyntaxIntention
extends PhpConvertArraySyntaxBase {
    public static final String NAME = "Convert Array Syntax To Traditional";
    public static final String TEXT = PhpBundle.message("intention.convert.to.traditional.syntax", new Object[0]);
    private static final String CLOSE_ARRAY = ")";
    private static final String OPEN_ARRAY_DECLARATION = "array(";

    @Override
    boolean isAvailable(ArrayCreationExpression expression) {
        PhpCodeStyleSettings myPhpCodeStyleSettings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)expression.getContainingFile(), PhpCodeStyleSettings.class);
        return expression.isShortSyntax() && !myPhpCodeStyleSettings.FORCE_SHORT_DECLARATION_ARRAY_STYLE;
    }

    @Override
    public int getLeftStartOffset(ArrayCreationExpression expression) {
        ASTNode lBracketNode = expression.getNode().findChildByType(PhpTokenTypes.chLBRACKET);
        if (lBracketNode != null) {
            return lBracketNode.getTextRange().getStartOffset();
        }
        return -1;
    }

    @Override
    public int getRightStartOffset(ArrayCreationExpression expression) {
        ASTNode lBracketNode = expression.getNode().findChildByType(PhpTokenTypes.chLBRACKET);
        if (lBracketNode != null) {
            return lBracketNode.getTextRange().getEndOffset();
        }
        return -1;
    }

    @Override
    public int getEndOffset(ArrayCreationExpression expression) {
        ASTNode rBracketNode = expression.getNode().findChildByType(PhpTokenTypes.chRBRACKET);
        if (rBracketNode != null) {
            return rBracketNode.getTextRange().getStartOffset();
        }
        return -1;
    }

    @Override
    public String openStringToInsert() {
        return OPEN_ARRAY_DECLARATION;
    }

    @Override
    String closeStringToInsert() {
        return CLOSE_ARRAY;
    }

    @NotNull
    public String getText() {
        String string = TEXT;
        if (string == null) {
            PhpConvertToTraditionalArraySyntaxIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/intentions/array/PhpConvertToTraditionalArraySyntaxIntention", "getText"));
    }
}

