/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.docker;

import com.intellij.docker.compose.configuration.beans.common.RestartPolicy;
import com.intellij.docker.compose.service.DockerComposeServiceClient;
import com.intellij.docker.compose.service.commands.AbstractServiceCmd;
import com.intellij.docker.compose.service.commands.ComposeServiceRunCmd;
import com.intellij.docker.compose.service.commands.ComposeServiceUpCmd;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.docker.remote.run.runtime.WrappedInternalServerErrorException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.ColoredRemoteProcessHandler;
import com.intellij.remote.RemoteProcess;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.remote.PhpRemoteProcessRunner;
import com.jetbrains.php.remote.docker.PhpDockerComposePrefixProcessor;
import com.jetbrains.php.remote.docker.PhpDockerHelpersManager;
import com.jetbrains.php.remote.docker.PhpDockerProcessUtil;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDockerComposeRemoteProcessRunner
extends PhpRemoteProcessRunner {
    private static final PhpDockerComposeRemoteProcessRunner ourInstance = new PhpDockerComposeRemoteProcessRunner();

    @NotNull
    public static PhpRemoteProcessRunner getInstance() {
        PhpDockerComposeRemoteProcessRunner phpDockerComposeRemoteProcessRunner = ourInstance;
        if (phpDockerComposeRemoteProcessRunner == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(0);
        }
        return phpDockerComposeRemoteProcessRunner;
    }

    @NotNull
    public ProcessOutput getProcessOutput(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData sdkData, @NotNull GeneralCommandLine commandLine, @NotNull String title, @Nullable JComponent component) throws ExecutionException, InterruptedException {
        ProcessOutput processOutput;
        DockerComposeCredentialsHolder docker;
        if (project == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(1);
        }
        if (sdkData == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(2);
        }
        if (commandLine == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(3);
        }
        if (title == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(4);
        }
        if ((docker = PhpDockerProcessUtil.tryGetDockerCredentials(sdkData)) == null) {
            throw new IllegalArgumentException();
        }
        try {
            RemoteDockerRuntime dockerRuntime = PhpDockerProcessUtil.createDockerRuntime(docker, project);
            DockerComposeServiceClient serviceClient = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime);
            ComposeServiceRunCmd cmd = serviceClient.runServiceCmd();
            PhpDockerComposeRemoteProcessRunner.fillSettings(dockerRuntime, commandLine, docker, (AbstractServiceCmd)cmd, true);
            KillableColoredProcessHandler processHandler = ((ComposeServiceRunCmd)cmd.withRestartPolicy((RestartPolicy)RestartPolicy.noRestart())).execute();
            processOutput = new CapturingProcessRunner((BaseProcessHandler)processHandler).runProcess();
        }
        catch (WrappedInternalServerErrorException e) {
            throw DockerUtil.propagateInternalServerErrorException((ServerRuntimeException)((Object)e));
        }
        catch (ServerRuntimeException | IOException e) {
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
        catch (UndeclaredThrowableException e) {
            throw (UndeclaredThrowableException)DockerUtil.propagateRuntimeExceptionCause((RuntimeException)e, InterruptedException.class);
        }
        if (processOutput == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(5);
        }
        return processOutput;
    }

    private static void fillSettings(@NotNull RemoteDockerRuntime dockerRuntime, @NotNull GeneralCommandLine commandLine, @NotNull DockerComposeCredentialsHolder docker, @NotNull AbstractServiceCmd service, boolean withHelpers) throws IOException, ServerRuntimeException {
        if (dockerRuntime == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(6);
        }
        if (commandLine == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(7);
        }
        if (docker == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(8);
        }
        if (service == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(9);
        }
        service.withConfigurationPath(docker.getComposeFilePaths());
        service.withServiceName(docker.getComposeServiceName());
        File workingDir = commandLine.getWorkDirectory();
        if (workingDir != null) {
            service.withWorkingDir(DockerUtil.toUnixPath((String)workingDir.getPath()));
        }
        service.withEntrypoint(new String[]{commandLine.getExePath()});
        List<String> params = Arrays.stream(commandLine.getParametersList().getArray()).map(p -> StringUtil.replace((String)p, (String)"$", (String)"$$")).collect(Collectors.toList());
        service.withCommand(params.toArray(new String[0]));
        if (withHelpers) {
            service.withSharedVolume(PhpDockerHelpersManager.getHelpersContainerSharedVolume(dockerRuntime));
        }
        HashMap newEnvs = ContainerUtil.newHashMap();
        newEnvs.put("JETBRAINS_REMOTE_RUN", "1");
        newEnvs.putAll(commandLine.getEnvironment());
        service.withEnvironment((Map)newEnvs);
        TreeMap envs = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        if (docker.getEnvs().isPassParentEnvs()) {
            envs.putAll(EnvironmentUtil.getEnvironmentMap());
        }
        envs.putAll(docker.getEnvs().getEnvs());
        service.withEnvs(envs);
    }

    @NotNull
    public Process getRemoteProcess(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData sdkData, @NotNull GeneralCommandLine commandLine, PathMappingSettings.PathMapping ... additionalMappings) throws ExecutionException {
        if (project == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(10);
        }
        if (sdkData == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(11);
        }
        if (commandLine == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(12);
        }
        if (additionalMappings == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(13);
        }
        Process process = PhpDockerComposeRemoteProcessRunner.startRemoteProcess(project, sdkData, commandLine, true, additionalMappings);
        if (process == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(14);
        }
        return process;
    }

    public boolean canRunBackgroundProcess(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData sdkData) {
        if (project == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(15);
        }
        if (sdkData == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(16);
        }
        return false;
    }

    @NotNull
    public Process getRemoteBackgroundProcess(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData sdkData, @NotNull GeneralCommandLine commandLine, PathMappingSettings.PathMapping ... additionalMappings) throws ExecutionException {
        if (project == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(17);
        }
        if (sdkData == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(18);
        }
        if (commandLine == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(19);
        }
        if (additionalMappings == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(20);
        }
        Process process = PhpDockerComposeRemoteProcessRunner.startRemoteProcess(project, sdkData, commandLine, false, additionalMappings);
        if (process == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(21);
        }
        return process;
    }

    @NotNull
    private static Process startRemoteProcess(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData sdkData, @NotNull GeneralCommandLine commandLine, boolean withHelpers, PathMappingSettings.PathMapping ... additionalMappings) throws ExecutionException {
        Process process;
        DockerComposeCredentialsHolder docker;
        if (project == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(22);
        }
        if (sdkData == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(23);
        }
        if (commandLine == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(24);
        }
        if (additionalMappings == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(25);
        }
        if ((docker = PhpDockerProcessUtil.tryGetDockerCredentials(sdkData)) == null) {
            throw new IllegalArgumentException();
        }
        try {
            RemoteDockerRuntime dockerRuntime = PhpDockerProcessUtil.createDockerRuntime(docker, project);
            DockerComposeServiceClient serviceClient = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime);
            ComposeServiceUpCmd cmd = serviceClient.upServicesCmd();
            PhpDockerComposeRemoteProcessRunner.fillSettings(dockerRuntime, commandLine, docker, (AbstractServiceCmd)cmd, withHelpers);
            VolumesBuilder volumesBuilder = VolumesBuilder.builder();
            for (PathMappingSettings.PathMapping mapping : additionalMappings) {
                volumesBuilder.addBoundVolume(mapping.getRemoteRoot(), FileUtil.toSystemDependentName((String)mapping.getLocalRoot()));
            }
            cmd.withVolumes(volumesBuilder.build());
            process = cmd.execute().getProcess();
        }
        catch (WrappedInternalServerErrorException e) {
            throw DockerUtil.propagateInternalServerErrorException((ServerRuntimeException)((Object)e));
        }
        catch (ServerRuntimeException | IOException e) {
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
        if (process == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(26);
        }
        return process;
    }

    @NotNull
    public ProcessHandler createRemoteProcessHandler(Process process, String commandTitle, Charset charset, PhpRemoteSdkAdditionalData remoteData) {
        String composeServiceName;
        DockerComposeCredentialsHolder credentials = (DockerComposeCredentialsHolder)ObjectUtils.tryCast((Object)remoteData.connectionCredentials().getCredentials(), DockerComposeCredentialsHolder.class);
        String string = composeServiceName = credentials != null ? credentials.getComposeServiceName() : null;
        if (process instanceof RemoteProcess) {
            MyColoredRemoteProcessHandler myColoredRemoteProcessHandler = new MyColoredRemoteProcessHandler((RemoteProcess)process, commandTitle, charset, composeServiceName);
            if (myColoredRemoteProcessHandler == null) {
                PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(27);
            }
            return myColoredRemoteProcessHandler;
        }
        MyColoredKillableRemoteProcessHandler myColoredKillableRemoteProcessHandler = new MyColoredKillableRemoteProcessHandler(process, commandTitle, charset, composeServiceName);
        if (myColoredKillableRemoteProcessHandler == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(28);
        }
        return myColoredKillableRemoteProcessHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/docker/PhpDockerComposeRemoteProcessRunner";
                break;
            }
            case 1: 
            case 10: 
            case 15: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 11: 
            case 16: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkData";
                break;
            }
            case 3: 
            case 7: 
            case 12: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docker";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 13: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/docker/PhpDockerComposeRemoteProcessRunner";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutput";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteProcess";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteBackgroundProcess";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "startRemoteProcess";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoteProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fillSettings";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteProcess";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "canRunBackgroundProcess";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteBackgroundProcess";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "startRemoteProcess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyColoredKillableRemoteProcessHandler
    extends KillableColoredProcessHandler
    implements AnsiEscapeDecoder.ColoredChunksAcceptor {
        private final PhpDockerComposePrefixProcessor myProcessor;

        MyColoredKillableRemoteProcessHandler(@NotNull Process process, String commandLine, Charset charset, String composeServiceName) {
            if (process == null) {
                MyColoredKillableRemoteProcessHandler.$$$reportNull$$$0(0);
            }
            super(process, commandLine, charset);
            this.myProcessor = new PhpDockerComposePrefixProcessor(composeServiceName, (x$0, x$1) -> super.coloredTextAvailable(x$0, x$1));
        }

        public void coloredChunksAvailable(@NotNull List<Pair<String, Key>> chunks) {
            if (chunks == null) {
                MyColoredKillableRemoteProcessHandler.$$$reportNull$$$0(1);
            }
            this.myProcessor.accept(chunks);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chunks";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/remote/docker/PhpDockerComposeRemoteProcessRunner$MyColoredKillableRemoteProcessHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "coloredChunksAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyColoredRemoteProcessHandler
    extends ColoredRemoteProcessHandler<RemoteProcess>
    implements AnsiEscapeDecoder.ColoredChunksAcceptor {
        private final PhpDockerComposePrefixProcessor myProcessor;

        MyColoredRemoteProcessHandler(@NotNull RemoteProcess process, String commandLine, Charset charset, String composeServiceName) {
            if (process == null) {
                MyColoredRemoteProcessHandler.$$$reportNull$$$0(0);
            }
            super(process, commandLine, charset);
            this.myProcessor = new PhpDockerComposePrefixProcessor(composeServiceName, (x$0, x$1) -> super.coloredTextAvailable(x$0, x$1));
        }

        public void coloredChunksAvailable(@NotNull List<Pair<String, Key>> chunks) {
            if (chunks == null) {
                MyColoredRemoteProcessHandler.$$$reportNull$$$0(1);
            }
            this.myProcessor.accept(chunks);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chunks";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/remote/docker/PhpDockerComposeRemoteProcessRunner$MyColoredRemoteProcessHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "coloredChunksAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

