/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.docker;

import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.run.common.EnvsBuilder;
import com.intellij.docker.remote.run.common.ExtraHostsBuilder;
import com.intellij.docker.remote.run.common.PortsBuilder;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.DockerAgentDeploymentConfigImpl;
import com.intellij.docker.remote.run.runtime.DockerExecProcess;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.docker.remote.run.runtime.WrappedInternalServerErrorException;
import com.intellij.docker.remote.run.runtime.WrappedNotFoundException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.php.remote.PhpRemoteProcessRunner;
import com.jetbrains.php.remote.docker.PhpDockerContainerSettingsManager;
import com.jetbrains.php.remote.docker.PhpDockerHelpersManager;
import com.jetbrains.php.remote.docker.PhpDockerProcessUtil;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDockerRemoteProcessRunner
extends PhpRemoteProcessRunner {
    private static final Logger LOG = Logger.getInstance(PhpDockerRemoteProcessRunner.class);
    private static final PhpDockerRemoteProcessRunner ourInstance = new PhpDockerRemoteProcessRunner();

    @NotNull
    public static PhpRemoteProcessRunner getInstance() {
        PhpDockerRemoteProcessRunner phpDockerRemoteProcessRunner = ourInstance;
        if (phpDockerRemoteProcessRunner == null) {
            PhpDockerRemoteProcessRunner.$$$reportNull$$$0(0);
        }
        return phpDockerRemoteProcessRunner;
    }

    @NotNull
    public ProcessOutput getProcessOutput(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData sdkData, @NotNull GeneralCommandLine commandLine, @NotNull String title, @Nullable JComponent component) throws ExecutionException {
        ProcessOutput processOutput;
        DockerCredentialsHolder docker;
        if (project == null) {
            PhpDockerRemoteProcessRunner.$$$reportNull$$$0(1);
        }
        if (sdkData == null) {
            PhpDockerRemoteProcessRunner.$$$reportNull$$$0(2);
        }
        if (commandLine == null) {
            PhpDockerRemoteProcessRunner.$$$reportNull$$$0(3);
        }
        if (title == null) {
            PhpDockerRemoteProcessRunner.$$$reportNull$$$0(4);
        }
        if ((docker = DockerCredentialsHolder.tryGetDockerCredentials((RemoteSdkAdditionalData)sdkData)) == null) {
            throw new IllegalArgumentException();
        }
        try {
            RemoteDockerRuntime dockerRuntime = PhpDockerProcessUtil.createDockerRuntime(docker, project);
            DockerAgentDeploymentConfigImpl config = PhpDockerRemoteProcessRunner.createContainerConfig(dockerRuntime, commandLine, docker.getImageName(), null, true);
            DockerContainerSettings settings = PhpDockerContainerSettingsManager.getInstance(project).getSettings(sdkData.getInterpreterId());
            if (settings != null && !settings.getVolumeBindings().isEmpty()) {
                VolumesBuilder volumesBuilder = VolumesBuilder.builder();
                for (DockerVolumeBinding binding : settings.getVolumeBindings()) {
                    String hostPath = binding.getHostPath();
                    if (!StringUtil.isNotEmpty((String)hostPath)) continue;
                    volumesBuilder.addBoundVolume(binding.getContainerPath(), DockerUtil.toUnixPath((String)hostPath), binding.isReadOnly());
                }
                config.withVolumeBindings(volumesBuilder.build());
            }
            RemoteDockerApplicationRuntime applicationRuntime = RemoteDockerApplicationRuntime.createWithPullImage((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfigImpl)config);
            processOutput = applicationRuntime.startAndGetOutput();
        }
        catch (WrappedNotFoundException e) {
            throw DockerUtil.propagateNotFoundException((ServerRuntimeException)((Object)e), (String)docker.getImageName());
        }
        catch (WrappedInternalServerErrorException e) {
            throw DockerUtil.propagateInternalServerErrorException((ServerRuntimeException)((Object)e));
        }
        catch (ServerRuntimeException | IOException e) {
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
        if (processOutput == null) {
            PhpDockerRemoteProcessRunner.$$$reportNull$$$0(5);
        }
        return processOutput;
    }

    @NotNull
    private static DockerAgentDeploymentConfigImpl createContainerConfig(@NotNull RemoteDockerRuntime dockerRuntime, @NotNull GeneralCommandLine commandLine, @NotNull String imageName, @Nullable List<DockerEnvVarImpl> envs, boolean withHelpers) throws IOException, ServerRuntimeException {
        if (dockerRuntime == null) {
            PhpDockerRemoteProcessRunner.$$$reportNull$$$0(6);
        }
        if (commandLine == null) {
            PhpDockerRemoteProcessRunner.$$$reportNull$$$0(7);
        }
        if (imageName == null) {
            PhpDockerRemoteProcessRunner.$$$reportNull$$$0(8);
        }
        DockerAgentDeploymentConfigImpl result = new DockerAgentDeploymentConfigImpl(imageName, null).withEntrypoint(new String[]{commandLine.getExePath()});
        File workingDir = commandLine.getWorkDirectory();
        if (workingDir != null) {
            result.withWorkingDir(DockerUtil.toUnixPath((String)workingDir.getPath()));
        }
        result.withCommand(commandLine.getParametersList().getArray());
        if (withHelpers) {
            result.withVolumesFrom(PhpDockerHelpersManager.getHelpersContainerVolumesFrom(dockerRuntime));
        }
        EnvsBuilder envsBuilder = EnvsBuilder.builder().addEnv("JETBRAINS_REMOTE_RUN", "1").addEnvs(commandLine.getEnvironment());
        if (envs != null) {
            envsBuilder.addEnvs(envs);
        }
        result.withEnvs(envsBuilder.withPassParentEnvironment(true).buildEnvs());
        DockerAgentDeploymentConfigImpl dockerAgentDeploymentConfigImpl = result;
        if (dockerAgentDeploymentConfigImpl == null) {
            PhpDockerRemoteProcessRunner.$$$reportNull$$$0(9);
        }
        return dockerAgentDeploymentConfigImpl;
    }

    @NotNull
    public Process getRemoteProcess(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData sdkData, @NotNull GeneralCommandLine commandLine, PathMappingSettings.PathMapping ... additionalMappings) throws ExecutionException {
        if (project == null) {
            PhpDockerRemoteProcessRunner.$$$reportNull$$$0(10);
        }
        if (sdkData == null) {
            PhpDockerRemoteProcessRunner.$$$reportNull$$$0(11);
        }
        if (commandLine == null) {
            PhpDockerRemoteProcessRunner.$$$reportNull$$$0(12);
        }
        if (additionalMappings == null) {
            PhpDockerRemoteProcessRunner.$$$reportNull$$$0(13);
        }
        RemoteProcess remoteProcess = PhpDockerRemoteProcessRunner.startRemoteProcess(project, sdkData, commandLine, true, additionalMappings);
        if (remoteProcess == null) {
            PhpDockerRemoteProcessRunner.$$$reportNull$$$0(14);
        }
        return remoteProcess;
    }

    @NotNull
    public Process getRemoteBackgroundProcess(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData sdkData, @NotNull GeneralCommandLine commandLine, PathMappingSettings.PathMapping ... additionalMappings) throws ExecutionException {
        if (project == null) {
            PhpDockerRemoteProcessRunner.$$$reportNull$$$0(15);
        }
        if (sdkData == null) {
            PhpDockerRemoteProcessRunner.$$$reportNull$$$0(16);
        }
        if (commandLine == null) {
            PhpDockerRemoteProcessRunner.$$$reportNull$$$0(17);
        }
        if (additionalMappings == null) {
            PhpDockerRemoteProcessRunner.$$$reportNull$$$0(18);
        }
        RemoteProcess remoteProcess = PhpDockerRemoteProcessRunner.startRemoteProcess(project, sdkData, commandLine, false, additionalMappings);
        if (remoteProcess == null) {
            PhpDockerRemoteProcessRunner.$$$reportNull$$$0(19);
        }
        return remoteProcess;
    }

    @NotNull
    private static RemoteProcess startRemoteProcess(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData sdkData, @NotNull GeneralCommandLine commandLine, boolean withHelpers, PathMappingSettings.PathMapping ... additionalMappings) throws ExecutionException {
        DockerExecProcess dockerExecProcess;
        DockerCredentialsHolder docker;
        if (project == null) {
            PhpDockerRemoteProcessRunner.$$$reportNull$$$0(20);
        }
        if (sdkData == null) {
            PhpDockerRemoteProcessRunner.$$$reportNull$$$0(21);
        }
        if (commandLine == null) {
            PhpDockerRemoteProcessRunner.$$$reportNull$$$0(22);
        }
        if (additionalMappings == null) {
            PhpDockerRemoteProcessRunner.$$$reportNull$$$0(23);
        }
        if ((docker = DockerCredentialsHolder.tryGetDockerCredentials((RemoteSdkAdditionalData)sdkData)) == null) {
            throw new IllegalArgumentException();
        }
        DockerContainerSettings settings = PhpDockerContainerSettingsManager.getInstance(project).getSettings(sdkData.getInterpreterId());
        try {
            RemoteDockerRuntime dockerRuntime = PhpDockerProcessUtil.createDockerRuntime(docker, project);
            List envs = settings == null ? null : settings.getEnvVars();
            DockerAgentDeploymentConfigImpl config = PhpDockerRemoteProcessRunner.createContainerConfig(dockerRuntime, commandLine, docker.getImageName(), envs, withHelpers);
            VolumesBuilder volumesBuilder = VolumesBuilder.builder();
            if (settings != null) {
                volumesBuilder.addBoundVolumes((Iterable)settings.getVolumeBindings());
            }
            for (PathMappingSettings.PathMapping mapping : additionalMappings) {
                volumesBuilder.addBoundVolume(mapping.getRemoteRoot(), DockerUtil.toUnixPath((String)mapping.getLocalRoot()));
            }
            config.withVolumeBindings(volumesBuilder.build());
            PortsBuilder portsBuilder = PortsBuilder.builder();
            if (settings != null) {
                portsBuilder.addPortBindings(settings.getPortBindings());
            }
            if (settings != null && settings.isPublishAllPorts()) {
                config.withPublishAllPorts(true);
            } else {
                config.withPortBindings(portsBuilder.buildPortBindings());
            }
            config.withExposedPorts(portsBuilder.buildExposedPorts());
            if (settings != null) {
                if (settings.isNetworkDisabled()) {
                    config.withNetworkDisabled(true);
                } else if (StringUtil.isNotEmpty((String)settings.getNetworkMode())) {
                    config.withNetworkMode(settings.getNetworkMode());
                }
            }
            if (settings != null) {
                config.withLinks(settings.getLinks());
            }
            if (settings != null) {
                config.withExtraHosts(ExtraHostsBuilder.builder().addExtraHosts(settings.getExtraHosts()).build());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Create container with: " + config.toString());
            }
            dockerExecProcess = DockerExecProcess.Factory.startProcessWithRemove((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfigImpl)config);
        }
        catch (WrappedNotFoundException e) {
            throw DockerUtil.propagateNotFoundException((ServerRuntimeException)((Object)e), (String)docker.getImageName());
        }
        catch (WrappedInternalServerErrorException e) {
            throw DockerUtil.propagateInternalServerErrorException((ServerRuntimeException)((Object)e));
        }
        catch (ServerRuntimeException | IOException e) {
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
        if (dockerExecProcess == null) {
            PhpDockerRemoteProcessRunner.$$$reportNull$$$0(24);
        }
        return dockerExecProcess;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/docker/PhpDockerRemoteProcessRunner";
                break;
            }
            case 1: 
            case 10: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 11: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkData";
                break;
            }
            case 3: 
            case 7: 
            case 12: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageName";
                break;
            }
            case 13: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/docker/PhpDockerRemoteProcessRunner";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutput";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createContainerConfig";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteProcess";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteBackgroundProcess";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "startRemoteProcess";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createContainerConfig";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteProcess";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteBackgroundProcess";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "startRemoteProcess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

