/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ContainerProvider;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.navigation.BackgroundUpdaterTask;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationAction;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.util.Consumer;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoImplementationHandler
extends GotoTargetHandler {
    @Override
    protected String getFeatureUsedKey() {
        return "navigation.goto.implementation";
    }

    @Override
    @Nullable
    public GotoTargetHandler.GotoData getSourceAndTargetElements(@NotNull Editor editor, PsiFile file2) {
        if (editor == null) {
            GotoImplementationHandler.$$$reportNull$$$0(0);
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement source = TargetElementUtil.getInstance().findTargetElement(editor, ImplementationSearcher.getFlags(), offset);
        if (source == null) {
            return null;
        }
        return this.createDataForSource(editor, offset, source);
    }

    private GotoTargetHandler.GotoData createDataForSource(@NotNull Editor editor, int offset, PsiElement source) {
        if (editor == null) {
            GotoImplementationHandler.$$$reportNull$$$0(1);
        }
        final PsiReference reference2 = TargetElementUtil.findReference(editor, offset);
        final TargetElementUtil instance = TargetElementUtil.getInstance();
        PsiElement[] targets = new ImplementationSearcher.FirstImplementationsSearcher(){

            @Override
            protected boolean accept(PsiElement element) {
                return instance.acceptImplementationForReference(reference2, element);
            }

            @Override
            protected boolean canShowPopupWithOneItem(PsiElement element) {
                return false;
            }
        }.searchImplementations(editor, source, offset);
        if (targets == null) {
            return null;
        }
        GotoTargetHandler.GotoData gotoData = new GotoTargetHandler.GotoData(source, targets, Collections.emptyList());
        gotoData.listUpdaterTask = new ImplementationsUpdaterTask(gotoData, editor, offset, reference2){

            @Override
            public void onSuccess() {
                super.onSuccess();
                PsiElement oneElement = this.getTheOnlyOneElement();
                if (oneElement != null && GotoImplementationHandler.this.navigateToElement(oneElement)) {
                    this.myPopup.cancel();
                }
            }
        };
        return gotoData;
    }

    @Override
    protected void chooseFromAmbiguousSources(Editor editor, PsiFile file2, Consumer<? super GotoTargetHandler.GotoData> successCallback) {
        int offset = editor.getCaretModel().getOffset();
        PsiElementProcessor navigateProcessor = element -> {
            GotoTargetHandler.GotoData data = this.createDataForSource(editor, offset, element);
            if (data != null) {
                successCallback.consume((Object)data);
            }
            return true;
        };
        GotoDeclarationAction.chooseAmbiguousTarget(editor, offset, (PsiElementProcessor<? super PsiElement>)navigateProcessor, CodeInsightBundle.message((String)"declaration.navigation.title", (Object[])new Object[0]), null);
    }

    private static PsiElement getContainer(PsiElement refElement) {
        for (ContainerProvider provider : (ContainerProvider[])ContainerProvider.EP_NAME.getExtensions()) {
            PsiElement container = provider.getContainer(refElement);
            if (container == null) continue;
            return container;
        }
        return refElement.getParent();
    }

    @Override
    @NotNull
    protected String getChooserTitle(@NotNull PsiElement sourceElement, String name, int length, boolean finished2) {
        String fullName;
        ItemPresentation presentation;
        if (sourceElement == null) {
            GotoImplementationHandler.$$$reportNull$$$0(2);
        }
        if ((presentation = ((NavigationItem)sourceElement).getPresentation()) == null) {
            fullName = name;
        } else {
            PsiElement container = GotoImplementationHandler.getContainer(sourceElement);
            ItemPresentation containerPresentation = container == null || container instanceof PsiFile ? null : ((NavigationItem)container).getPresentation();
            String containerText = containerPresentation == null ? null : containerPresentation.getPresentableText();
            fullName = (containerText == null ? "" : containerText + ".") + presentation.getPresentableText();
        }
        String string = CodeInsightBundle.message((String)"goto.implementation.chooserTitle", (Object[])new Object[]{fullName, length, finished2 ? "" : " so far"});
        if (string == null) {
            GotoImplementationHandler.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getFindUsagesTitle(@NotNull PsiElement sourceElement, String name, int length) {
        if (sourceElement == null) {
            GotoImplementationHandler.$$$reportNull$$$0(4);
        }
        String string = CodeInsightBundle.message((String)"goto.implementation.findUsages.title", (Object[])new Object[]{name, length});
        if (string == null) {
            GotoImplementationHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getNotFoundMessage(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            GotoImplementationHandler.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            GotoImplementationHandler.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            GotoImplementationHandler.$$$reportNull$$$0(8);
        }
        String string = CodeInsightBundle.message((String)"goto.implementation.notFound", (Object[])new Object[0]);
        if (string == null) {
            GotoImplementationHandler.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/navigation/GotoImplementationHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/navigation/GotoImplementationHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChooserTitle";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesTitle";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotFoundMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSourceAndTargetElements";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createDataForSource";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChooserTitle";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFindUsagesTitle";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNotFoundMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ImplementationsUpdaterTask
    extends BackgroundUpdaterTask {
        private final Editor myEditor;
        private final int myOffset;
        private final GotoTargetHandler.GotoData myGotoData;
        private final PsiReference myReference;

        ImplementationsUpdaterTask(final @NotNull GotoTargetHandler.GotoData gotoData, Editor editor, int offset, PsiReference reference2) {
            if (gotoData == null) {
                ImplementationsUpdaterTask.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                ImplementationsUpdaterTask.$$$reportNull$$$0(1);
            }
            super(gotoData.source.getProject(), ImplementationSearcher.SEARCHING_FOR_IMPLEMENTATIONS, ImplementationsUpdaterTask.createComparatorWrapper(Comparator.comparing(new Function<PsiElement, Comparable>(){

                @Override
                public Comparable apply(PsiElement e1) {
                    return GotoImplementationHandler.this.getRenderer(e1, gotoData).getComparingObject(e1);
                }
            })));
            this.myEditor = editor;
            this.myOffset = offset;
            this.myGotoData = gotoData;
            this.myReference = reference2;
        }

        @Override
        public void run(final @NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                ImplementationsUpdaterTask.$$$reportNull$$$0(2);
            }
            super.run(indicator);
            for (PsiElement element : this.myGotoData.targets) {
                if (this.updateComponent(element)) continue;
                return;
            }
            new ImplementationSearcher.BackgroundableImplementationSearcher(){

                @Override
                protected void processElement(PsiElement element) {
                    indicator.checkCanceled();
                    if (!TargetElementUtil.getInstance().acceptImplementationForReference(ImplementationsUpdaterTask.this.myReference, element)) {
                        return;
                    }
                    if (ImplementationsUpdaterTask.this.myGotoData.addTarget(element) && !ImplementationsUpdaterTask.this.updateComponent(element)) {
                        indicator.cancel();
                    }
                }
            }.searchImplementations(this.myEditor, this.myGotoData.source, this.myOffset);
        }

        @Override
        public String getCaption(int size) {
            String name = ElementDescriptionUtil.getElementDescription((PsiElement)this.myGotoData.source, (ElementDescriptionLocation)UsageViewShortNameLocation.INSTANCE);
            return GotoImplementationHandler.this.getChooserTitle(this.myGotoData.source, name, size, this.isFinished());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gotoData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/navigation/GotoImplementationHandler$ImplementationsUpdaterTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

