/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.socketConnection.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.socketConnection.AbstractRequest;
import com.intellij.util.io.socketConnection.AbstractResponse;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.util.io.socketConnection.RequestResponseExternalizerFactory;
import com.intellij.util.io.socketConnection.impl.SocketConnectionBase;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.jetbrains.annotations.NotNull;

public class ServerSocketConnectionImpl<Request extends AbstractRequest, Response extends AbstractResponse>
extends SocketConnectionBase<Request, Response> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.io.socketConnection.impl.ServerSocketConnectionImpl");
    private ServerSocket myServerSocket;
    private final int myDefaultPort;
    private final int myConnectionAttempts;

    public ServerSocketConnectionImpl(int defaultPort, int connectionAttempts, @NotNull RequestResponseExternalizerFactory<Request, Response> factory) {
        if (factory == null) {
            ServerSocketConnectionImpl.$$$reportNull$$$0(0);
        }
        super(factory);
        this.myDefaultPort = defaultPort;
        this.myConnectionAttempts = connectionAttempts;
    }

    @Override
    public void open() throws IOException {
        this.myServerSocket = this.createSocket();
        this.setPort(this.myServerSocket.getLocalPort());
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.waitForConnection();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                this.setStatus(ConnectionStatus.CONNECTION_FAILED, "Connection failed: " + e.getMessage());
            }
        });
    }

    @NotNull
    private ServerSocket createSocket() throws IOException {
        IOException exc = null;
        for (int i = 0; i < this.myConnectionAttempts; ++i) {
            ServerSocket serverSocket;
            block3: {
                int port = this.myDefaultPort + i;
                try {
                    serverSocket = new ServerSocket(port);
                    if (serverSocket != null) break block3;
                }
                catch (IOException e) {
                    exc = e;
                    LOG.info((Throwable)e);
                    continue;
                }
                ServerSocketConnectionImpl.$$$reportNull$$$0(1);
            }
            return serverSocket;
        }
        throw exc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForConnection() throws IOException {
        this.addThreadToInterrupt();
        try {
            this.setStatus(ConnectionStatus.WAITING_FOR_CONNECTION, null);
            LOG.debug("waiting for connection on port " + this.getPort());
            try (Socket socket = this.myServerSocket.accept();){
                this.attachToSocket(socket);
            }
        }
        finally {
            this.myServerSocket.close();
            this.removeThreadToInterrupt();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/socketConnection/impl/ServerSocketConnectionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/socketConnection/impl/ServerSocketConnectionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSocket";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

