/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.ObjectUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDatabaseModifier {
    private final LocalDataSource myLocalDataSource;
    private final DatabaseDepartment myDepartment;
    private final LoaderContext myContext;
    private final String myTitle;
    private final SearchPath mySearchPath;
    private final ErrorHandler myErrorHandler;
    protected DbDataSource myDataSource;

    protected AbstractDatabaseModifier(@NotNull DatabaseDepartment department, @NotNull DbDataSource dataSource, @Nullable SearchPath searchPath, @NotNull String title) {
        if (department == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(1);
        }
        if (title == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(2);
        }
        this.myErrorHandler = new ErrorHandler();
        this.myDepartment = department;
        this.myDataSource = dataSource;
        this.mySearchPath = searchPath;
        this.myTitle = title;
        DatabaseSystem delegate = dataSource.getDelegate();
        this.myLocalDataSource = (LocalDataSource)ObjectUtils.tryCast((Object)delegate, LocalDataSource.class);
        this.myContext = new LoaderContext(dataSource.getProject(), this.myLocalDataSource == null ? new LocalDataSource() : this.myLocalDataSource);
    }

    @NotNull
    public DbDataSource getDataSource() {
        DbDataSource dbDataSource = this.myDataSource;
        if (dbDataSource == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(3);
        }
        return dbDataSource;
    }

    @NotNull
    public LoaderContext getContext() {
        LoaderContext loaderContext = this.myContext;
        if (loaderContext == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(4);
        }
        return loaderContext;
    }

    @NotNull
    public ErrorHandler getErrorHandler() {
        ErrorHandler errorHandler = this.myErrorHandler;
        if (errorHandler == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(5);
        }
        return errorHandler;
    }

    @NotNull
    public CompletionStage<?> runStatements(boolean nonModalSync) {
        if (this.myLocalDataSource == null) {
            CompletableFuture completableFuture = AsyncUtil.cancelled();
            if (completableFuture == null) {
                AbstractDatabaseModifier.$$$reportNull$$$0(6);
            }
            return completableFuture;
        }
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (indicator == null) {
            ProgressIndicatorEx backgroundIndicator = AsyncUtil.createBackgroundIndicator(this.myDataSource.getProject(), this.myTitle);
            CompletionStage completionStage = AsyncUtil.runTask(() -> this.runStatementsInner(nonModalSync, (ProgressIndicator)backgroundIndicator), backgroundIndicator);
            if (completionStage == null) {
                AbstractDatabaseModifier.$$$reportNull$$$0(7);
            }
            return completionStage;
        }
        CompletionStage<?> completionStage = this.runStatementsInner(nonModalSync, indicator);
        if (completionStage == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(8);
        }
        return completionStage;
    }

    @NotNull
    protected CompletionStage<?> runStatementsInner(boolean nonModalSync, ProgressIndicator indicator) {
        Project project = this.myDataSource.getProject();
        DatabaseSessionManager.Facade facade = DatabaseSessionManager.facade(project, this.myLocalDataSource, this.mySearchPath, this.myErrorHandler, this.myDepartment);
        CompletionStage<Object> completionStage = this.scheduleRequests(indicator, facade).handleAsync((r, th) -> {
            if (nonModalSync) {
                ApplicationManager.getApplication().invokeLater(() -> this.runSync(), ModalityState.NON_MODAL);
            } else {
                AsyncUtil.underProgress(this::runSync, indicator);
            }
            if (!this.myErrorHandler.getSummary().isEmpty()) {
                DataSourceUiUtil.showNotification(project, "", this.myErrorHandler.getSummary(), true);
            }
            if (th != null || this.myErrorHandler.hasErrors()) {
                throw new ProcessCanceledException();
            }
            return r;
        }, AsyncUtil.EDT_EXECUTOR);
        if (completionStage == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(9);
        }
        return completionStage;
    }

    @NotNull
    public CompletionStage<?> scheduleRequests(@NotNull ProgressIndicator indicator, @NotNull DatabaseSessionManager.Facade facade) {
        if (indicator == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(10);
        }
        if (facade == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(11);
        }
        CompletionStage<?> completionStage = this.getExecutor().execute(indicator, facade, this.myErrorHandler);
        if (completionStage == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(12);
        }
        return completionStage;
    }

    public void runSync() {
        Project project = this.myDataSource.getProject();
        DataSourceUiUtil.performManualSyncTask(this.myContext).whenCompleteAsync((r, e) -> {
            DatabaseView view = DatabaseView.getDatabaseView(project);
            view.selectElement(this.getElement());
        }, AsyncUtil.EDT_EXECUTOR);
    }

    @Nullable
    private DbElement getElement() {
        DasObject info = AbstractDatabaseModifier.getDasObject(this.myContext.getElementToFocus());
        return info == null ? null : DbSqlUtil.findElement(this.myDataSource, ObjectPaths.of(info));
    }

    @Nullable
    private static DasObject getDasObject(@Nullable Object object) {
        return object instanceof DasSchemaChild ? (DasObject)object : (object instanceof DasColumn ? ((DasColumn)object).getTable() : (object instanceof DasTableKey ? ((DasTableKey)object).getTable() : null));
    }

    @NotNull
    protected abstract QueryExecutor getExecutor();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "department";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/AbstractDatabaseModifier";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/AbstractDatabaseModifier";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorHandler";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "runStatements";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "runStatementsInner";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleRequests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "scheduleRequests";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface QueryExecutor {
        public CompletionStage<?> execute(@NotNull ProgressIndicator var1, @NotNull DatabaseSessionManager.Facade var2, @NotNull ErrorHandler var3);
    }
}

