/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.documentation.JSDocBuilderParameterInfo;
import com.intellij.lang.javascript.documentation.JSDocBuilderSimpleInfo;
import com.intellij.lang.javascript.documentation.JSDocBuilderSymbolInfo;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JSDocBuilderMethodInfo
extends JSDocBuilderSymbolInfo {
    final Map<JSParameterItem, JSDocBuilderParameterInfo> parameterInfoMap;
    final JSDocBuilderSimpleInfo returnInfo;
    final Set<JSDocBuilderSimpleInfo> throwsInfos;
    final List<JSDocBuilderSimpleInfo> firesInfos;
    @NotNull
    private final JSFunctionItem myFunctionItem;
    String methodType;
    int parameterCount;

    JSDocBuilderMethodInfo(@NotNull JSFunctionItem functionItem, PsiElement element, PsiElement _contextElement) {
        if (functionItem == null) {
            JSDocBuilderMethodInfo.$$$reportNull$$$0(0);
        }
        super(element, _contextElement, false);
        this.parameterInfoMap = new LinkedHashMap<JSParameterItem, JSDocBuilderParameterInfo>();
        this.returnInfo = new JSDocBuilderSimpleInfo();
        this.throwsInfos = new LinkedHashSet<JSDocBuilderSimpleInfo>();
        this.firesInfos = new SmartList();
        this.parameterCount = 0;
        this.myFunctionItem = functionItem;
        JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)functionItem);
        if (containingClass != null) {
            this.namespace = containingClass.getQualifiedName();
        }
        for (JSParameterItem parameter : functionItem.getParameters()) {
            JSDocBuilderParameterInfo paramInfo = new JSDocBuilderParameterInfo();
            this.parameterInfoMap.put(parameter, paramInfo);
            paramInfo.type = parameter.getTypeIncludingOverridden();
            paramInfo.optional = parameter.isOptional();
            paramInfo.rest = parameter.getTypeDecorator().isRest();
            JSExpression initializer = parameter instanceof JSInitializerOwner ? ((JSInitializerOwner)parameter).getInitializer() : null;
            paramInfo.initialValue = initializer != null ? initializer.getText() : null;
        }
        this.returnInfo.type = JSFunctionImpl.getReturnTypeInContext(functionItem, null);
    }

    void mergeSignatureWith(@NotNull JSDocBuilderMethodInfo superMethodInfo) {
        if (superMethodInfo == null) {
            JSDocBuilderMethodInfo.$$$reportNull$$$0(1);
        }
        int index = 0;
        JSDocBuilderParameterInfo[] parameterInfosArray = superMethodInfo.parameterInfoMap.values().toArray(new JSDocBuilderParameterInfo[0]);
        for (Map.Entry<JSParameterItem, JSDocBuilderParameterInfo> entry : this.parameterInfoMap.entrySet()) {
            if (!entry.getValue().hasDescription()) {
                JSDocBuilderParameterInfo parameterInfo;
                JSDocBuilderParameterInfo info = superMethodInfo.parameterInfoMap.get(entry.getKey());
                if (info != null) {
                    parameterInfo = entry.getValue();
                    parameterInfo.mergeRawDescriptionAndPlaceHolders(info);
                } else if (index < parameterInfosArray.length) {
                    parameterInfo = entry.getValue();
                    JSDocBuilderParameterInfo fromParameter = parameterInfosArray[index];
                    parameterInfo.mergeRawDescriptionAndPlaceHolders(fromParameter);
                }
            }
            ++index;
        }
        if (!this.returnInfo.hasDescription()) {
            this.returnInfo.mergeRawDescriptionAndPlaceHolders(superMethodInfo.returnInfo);
        }
    }

    @Nullable
    JSDocBuilderParameterInfo getInfoForParameterName(@Nullable String name, @NotNull JSFunctionItem function) {
        if (function == null) {
            JSDocBuilderMethodInfo.$$$reportNull$$$0(2);
        }
        JSParameterItem parameter = null;
        for (JSParameterItem item : function.getParameterVariables()) {
            if (!StringUtil.equals((CharSequence)name, (CharSequence)item.getName())) continue;
            parameter = item;
        }
        JSDocBuilderParameterInfo parameterInfo = this.parameterInfoMap.get(parameter);
        if (parameterInfo != null) {
            return parameterInfo;
        }
        for (JSDocBuilderParameterInfo info : this.parameterInfoMap.values()) {
            if (!StringUtil.equals((CharSequence)name, (CharSequence)info.docName)) continue;
            return info;
        }
        return null;
    }

    @Override
    protected void appendDefinitionDoc(@NotNull StringBuilder builder) {
        if (builder == null) {
            JSDocBuilderMethodInfo.$$$reportNull$$$0(3);
        }
        String functionName = JSPsiImplUtils.findFunctionName(this.myFunctionItem);
        PsiElement parent = this.myFunctionItem.getParent();
        if (parent instanceof JSAssignmentExpression) {
            JSExpression expression;
            String unqualifiedFunctionName = functionName;
            JSExpression definition = ((JSAssignmentExpression)parent).getLOperand();
            if (definition instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)definition).getExpression()) != null) {
                JSExpression qualifierExpression;
                functionName = null;
                if (expression instanceof JSReferenceExpression && (qualifierExpression = ((JSReferenceExpression)expression).getQualifier()) instanceof JSReferenceExpression) {
                    JSNamespace ns = JSSymbolUtil.evaluateNamespaceLocally((JSReferenceExpression)qualifierExpression);
                    functionName = (ns != null && ns.getQualifiedName() != null ? ns.getQualifiedName().getQualifiedName() : qualifierExpression.getText()) + "." + unqualifiedFunctionName;
                }
                if (functionName == null) {
                    functionName = expression.getText();
                }
                if (this.namespace != null && functionName.equals(this.namespace + "." + unqualifiedFunctionName)) {
                    this.namespace = null;
                }
            }
        }
        if (functionName == null) {
            functionName = JSFormatUtil.ANONYMOUS_ELEMENT_PRESENTATION;
        }
        builder.append("<div class='definition'><pre>");
        int functionStart = builder.length();
        StringBuilder options = new StringBuilder();
        JSDocBuilderMethodInfo.addVisibilityAndAccess(this, options);
        if (options.length() > 0) {
            builder.append((CharSequence)options).append("<br>");
        }
        int lastLineStart = builder.length();
        if (!StringUtil.isEmpty((String)this.namespace)) {
            builder.append(this.namespace).append('.');
        }
        builder.append(functionName);
        builder.append("(");
        int resultLength = builder.length();
        int paramsStart = resultLength - functionStart;
        int alignment = paramsStart >= 10 ? 4 : paramsStart;
        for (Map.Entry<JSParameterItem, JSDocBuilderParameterInfo> parameterInfo : this.parameterInfoMap.entrySet()) {
            boolean firstArg;
            boolean bl = firstArg = builder.length() == resultLength;
            if (!firstArg) {
                lastLineStart = builder.length();
                builder.append(",<br>");
                StringUtil.repeatSymbol((Appendable)builder, (char)' ', (int)alignment);
            } else if (paramsStart >= 10) {
                lastLineStart = builder.length();
                builder.append("<br>");
                StringUtil.repeatSymbol((Appendable)builder, (char)' ', (int)alignment);
            }
            JSParameterItem key = parameterInfo.getKey();
            parameterInfo.getValue().appendParameterInfoInSignature(StringUtil.notNullize((String)key.getName()), builder);
        }
        builder.append(")");
        if (this.returnInfo.hasType()) {
            builder.append(": ");
            if (builder.length() - lastLineStart > 80) {
                builder.append("<br>");
                StringUtil.repeatSymbol((Appendable)builder, (char)' ', (int)2);
            }
            if (DumbService.isDumb((Project)this.myFunctionItem.getProject())) {
                builder.append("<Type info not available>");
            } else {
                builder.append(this.returnInfo.getTypeString());
            }
        }
        builder.append("</pre></div>");
    }

    @Override
    protected void appendBodyDoc(@NotNull StringBuilder result2) {
        if (result2 == null) {
            JSDocBuilderMethodInfo.$$$reportNull$$$0(4);
        }
        this.appendParameters(result2);
        this.appendReturns(result2);
        JSDocBuilderMethodInfo.appendNamedSectionAndElements(this.throwsInfos, CodeInsightBundle.message((String)"javadoc.throws", (Object[])new Object[0]), result2);
        JSDocBuilderMethodInfo.appendNamedSectionAndElements(this.firesInfos, JSBundle.message((String)"js.documentation.fires", (Object[])new Object[0]), result2);
    }

    public void appendReturns(@NotNull StringBuilder result2) {
        if (result2 == null) {
            JSDocBuilderMethodInfo.$$$reportNull$$$0(5);
        }
        if (this.returnInfo.hasDescription()) {
            JSDocBuilderMethodInfo.startNamedSection(CodeInsightBundle.message((String)"javadoc.returns", (Object[])new Object[0]), result2);
            result2.append("<td valign='top'>");
            JSDocBuilderMethodInfo.addDescription(this.returnInfo.getFinalDescription(), result2);
            result2.append("</td>");
        }
    }

    public void appendParameters(@NotNull StringBuilder result2) {
        if (result2 == null) {
            JSDocBuilderMethodInfo.$$$reportNull$$$0(6);
        }
        if (this.parameterInfoMap.size() > 0) {
            boolean hasParamDoc = false;
            StringBuilder parametersBuilder = new StringBuilder();
            JSDocBuilderMethodInfo.startNamedSection(CodeInsightBundle.message((String)"javadoc.parameters", (Object[])new Object[0]), parametersBuilder);
            parametersBuilder.append("<td valign='top'>");
            for (Map.Entry<JSParameterItem, JSDocBuilderParameterInfo> parameterInfoEntry : this.parameterInfoMap.entrySet()) {
                JSDocBuilderParameterInfo parameterInfo = parameterInfoEntry.getValue();
                String description = parameterInfo.getDescriptionMergedWithConfigOptions();
                if (parameterInfo.defaultValue != null) {
                    description = description + JSDocBuilderMethodInfo.buildCurrentOrDefaultValue(parameterInfo.defaultValue, false, true, null, false);
                }
                if (description.length() <= 0) continue;
                hasParamDoc = true;
                parametersBuilder.append("<p>");
                JSDocBuilderMethodInfo.appendSingleNamedDescriptionSection(parameterInfoEntry.getKey().getName(), description, parametersBuilder);
            }
            if (hasParamDoc) {
                result2.append((CharSequence)parametersBuilder);
            }
        }
    }

    public static void appendNamedSectionAndElements(@NotNull Collection<? extends JSDocBuilderSimpleInfo> infos, @NotNull String sectionName, @NotNull StringBuilder builder) {
        if (infos == null) {
            JSDocBuilderMethodInfo.$$$reportNull$$$0(7);
        }
        if (sectionName == null) {
            JSDocBuilderMethodInfo.$$$reportNull$$$0(8);
        }
        if (builder == null) {
            JSDocBuilderMethodInfo.$$$reportNull$$$0(9);
        }
        if (!infos.isEmpty()) {
            JSDocBuilderMethodInfo.startNamedSection(sectionName, builder);
            builder.append("<td valign='top'>");
            for (JSDocBuilderSimpleInfo jSDocBuilderSimpleInfo : infos) {
                builder.append("<p>");
                if (jSDocBuilderSimpleInfo.hasType()) {
                    JSDocBuilderMethodInfo.appendSingleNamedDescriptionSection(jSDocBuilderSimpleInfo.getTypeString(), jSDocBuilderSimpleInfo.getFinalDescription(), builder);
                    continue;
                }
                builder.append(jSDocBuilderSimpleInfo.getFinalDescription());
            }
            builder.append("</td>");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionItem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethodInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sectionName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocBuilderMethodInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "mergeSignatureWith";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getInfoForParameterName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "appendDefinitionDoc";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "appendBodyDoc";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "appendReturns";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "appendParameters";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "appendNamedSectionAndElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

