/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateListener;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterGuesser;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.JSNpmLinterState;
import com.intellij.lang.javascript.linter.JsqtProcessOutputViewer;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorNotifications;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLinterCodeStyleImporter<TConfig> {
    protected static final Logger LOG = Logger.getInstance(JSLinterCodeStyleImporter.class);
    private final boolean myShowUiOnMissingTool;
    private final boolean myIsForInitialImport;

    public JSLinterCodeStyleImporter(boolean isForInitialImport) {
        this.myIsForInitialImport = isForInitialImport;
        this.myShowUiOnMissingTool = !isForInitialImport && !ApplicationManager.getApplication().isUnitTestMode();
    }

    public void importConfigFileWhenToolInstalled(final @NotNull PsiFile configPsi) {
        if (configPsi == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        boolean imported = this.importConfigFile(configPsi);
        if (imported) {
            return;
        }
        LOG.info(String.format("Postponing code style import from %s because required tool not installed", this.getToolName()));
        final PackageJsonDependenciesExternalUpdateManager updateManager = PackageJsonDependenciesExternalUpdateManager.getInstance(configPsi.getProject());
        PackageJsonDependenciesExternalUpdateListener listener2 = new PackageJsonDependenciesExternalUpdateListener(){

            @Override
            public void externalUpdateStarted(@Nullable VirtualFile packageJson) {
            }

            @Override
            public void externalUpdateFinished(@Nullable VirtualFile packageJson) {
                updateManager.removeListener(this);
                LOG.info(String.format("Performing postponed code style import from %s", JSLinterCodeStyleImporter.this.getToolName()));
                ReadAction.run(() -> {
                    if (configPsi == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    JSLinterCodeStyleImporter.this.importConfigFile(configPsi);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configPsi", "com/intellij/lang/javascript/linter/JSLinterCodeStyleImporter$1", "lambda$externalUpdateFinished$0"));
            }
        };
        updateManager.addListener(listener2);
    }

    public boolean importConfigFile(final @NotNull PsiFile configPsi) {
        NodePackage nodePackage;
        if (configPsi == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        final Project project = configPsi.getProject();
        TConfig parsedConfig = this.parseConfigFromFile(configPsi);
        if (this.isDirectlyImportable(configPsi)) {
            this.performImport(configPsi, parsedConfig);
            return true;
        }
        JSNpmLinterState state = this.getStoredState(project);
        NodeJsInterpreter interpreter = state.getInterpreterRef().resolve(project);
        JSLinterFileLevelAnnotation validation = this.validateInterpreterAndPackage(project, interpreter, nodePackage = new NodePackage(StringUtil.notNullize((String)state.getLinterPackagePath())));
        if (validation != null && this.myShowUiOnMissingTool) {
            if (!ShowSettingsUtil.getInstance().editConfigurable(project, this.createSettingsConfigurable(project))) {
                return false;
            }
            state = this.getStoredState(project);
            interpreter = state.getInterpreterRef().resolve(project);
            nodePackage = new NodePackage(StringUtil.notNullize((String)state.getLinterPackagePath()));
            validation = this.validateInterpreterAndPackage(project, interpreter, nodePackage);
        }
        if (validation != null) {
            if (this.myShowUiOnMissingTool) {
                this.reportError(project, validation.getMessage());
            }
            this.detailedLog("Validation: " + validation.getMessage());
            return false;
        }
        String binPath = JSLinterCodeStyleImporter.getPackageRelativeBinPath(nodePackage);
        if (binPath == null || !new File(nodePackage.getSystemDependentPath(), binPath).exists()) {
            String message = String.format("Could not find '%s' under '%s' package", binPath, this.getNpmPackageName());
            if (this.myShowUiOnMissingTool) {
                this.reportError(project, message);
            }
            this.detailedLog(message);
            return false;
        }
        JSLinterCodeStyleImporter.ensureSaved(configPsi);
        final NodePackage finalNodePackage = nodePackage;
        final NodeJsInterpreter finalInterpreter = interpreter;
        assert (finalInterpreter != null);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, JSBundle.message((String)"javascript.linter.import.translate.config.progress.title", (Object[])new Object[]{this.getToolName()})){
            private TConfig myEffectiveConfig;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                try {
                    this.myEffectiveConfig = JSLinterCodeStyleImporter.this.computeEffectiveConfig(configPsi, finalInterpreter, finalNodePackage);
                }
                catch (InvalidExitCodeException e) {
                    JSLinterCodeStyleImporter.this.reportError(project, e.getMessage(), e.processOutput);
                }
                catch (ExecutionException e) {
                    JSLinterCodeStyleImporter.this.reportError(project, e.getMessage(), null);
                }
            }

            public void onSuccess() {
                if (this.myEffectiveConfig != null) {
                    JSLinterCodeStyleImporter.this.performImport(configPsi, this.myEffectiveConfig);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/javascript/linter/JSLinterCodeStyleImporter$2", "run"));
            }
        });
        return true;
    }

    @NotNull
    protected abstract Configurable createSettingsConfigurable(@NotNull Project var1);

    @NotNull
    protected abstract JSNpmLinterState getStoredState(Project var1);

    @NotNull
    protected abstract String getNpmPackageName();

    @NotNull
    protected abstract String getToolName();

    protected abstract boolean isDirectlyImportable(@NotNull PsiFile var1);

    @Nullable
    protected abstract TConfig parseConfigFromFile(@NotNull PsiFile var1);

    @Nullable
    protected abstract TConfig computeEffectiveConfig(@NotNull PsiFile var1, @NotNull NodeJsInterpreter var2, @NotNull NodePackage var3) throws ExecutionException;

    @NotNull
    protected abstract Pair<Collection<String>, Runnable> importConfig(@NotNull PsiFile var1, @NotNull TConfig var2);

    private void performImport(@NotNull PsiFile configPsi, @Nullable TConfig config2) {
        if (configPsi == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(2);
        }
        Project project = configPsi.getProject();
        if (config2 == null) {
            String message = JSBundle.message((String)"javascript.linter.import.translate.config.file.error", (Object[])new Object[0]);
            this.reportError(project, message);
            this.detailedLog(message);
            this.detailedLog(configPsi.getText());
            return;
        }
        Pair<Collection<String>, Runnable> pair = this.importConfig(configPsi, config2);
        if (((Collection)pair.first).isEmpty()) {
            if (!this.myIsForInitialImport) {
                JSLinterUtil.reportCodeStyleSettingsAlreadyImported(project, this.getToolName());
            }
        } else {
            EditorNotifications.getInstance((Project)project).updateAllNotifications();
            JSLinterUtil.reportCodeStyleSettingsImported(project, this.getToolName(), configPsi.getVirtualFile(), (Collection)pair.first, (Runnable)pair.second);
        }
    }

    @Nullable
    protected static String getBinPath(@NotNull NodePackage nodePackage) {
        String binPath;
        if (nodePackage == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(3);
        }
        return (binPath = JSLinterCodeStyleImporter.getPackageRelativeBinPath(nodePackage)) != null ? new File(nodePackage.getSystemDependentPath(), binPath).getAbsolutePath() : null;
    }

    @Nullable
    protected static String getPackageRelativeBinPath(@NotNull NodePackage linterPackage) {
        if (linterPackage == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(4);
        }
        String packageDir = linterPackage.getSystemDependentPath();
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        VirtualFile file2 = fileSystem.findFileByIoFile(new File(packageDir, "package.json"));
        if (file2 == null) {
            return null;
        }
        String binPath = PackageJsonUtil.getOrCreateData(file2).getBinPath();
        if (binPath == null) {
            return null;
        }
        return binPath;
    }

    @NotNull
    protected String runToolWithArguments(@NotNull PsiFile configPsi, @NotNull NodeJsInterpreter interpreter, @NotNull List<String> parameters) throws ExecutionException {
        if (configPsi == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(5);
        }
        if (interpreter == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(6);
        }
        if (parameters == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(7);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withCharset(StandardCharsets.UTF_8);
        commandLine.withWorkDirectory((String)ReadAction.compute(() -> {
            if (configPsi == null) {
                JSLinterCodeStyleImporter.$$$reportNull$$$0(15);
            }
            return configPsi.getContainingDirectory().getVirtualFile().getPath();
        }));
        commandLine.withParameters(parameters);
        NodeCommandLineConfigurator.find(interpreter).configure(commandLine);
        CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine);
        ProcessOutput processOutput = processHandler.runProcess((int)TimeUnit.SECONDS.toMillis(10L));
        if (processOutput.isTimeout()) {
            throw new ExecutionException("Timeout processing configuration file");
        }
        if (processOutput.getExitCode() != 0) {
            throw new InvalidExitCodeException("Error applying code style rules from configuration file, possibly because the configuration file is invalid.", processOutput);
        }
        String string = processOutput.getStdout();
        if (string == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(8);
        }
        return string;
    }

    private JSLinterFileLevelAnnotation validateInterpreterAndPackage(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable NodePackage nodePackage) {
        if (project == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(9);
        }
        String path = nodePackage != null ? nodePackage.getSystemDependentPath() : null;
        return JSLinterUtil.validateInterpreterAndPackage(project, interpreter, path, this.getNpmPackageName());
    }

    private static void ensureSaved(@NotNull PsiFile configPsi) {
        Document document;
        FileDocumentManager manager;
        if (configPsi == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(10);
        }
        if ((manager = FileDocumentManager.getInstance()).isFileModified(configPsi.getVirtualFile()) && (document = manager.getDocument(configPsi.getVirtualFile())) != null) {
            manager.saveDocument(document);
        }
    }

    private void reportError(@NotNull Project project, @NotNull String error) {
        if (project == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(11);
        }
        if (error == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(12);
        }
        this.reportError(project, error, null);
    }

    protected void reportError(final @NotNull Project project, @NotNull String error, final @Nullable ProcessOutput output) {
        if (project == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(13);
        }
        if (error == null) {
            JSLinterCodeStyleImporter.$$$reportNull$$$0(14);
        }
        Notification notification2 = JSLinterGuesser.NOTIFICATION_GROUP.createNotification(this.getToolName() + ": " + error, NotificationType.ERROR);
        if (output != null) {
            notification2.addAction((AnAction)new NotificationAction("Show details"){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (notification2 == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    JsqtProcessOutputViewer.show(project, JSLinterCodeStyleImporter.this.getToolName(), null, null, null, output);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/javascript/linter/JSLinterCodeStyleImporter$3";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        notification2.notify(project);
    }

    private void detailedLog(String message) {
        if (this.myIsForInitialImport) {
            LOG.info(this.getToolName() + ":" + message);
        } else {
            LOG.debug(this.getToolName() + ":" + message);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configPsi";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePackage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linterPackage";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterCodeStyleImporter";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterCodeStyleImporter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "runToolWithArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "importConfigFileWhenToolInstalled";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "importConfigFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performImport";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBinPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPackageRelativeBinPath";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runToolWithArguments";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validateInterpreterAndPackage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "ensureSaved";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runToolWithArguments$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class InvalidExitCodeException
    extends ExecutionException {
        public final ProcessOutput processOutput;

        public InvalidExitCodeException(String s, ProcessOutput processOutput) {
            super(s);
            this.processOutput = processOutput;
        }
    }
}

