/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.stubs.JSLiteralExpressionStub;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStringTemplateExpressionImpl
extends JSLiteralExpressionImpl
implements JSStringTemplateExpression {
    private static final TokenSet STRING_TEMPLATE_PART_SET = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.STRING_TEMPLATE_PART});

    public JSStringTemplateExpressionImpl(ASTNode node) {
        super(node);
    }

    public JSStringTemplateExpressionImpl(@NotNull JSLiteralExpressionStub stub) {
        if (stub == null) {
            JSStringTemplateExpressionImpl.$$$reportNull$$$0(0);
        }
        super(stub, (IStubElementType)JSStubElementTypes.STRING_TEMPLATE_EXPRESSION);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSStringTemplateExpressionImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSStringTemplateExpression((JSStringTemplateExpression)this);
        } else {
            super.accept(visitor);
        }
    }

    @Nullable
    private ASTNode getTemplatePartIfNoArgs() {
        ASTNode child3;
        ASTNode child1 = this.getNode().getFirstChildNode();
        ASTNode child2 = child1 != null ? child1.getTreeNext() : null;
        ASTNode aSTNode = child3 = child2 != null ? child2.getTreeNext() : null;
        if (child1 != null && child1.getElementType() == JSTokenTypes.BACKQUOTE && child2 != null && child2.getElementType() == JSTokenTypes.STRING_TEMPLATE_PART && child3 != null && child3.getElementType() == JSTokenTypes.BACKQUOTE && child3.getTreeNext() == null) {
            return child2;
        }
        return null;
    }

    @Override
    @NotNull
    public JSLiteralExpressionKind getExpressionKind(boolean computeExactNumericKind) {
        JSLiteralExpressionKind jSLiteralExpressionKind = this.getTemplatePartIfNoArgs() == null ? JSLiteralExpressionKind.TEMPLATE_WITH_ARGS : JSLiteralExpressionKind.TEMPLATE_NO_ARGS;
        if (jSLiteralExpressionKind == null) {
            JSStringTemplateExpressionImpl.$$$reportNull$$$0(2);
        }
        return jSLiteralExpressionKind;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.getStringValue();
    }

    @Override
    @Nullable
    public String getStringValue() {
        ASTNode theOnlyPart = this.getTemplatePartIfNoArgs();
        return theOnlyPart == null ? null : theOnlyPart.getText();
    }

    @NotNull
    public TextRange[] getStringRanges() {
        ASTNode[] strings = this.getNode().getChildren(STRING_TEMPLATE_PART_SET);
        TextRange[] result2 = new TextRange[strings.length];
        int startOffset = this.getTextRange().getStartOffset();
        for (int i = 0; i < strings.length; ++i) {
            result2[i] = strings[i].getTextRange().shiftRight(-startOffset);
        }
        if (result2 == null) {
            JSStringTemplateExpressionImpl.$$$reportNull$$$0(3);
        }
        return result2;
    }

    @NotNull
    public JSExpression[] getArguments() {
        JSExpression[] jSExpressionArray = (JSExpression[])this.getStubOrPsiChildren(JSElementTypes.EXPRESSIONS, JSExpression.ARRAY_FACTORY);
        if (jSExpressionArray == null) {
            JSStringTemplateExpressionImpl.$$$reportNull$$$0(4);
        }
        return jSExpressionArray;
    }

    @Override
    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        ASTNode expr;
        if (text == null) {
            JSStringTemplateExpressionImpl.$$$reportNull$$$0(5);
        }
        if ((expr = JSChangeUtil.createExpressionWithContext(text, (PsiElement)this)).getElementType() == JSStubElementTypes.STRING_TEMPLATE_EXPRESSION) {
            this.getNode().replaceAllChildrenToChildrenOf(expr);
        }
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecma6/impl/JSStringTemplateExpressionImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecma6/impl/JSStringTemplateExpressionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionKind";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringRanges";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

