/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.javascript.service.JSLanguageServiceExecutor;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceConnector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceExecutorImpl
implements JSLanguageServiceExecutor {
    public static final String CANNOT_START_LANGUAGE_SERVICE_PROCESS = "Cannot start language service process";
    public static final String TIMEOUT_ON_STARTING_SERVICE_PROCESS = "Timeout on starting language service process";
    public static final String CAN_NOT_GET_RESULT_FROM_LANGUAGE_SERVICE = "Can not get result from language service";
    public static final String LANGUAGE_SERVICE_EXECUTION_TIMEOUT = "Language service execution timeout";
    @NotNull
    private final Object myLock;
    @NotNull
    protected final ExecutorService myExecutorService;
    @NotNull
    private final JSLanguageServiceQueue.ServiceInfoReporter myReporter;
    @NotNull
    protected final JSLanguageServiceConnector myServiceConnector;
    @NotNull
    private final Project myProject;
    @Nullable
    private final JSLanguageServiceQueue.ProcessConnector myProcessConnector;
    @NotNull
    protected volatile JSLanguageServiceExecutor.State myState;
    @Nullable
    private volatile BackgroundableProcessIndicator myIndicator;
    private volatile String myStartErrorMessage;
    private volatile boolean myDisposed;
    @Nullable
    private ProcessHandler myProcessHandler;

    public JSLanguageServiceExecutorImpl(@NotNull Project project, @NotNull JSLanguageServiceConnector serviceConnector, @Nullable JSLanguageServiceQueue.ProcessConnector connector, @NotNull JSLanguageServiceQueue.ServiceInfoReporter reporter) {
        if (project == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(0);
        }
        if (serviceConnector == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(1);
        }
        if (reporter == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(2);
        }
        this.myLock = new Object();
        this.myState = JSLanguageServiceExecutor.State.STARTING;
        this.myDisposed = false;
        this.myReporter = reporter;
        this.myProject = project;
        this.myProcessConnector = connector;
        this.myServiceConnector = serviceConnector;
        this.myExecutorService = ConcurrencyUtil.newSingleThreadExecutor((String)("JS external service " + reporter.getServiceName()));
        Disposer.register((Disposable)project, (Disposable)this);
        this.init();
    }

    @Override
    @NotNull
    public final JSLanguageServiceExecutor.State getState() {
        JSLanguageServiceExecutor.State state = this.myState;
        if (state == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(3);
        }
        return state;
    }

    private void init() {
        JSLanguageServiceQueue.LOGGER.debug("Submit init action to thread pool");
        this.myExecutorService.submit(() -> {
            try {
                BackgroundableProcessIndicator indicator = this.createIndicator();
                Object object = this.myLock;
                synchronized (object) {
                    if (this.getState() == JSLanguageServiceExecutor.State.DISPOSED && indicator != null) {
                        this.disposeIndicator(indicator);
                    } else {
                        this.myIndicator = indicator;
                    }
                }
                if (indicator != null && !indicator.isCanceled()) {
                    indicator.start();
                }
                JSLanguageServiceQueue.LOGGER.debug("Start service in thread pool");
                this.startService();
                object = this.myLock;
                synchronized (object) {
                    if (JSLanguageServiceQueue.LOGGER.isDebugEnabled() && this.myProcessHandler != null) {
                        JSLanguageServiceQueue.LOGGER.debug("Language service successfully started");
                    }
                }
            }
            catch (Throwable e) {
                this.myState = JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT;
                this.myStartErrorMessage = JSLanguageServiceExecutorImpl.getExceptionMessage(e);
                JSLanguageServiceQueue.LOGGER.info("Exception on starting language service", e);
            }
            finally {
                this.createUI();
            }
        });
        this.myExecutorService.submit(() -> {
            try {
                ProcessHandler processHandler;
                Object object = this.myLock;
                synchronized (object) {
                    processHandler = this.myProcessHandler;
                }
                if (processHandler != null && this.getState() == JSLanguageServiceExecutor.State.STARTING) {
                    if (this.myServiceConnector.awaitReadyNotification(processHandler)) {
                        this.myState = JSLanguageServiceExecutor.State.STARTED;
                    } else {
                        this.myState = JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT;
                        if (this.myStartErrorMessage == null) {
                            this.myStartErrorMessage = this.myServiceConnector.getInitializeError();
                        }
                        this.recordErrorAndStop();
                    }
                }
            }
            catch (Throwable e) {
                this.myState = JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT;
                this.myStartErrorMessage = JSLanguageServiceExecutorImpl.getExceptionMessage(e);
                JSLanguageServiceQueue.LOGGER.info("Exception on starting language service", e);
            }
            finally {
                BackgroundableProcessIndicator indicator = this.myIndicator;
                if (indicator != null) {
                    indicator.processFinish();
                    this.disposeIndicator(indicator);
                }
            }
        });
    }

    @Nullable
    private BackgroundableProcessIndicator createIndicator() throws Exception {
        if (this.myProcessConnector == null) {
            return null;
        }
        AtomicReference ref = new AtomicReference();
        EdtInvocationManager.getInstance().invokeAndWait(() -> {
            if (this.myProject.isDisposed() || !this.myProject.isOpen() || !this.isValid()) {
                return;
            }
            ref.set(new BackgroundableProcessIndicator(this.myProject, "Starting " + this.myReporter.getServiceName() + " Service", PerformInBackgroundOption.ALWAYS_BACKGROUND, "", "", false));
        });
        return (BackgroundableProcessIndicator)ref.get();
    }

    private void createUI() {
        ReadAction.run(() -> StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> UIUtil.invokeLaterIfNeeded(() -> {
            ProcessHandler handler;
            Object object = this.myLock;
            synchronized (object) {
                handler = this.myProcessHandler;
                if (this.myProject.isDisposed() || this.myDisposed) {
                    return;
                }
            }
            if (handler != null && this.myProcessConnector != null) {
                this.myProcessConnector.connectToProcessHandler(handler);
            }
            if (handler == null || !this.isValid()) {
                this.myReporter.logError(this.getStartErrorOrTimeout());
            }
        })));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startService() {
        Object object = this.myLock;
        synchronized (object) {
            try {
                JSLanguageServiceQueue.LOGGER.debug("Creating OS Handler");
                this.myProcessHandler = this.myServiceConnector.connect();
                if (this.myProcessHandler == null) {
                    this.myState = JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT;
                    this.myStartErrorMessage = this.myServiceConnector.getInitializeError();
                    return;
                }
                this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (outputType == ProcessOutputTypes.STDERR) {
                            if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
                                JSLanguageServiceQueue.LOGGER.debug("Stderr output: " + StringUtil.escapeLineBreak((String)event.getText()));
                            }
                            return;
                        }
                        if (outputType == ProcessOutputTypes.STDOUT && JSLanguageServiceQueue.LOGGER.isTraceEnabled()) {
                            JSLanguageServiceQueue.LOGGER.trace("Stdout output: " + StringUtil.escapeLineBreak((String)event.getText()));
                        }
                    }

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        JSLanguageServiceExecutorImpl.this.processTerminated();
                        if (JSLanguageServiceQueue.LOGGER.isTraceEnabled()) {
                            JSLanguageServiceQueue.LOGGER.trace("Process [" + event.getProcessHandler() + "] was killed " + event.getText());
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "outputType";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceExecutorImpl$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onTextAvailable";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processTerminated";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                JSLanguageServiceQueue.LOGGER.debug("OS Handler created successfully");
            }
            catch (Exception e) {
                this.myState = JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT;
                this.myStartErrorMessage = JSLanguageServiceExecutorImpl.getExceptionMessage(e);
                JSLanguageServiceQueue.LOGGER.info("Error while creating OS Handler: " + e.getMessage(), (Throwable)e);
            }
            finally {
                if (this.myProcessHandler != null && this.myState == JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT) {
                    this.recordErrorAndStop();
                }
            }
        }
    }

    protected void processTerminated() {
        if (this.myState == JSLanguageServiceExecutor.State.STARTED || this.myState == JSLanguageServiceExecutor.State.STARTING) {
            this.myState = JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT;
        }
    }

    private static String getExceptionMessage(@NotNull Throwable e) {
        if (e == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(4);
        }
        return e.getLocalizedMessage() != null ? e.getLocalizedMessage() : e.getMessage();
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        this.stop(true);
    }

    private void recordErrorAndStop() {
        String errorText;
        this.myStartErrorMessage = errorText = (String)ObjectUtils.coalesce((Object)this.myStartErrorMessage, (Object)TIMEOUT_ON_STARTING_SERVICE_PROCESS);
        ApplicationManager.getApplication().invokeLater(() -> this.myReporter.logError(errorText), this.myProject.getDisposed());
        this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop(boolean awaitPoolTermination) {
        JSLanguageServiceQueue.LOGGER.debug(String.format("Stopping %s awaitPoolTermination: %s", this.myReporter.getServiceName(), awaitPoolTermination));
        if (JSLanguageServiceQueue.LOGGER.isTraceEnabled()) {
            JSLanguageServiceQueue.LOGGER.trace("Disposing queue with hashcode " + this.hashCode());
            JSLanguageServiceQueue.LOGGER.trace((Throwable)new Exception());
        }
        boolean inTest = ApplicationManager.getApplication().isUnitTestMode();
        Object object = this.myLock;
        synchronized (object) {
            if (this.myState == JSLanguageServiceExecutor.State.DISPOSED) {
                return;
            }
            this.myState = JSLanguageServiceExecutor.State.DISPOSED;
            this.disposeIndicator(this.myIndicator);
            this.myExecutorService.shutdown();
            if (!inTest) {
                this.myExecutorService.shutdownNow();
                try {
                    this.myExecutorService.awaitTermination(10L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.myProcessHandler != null) {
                if (!this.myProcessHandler.isProcessTerminated() && !this.myProcessHandler.isProcessTerminating()) {
                    if (awaitPoolTermination && inTest) {
                        final Semaphore semaphore = new Semaphore();
                        semaphore.down();
                        this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                            public void processTerminated(@NotNull ProcessEvent event) {
                                if (event == null) {
                                    2.$$$reportNull$$$0(0);
                                }
                                semaphore.up();
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/service/JSLanguageServiceExecutorImpl$2", "processTerminated"));
                            }
                        });
                        this.myProcessHandler.destroyProcess();
                        semaphore.waitFor(TimeUnit.SECONDS.toMillis(20L));
                    } else {
                        this.myProcessHandler.destroyProcess();
                    }
                }
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (this.myProcessConnector != null) {
                        this.myProcessConnector.disconnectFromProcessHandler(false);
                    }
                });
            }
        }
        if (awaitPoolTermination && inTest) {
            this.shutdownAndAwaitTermination(this.myExecutorService);
        }
    }

    void shutdownAndAwaitTermination(@NotNull ExecutorService pool) {
        if (pool == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(5);
        }
        assert (ApplicationManager.getApplication().isUnitTestMode());
        pool.shutdown();
        try {
            if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(3L, TimeUnit.MINUTES)) {
                    JSLanguageServiceQueue.LOGGER.warn("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    protected void startAction(@NotNull JSLanguageServiceCommand command) {
        if (command == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(6);
        }
        this.startAction(command.getPresentableText(this.myProject));
    }

    protected void startAction(String text) {
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        this.myReporter.setProcess(text);
    }

    protected void endAction() {
        if (this.getState() == JSLanguageServiceExecutor.State.STARTED) {
            this.myReporter.setProcess(null);
        }
    }

    private void disposeIndicator(@Nullable BackgroundableProcessIndicator indicator) {
        try {
            if (indicator != null) {
                if (!indicator.isCanceled()) {
                    indicator.cancel();
                }
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (this.myProject.isDisposed()) {
                        return;
                    }
                    Disposer.dispose((Disposable)indicator);
                });
            }
        }
        catch (Exception e) {
            JSLanguageServiceQueue.LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isValid() {
        JSLanguageServiceExecutor.State state = this.myState;
        return state != JSLanguageServiceExecutor.State.DISPOSED && state != JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT;
    }

    @NotNull
    private String getStartErrorOrTimeout() {
        String string = (String)ObjectUtils.coalesce((Object)this.getStartErrorMessage(), (Object)TIMEOUT_ON_STARTING_SERVICE_PROCESS);
        if (string == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public String getStartErrorMessage() {
        return (String)ObjectUtils.coalesce((Object)this.myServiceConnector.getInitializeError(), (Object)this.myStartErrorMessage);
    }

    @NotNull
    public JSLanguageServiceConnector getProtocol() {
        JSLanguageServiceConnector jSLanguageServiceConnector = this.myServiceConnector;
        if (jSLanguageServiceConnector == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(8);
        }
        return jSLanguageServiceConnector;
    }

    @Override
    public <T> Future<T> submit(@Nullable String presentableName, Callable<? extends T> task) {
        try {
            return this.myExecutorService.submit(() -> {
                if (this.myState != JSLanguageServiceExecutor.State.STARTED) {
                    throw new IllegalStateException("Service is not started. State = " + this.myState.name());
                }
                this.startAction(presentableName);
                try {
                    Object v = task.call();
                    return v;
                }
                catch (IOException e) {
                    JSLanguageServiceQueue.LOGGER.debug(e.getMessage(), (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    JSLanguageServiceQueue.LOGGER.error(throwable.getMessage(), throwable);
                    throw throwable;
                }
                finally {
                    this.endAction();
                }
            });
        }
        catch (RejectedExecutionException exception) {
            JSLanguageServiceQueue.LOGGER.debug(exception.getMessage(), (Throwable)exception);
            throw exception;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceConnector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/JSLanguageServiceExecutorImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pool";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceExecutorImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartErrorOrTimeout";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionMessage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shutdownAndAwaitTermination";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "startAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

