/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.regex;

import com.google.common.base.Preconditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.plugins.textmate.regex.RegexUtil;
import org.joni.Region;

public class MatchData {
    public static final MatchData NOT_MATCHED = new MatchData("", false, Collections.emptyList());
    private final boolean matched;
    private final List<TextRange> offsets;
    private final CharSequence text;

    private MatchData(CharSequence text, boolean matched, List<TextRange> offsets) {
        this.text = text;
        this.matched = matched;
        this.offsets = offsets;
    }

    public static MatchData fromRegion(CharSequence text, Region matchedRegion) {
        if (matchedRegion != null) {
            ArrayList<TextRange> offsets = new ArrayList<TextRange>(matchedRegion.numRegs);
            byte[] bytes = text.toString().getBytes(CharsetToolkit.UTF8_CHARSET);
            for (int i = 0; i < matchedRegion.numRegs; ++i) {
                int startOffset = RegexUtil.charOffsetByByteOffset(bytes, matchedRegion.beg[i]);
                int endOffset = RegexUtil.charOffsetByByteOffset(bytes, matchedRegion.end[i]);
                offsets.add(i, TextRange.create((int)startOffset, (int)endOffset));
            }
            return new MatchData(text, true, offsets);
        }
        return NOT_MATCHED;
    }

    public CharSequence capture(int group) {
        TextRange textRange = this.offset(group);
        return this.text.subSequence(textRange.getStartOffset(), textRange.getEndOffset());
    }

    public TextRange offset() {
        return this.offset(0);
    }

    public int count() {
        return this.offsets.size();
    }

    public TextRange offset(int group) {
        Preconditions.checkElementIndex((int)group, (int)this.offsets.size());
        return this.offsets.get(group);
    }

    public boolean matched() {
        return this.matched;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchData matchData = (MatchData)o;
        if (this.matched != matchData.matched) {
            return false;
        }
        if (this.offsets != null ? !this.offsets.equals(matchData.offsets) : matchData.offsets != null) {
            return false;
        }
        return !(this.text != null ? !this.text.equals(matchData.text) : matchData.text != null);
    }

    public int hashCode() {
        int result = this.matched ? 1 : 0;
        result = 31 * result + (this.offsets != null ? this.offsets.hashCode() : 0);
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "{ matched=" + this.matched + ", offsets=" + this.offsets + ", text=" + this.text + '}';
    }
}

