/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.client.header;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.rest.client.RestClientDataProvider;
import com.intellij.ws.rest.client.header.HttpHeaderDocumentation;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpHeadersDictionary {
    private static final List<String> CONTENT_TYPES = ContainerUtil.newArrayList((Object[])new String[]{"application/javascript", "application/json", "application/x-www-form-urlencoded", "application/xml", "application/zip", "application/pdf", "application/sql", "application/msword", "application/vnd.ms-excel", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.ms-powerpoint", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "audio/mpeg", "audio/vorbis", "multipart/form-data", "text/css", "text/html", "text/csv", "text/plain", "image/png", "image/jpeg", "image/gif"});
    private static final List<String> ENCODINGS = ContainerUtil.newArrayList((Object[])new String[]{"compress", "deflate", "exi", "gzip", "identity", "pack200-gzip", "br", "bzip2", "lzma", "peerdist", "sdch", "xpress", "xz"});
    private static Map<String, HttpHeaderDocumentation> ourHeaders = null;
    private static Map<String, List<String>> ourHeaderValues;
    private static final Map<String, List<String>> ourHeaderOptionNames;

    @NotNull
    public static synchronized Map<String, HttpHeaderDocumentation> getHeaders() {
        if (ourHeaders == null) {
            ourHeaders = HttpHeadersDictionary.readHeaders();
        }
        Map<String, HttpHeaderDocumentation> map = ourHeaders;
        if (map == null) {
            HttpHeadersDictionary.$$$reportNull$$$0(0);
        }
        return map;
    }

    @Nullable
    public static HttpHeaderDocumentation getDocumentation(@NotNull String fieldName) {
        if (fieldName == null) {
            HttpHeadersDictionary.$$$reportNull$$$0(1);
        }
        Map<String, HttpHeaderDocumentation> headers = HttpHeadersDictionary.getHeaders();
        return headers.get(fieldName);
    }

    @NotNull
    private static Map<String, HttpHeaderDocumentation> readHeaders() {
        HashMap result = ContainerUtil.newHashMap();
        InputStream stream = HttpHeadersDictionary.class.getResourceAsStream("/com/intellij/ws/rest/client/headers/headers-doc.json");
        try {
            JsonElement root;
            String file;
            String string = file = stream != null ? FileUtil.loadTextAndClose((InputStream)stream) : "";
            if (StringUtil.isNotEmpty((String)file) && (root = new JsonParser().parse(file)).isJsonArray()) {
                JsonArray array = root.getAsJsonArray();
                for (JsonElement element : array) {
                    HttpHeaderDocumentation header;
                    if (!element.isJsonObject() || (header = HttpHeaderDocumentation.read(element.getAsJsonObject())) == null) continue;
                    result.put(header.getName(), header);
                }
            }
        }
        catch (IOException e) {
            Logger.getInstance(HttpHeadersDictionary.class).error((Throwable)e);
        }
        HashMap hashMap = result;
        if (hashMap == null) {
            HttpHeadersDictionary.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    @NotNull
    public static Collection<String> getHeaderValues(@NotNull Project project, @NotNull String headerName) {
        RestClientDataProvider[] extensions;
        if (project == null) {
            HttpHeadersDictionary.$$$reportNull$$$0(3);
        }
        if (headerName == null) {
            HttpHeadersDictionary.$$$reportNull$$$0(4);
        }
        if (ourHeaderValues == null) {
            ourHeaderValues = HttpHeadersDictionary.readHeaderValues();
        }
        if (StringUtil.equals((CharSequence)headerName, (CharSequence)"Accept") && (extensions = (RestClientDataProvider[])RestClientDataProvider.EP_NAME.getExtensions()).length > 0) {
            ArrayList mimeTypes = ContainerUtil.newArrayList((Iterable)ourHeaderValues.get(headerName));
            for (RestClientDataProvider extension : extensions) {
                Collections.addAll(mimeTypes, extension.getAllMimeTypes(project));
            }
            ArrayList arrayList = mimeTypes;
            if (arrayList == null) {
                HttpHeadersDictionary.$$$reportNull$$$0(5);
            }
            return arrayList;
        }
        Collection collection = ourHeaderValues.containsKey(headerName) ? (Collection)ourHeaderValues.get(headerName) : ContainerUtil.emptyList();
        if (collection == null) {
            HttpHeadersDictionary.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    public static Collection<String> getHeaderOptionNames(@NotNull String headerName) {
        if (headerName == null) {
            HttpHeadersDictionary.$$$reportNull$$$0(7);
        }
        Collection collection = ourHeaderOptionNames.containsKey(headerName) ? (Collection)ourHeaderOptionNames.get(headerName) : ContainerUtil.emptyList();
        if (collection == null) {
            HttpHeadersDictionary.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NotNull
    private static Map<String, List<String>> readHeaderValues() {
        HashMap values = ContainerUtil.newHashMap();
        values.put("Accept", CONTENT_TYPES);
        values.put("Content-Type", CONTENT_TYPES);
        values.put("Accept-Encoding", ENCODINGS);
        HashMap hashMap = values;
        if (hashMap == null) {
            HttpHeadersDictionary.$$$reportNull$$$0(9);
        }
        return hashMap;
    }

    static {
        ourHeaderOptionNames = ContainerUtil.newHashMap();
        ourHeaderOptionNames.put("Content-Type", ContainerUtil.newArrayList((Object[])new String[]{"charset", "boundary"}));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/client/header/HttpHeadersDictionary";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaders";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/client/header/HttpHeadersDictionary";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readHeaders";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderValues";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderOptionNames";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "readHeaderValues";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHeaderValues";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHeaderOptionNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

