/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.NavigationItemFileStatus;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.usages.NamedPresentably;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiElementUsageGroupBase<T extends PsiElement & NavigationItem>
implements UsageGroup,
NamedPresentably {
    private final SmartPsiElementPointer<T> myElementPointer;
    private final String myName;
    private final Icon myIcon;

    public PsiElementUsageGroupBase(@NotNull T element, Icon icon) {
        if (element == null) {
            PsiElementUsageGroupBase.$$$reportNull$$$0(0);
        }
        String myName = ((NavigationItem)element).getName();
        if (myName == null) {
            myName = "<anonymous>";
        }
        this.myName = myName;
        this.myElementPointer = SmartPointerManager.getInstance(element.getProject()).createSmartPsiElementPointer(element);
        this.myIcon = icon;
    }

    public PsiElementUsageGroupBase(@NotNull T element) {
        if (element == null) {
            PsiElementUsageGroupBase.$$$reportNull$$$0(1);
        }
        this(element, element.getIcon(0));
    }

    @Override
    public Icon getIcon(boolean isOpen) {
        return this.myIcon;
    }

    public T getElement() {
        return this.myElementPointer.getElement();
    }

    @Override
    @NotNull
    public String getText(UsageView view) {
        String string = this.myName;
        if (string == null) {
            PsiElementUsageGroupBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public FileStatus getFileStatus() {
        return this.isValid() ? NavigationItemFileStatus.get((NavigationItem)this.getElement()) : null;
    }

    @Override
    public boolean isValid() {
        T element = this.getElement();
        return element != null && element.isValid();
    }

    @Override
    public void navigate(boolean focus) throws UnsupportedOperationException {
        if (this.canNavigate()) {
            ((Navigatable)this.getElement()).navigate(focus);
        }
    }

    @Override
    public boolean canNavigate() {
        return this.isValid();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Override
    public void update() {
    }

    @Override
    public int compareTo(@NotNull UsageGroup o) {
        if (o == null) {
            PsiElementUsageGroupBase.$$$reportNull$$$0(3);
        }
        String name = o instanceof NamedPresentably ? ((NamedPresentably)((Object)o)).getPresentableName() : o.getText(null);
        return this.myName.compareToIgnoreCase(name);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PsiElementUsageGroupBase)) {
            return false;
        }
        PsiElementUsageGroupBase group = (PsiElementUsageGroupBase)obj;
        if (this.isValid() && group.isValid()) {
            return this.getElement().getManager().areElementsEquivalent((PsiElement)this.getElement(), (PsiElement)group.getElement());
        }
        return Comparing.equal((String)this.myName, (String)((PsiElementUsageGroupBase)obj).myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.myName;
        if (string == null) {
            PsiElementUsageGroupBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/PsiElementUsageGroupBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/PsiElementUsageGroupBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

