/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.changes.GitCommittedChangeList;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitConfigUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitSimplePathsBrowser;
import git4idea.util.GitUIUtil;
import git4idea.util.StringScanner;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUtil {
    public static final String DOT_GIT = ".git";
    public static final String COMMENT_CHAR = "\u0001";
    public static final String ORIGIN_HEAD = "origin/HEAD";
    public static final Function<GitRepository, VirtualFile> REPOSITORY_TO_ROOT = repository -> repository.getRoot();
    public static final String HEAD = "HEAD";
    public static final String CHERRY_PICK_HEAD = "CHERRY_PICK_HEAD";
    public static final String MERGE_HEAD = "MERGE_HEAD";
    private static final String REPO_PATH_LINK_PREFIX = "gitdir:";
    private static final Logger LOG = Logger.getInstance(GitUtil.class);
    private static final String HEAD_FILE = "HEAD";

    private GitUtil() {
    }

    @Nullable
    public static VirtualFile findGitDir(@NotNull VirtualFile rootDir) {
        VirtualFile dotGit;
        if (rootDir == null) {
            GitUtil.$$$reportNull$$$0(0);
        }
        if ((dotGit = VfsUtil.refreshAndFindChild((VirtualFile)rootDir, (String)DOT_GIT)) == null) {
            return null;
        }
        if (dotGit.isDirectory()) {
            boolean headExists = VfsUtil.refreshAndFindChild((VirtualFile)dotGit, (String)"HEAD") != null;
            return headExists ? dotGit : null;
        }
        String content = GitUtil.readContent(dotGit);
        if (content == null) {
            return null;
        }
        String pathToDir = GitUtil.parsePathToRepository(content);
        File file = GitUtil.findRealRepositoryDir(rootDir.getPath(), pathToDir);
        if (file == null) {
            return null;
        }
        return VcsUtil.getVirtualFileWithRefresh((File)file);
    }

    @Nullable
    private static File findRealRepositoryDir(@NotNull String rootPath, @NotNull String path) {
        File file;
        if (rootPath == null) {
            GitUtil.$$$reportNull$$$0(1);
        }
        if (path == null) {
            GitUtil.$$$reportNull$$$0(2);
        }
        if (!FileUtil.isAbsolute((String)path)) {
            String canonicalPath = FileUtil.toCanonicalPath((String)FileUtil.join((String[])new String[]{rootPath, path}), (boolean)true);
            if (canonicalPath == null) {
                return null;
            }
            path = FileUtil.toSystemIndependentName((String)canonicalPath);
        }
        return (file = new File(path)).isDirectory() ? file : null;
    }

    @NotNull
    private static String parsePathToRepository(@NotNull String content) {
        if (content == null) {
            GitUtil.$$$reportNull$$$0(3);
        }
        String string = (content = content.trim()).startsWith(REPO_PATH_LINK_PREFIX) ? content.substring(REPO_PATH_LINK_PREFIX.length()).trim() : content;
        if (string == null) {
            GitUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private static String readContent(@NotNull VirtualFile dotGit) {
        String content;
        if (dotGit == null) {
            GitUtil.$$$reportNull$$$0(5);
        }
        try {
            content = GitUtil.readFile(dotGit);
        }
        catch (IOException e) {
            LOG.error("Couldn't read the content of " + dotGit, (Throwable)e);
            return null;
        }
        return content;
    }

    @NotNull
    public static String readFile(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            GitUtil.$$$reportNull$$$0(6);
        }
        int ATTEMPTS = 3;
        int attempt = 1;
        while (true) {
            String string;
            block4: {
                try {
                    string = new String(file.contentsToByteArray(), CharsetToolkit.UTF8_CHARSET);
                    if (string != null) break block4;
                }
                catch (IOException e) {
                    LOG.info(String.format("IOException while reading %s (attempt #%s)", file, attempt));
                    if (attempt++ < 3) continue;
                    throw e;
                }
                GitUtil.$$$reportNull$$$0(7);
            }
            return string;
        }
    }

    @NotNull
    public static Map<VirtualFile, List<VirtualFile>> sortFilesByGitRoot(@NotNull Collection<? extends VirtualFile> virtualFiles) throws VcsException {
        if (virtualFiles == null) {
            GitUtil.$$$reportNull$$$0(8);
        }
        Map<VirtualFile, List<VirtualFile>> map2 = GitUtil.sortFilesByGitRoot(virtualFiles, false);
        if (map2 == null) {
            GitUtil.$$$reportNull$$$0(9);
        }
        return map2;
    }

    public static Map<VirtualFile, List<VirtualFile>> sortFilesByGitRoot(Collection<? extends VirtualFile> virtualFiles, boolean ignoreNonGit) throws VcsException {
        HashMap<VirtualFile, List<VirtualFile>> result2 = new HashMap<VirtualFile, List<VirtualFile>>();
        for (VirtualFile virtualFile : virtualFiles) {
            VirtualFile vcsRoot = GitUtil.gitRootOrNull(virtualFile.isDirectory() ? virtualFile.getParent() : virtualFile);
            if (vcsRoot == null) {
                if (ignoreNonGit) continue;
                throw new VcsException("The file " + virtualFile.getPath() + " is not under Git");
            }
            ArrayList<VirtualFile> files = (ArrayList<VirtualFile>)result2.get(vcsRoot);
            if (files == null) {
                files = new ArrayList<VirtualFile>();
                result2.put(vcsRoot, files);
            }
            files.add(virtualFile);
        }
        return result2;
    }

    public static Map<VirtualFile, List<FilePath>> sortFilePathsByGitRoot(Collection<? extends FilePath> files) throws VcsException {
        return GitUtil.sortFilePathsByGitRoot(files, false);
    }

    @NotNull
    public static Map<VirtualFile, List<FilePath>> sortFilePathsByGitRoot(@NotNull Collection<? extends FilePath> files, boolean ignoreNonGit) throws VcsException {
        if (files == null) {
            GitUtil.$$$reportNull$$$0(10);
        }
        HashMap<VirtualFile, List<FilePath>> rc = new HashMap<VirtualFile, List<FilePath>>();
        for (FilePath filePath : files) {
            VirtualFile root = GitUtil.getGitRootOrNull(filePath);
            if (root == null) {
                if (ignoreNonGit) continue;
                throw new VcsException("The file " + filePath.getPath() + " is not under Git");
            }
            ArrayList<FilePath> l = (ArrayList<FilePath>)rc.get(root);
            if (l == null) {
                l = new ArrayList<FilePath>();
                rc.put(root, l);
            }
            l.add(filePath);
        }
        HashMap<VirtualFile, List<FilePath>> hashMap = rc;
        if (hashMap == null) {
            GitUtil.$$$reportNull$$$0(11);
        }
        return hashMap;
    }

    public static Date parseTimestamp(String value) {
        long parsed = Long.parseLong(value.trim());
        return new Date(parsed * 1000L);
    }

    public static Date parseTimestampWithNFEReport(String value, GitHandler handler, String gitOutput) {
        try {
            return GitUtil.parseTimestamp(value);
        }
        catch (NumberFormatException e) {
            LOG.error("annotate(). NFE. Handler: " + handler + ". Output: " + gitOutput, (Throwable)e);
            return new Date();
        }
    }

    public static Set<VirtualFile> gitRootsForPaths(Collection<? extends VirtualFile> roots) {
        HashSet<VirtualFile> rc = new HashSet<VirtualFile>();
        for (VirtualFile virtualFile : roots) {
            VirtualFile gitRoot = GitUtil.getGitRootOrNull(VcsUtil.getFilePath((VirtualFile)virtualFile));
            if (gitRoot == null) continue;
            rc.add(gitRoot);
        }
        return rc;
    }

    @Deprecated
    public static VirtualFile getGitRoot(@NotNull FilePath filePath) throws VcsException {
        VirtualFile root;
        if (filePath == null) {
            GitUtil.$$$reportNull$$$0(12);
        }
        if ((root = GitUtil.getGitRootOrNull(filePath)) != null) {
            return root;
        }
        throw new VcsException("The file " + filePath + " is not under git.");
    }

    @Deprecated
    @Nullable
    public static VirtualFile getGitRootOrNull(@NotNull FilePath filePath) {
        if (filePath == null) {
            GitUtil.$$$reportNull$$$0(13);
        }
        for (File root = filePath.getIOFile(); root != null; root = root.getParentFile()) {
            if (!GitUtil.isGitRoot(root)) continue;
            return LocalFileSystem.getInstance().findFileByIoFile(root);
        }
        return null;
    }

    public static boolean isGitRoot(@NotNull File folder) {
        if (folder == null) {
            GitUtil.$$$reportNull$$$0(14);
        }
        return GitUtil.isGitRoot(folder.getPath());
    }

    @Deprecated
    public static VirtualFile getGitRoot(@NotNull VirtualFile file) throws VcsException {
        VirtualFile root;
        if (file == null) {
            GitUtil.$$$reportNull$$$0(15);
        }
        if ((root = GitUtil.gitRootOrNull(file)) != null) {
            return root;
        }
        throw new VcsException("The file " + file.getPath() + " is not under git.");
    }

    @Deprecated
    @Nullable
    public static VirtualFile gitRootOrNull(VirtualFile file) {
        return GitUtil.getGitRootOrNull(VcsUtil.getFilePath((String)file.getPath()));
    }

    @Deprecated
    @NotNull
    public static List<VirtualFile> getGitRoots(Project project, GitVcs vcs) throws VcsException {
        VirtualFile[] contentRoots = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs);
        if (contentRoots == null || contentRoots.length == 0) {
            throw new VcsException(GitBundle.getString("repository.action.missing.roots.unconfigured.message"));
        }
        List sortedRoots = DvcsUtil.sortVirtualFilesByPresentation(GitUtil.gitRootsForPaths(Arrays.asList(contentRoots)));
        if (sortedRoots.size() == 0) {
            throw new VcsException(GitBundle.getString("repository.action.missing.roots.misconfigured"));
        }
        List list = sortedRoots;
        if (list == null) {
            GitUtil.$$$reportNull$$$0(16);
        }
        return list;
    }

    public static boolean isUnderGit(VirtualFile vFile) {
        return GitUtil.gitRootOrNull(vFile) != null;
    }

    public static String adjustAuthorName(String authorName, String committerName) {
        if (!authorName.equals(committerName)) {
            committerName = authorName + ", via " + committerName;
        }
        return committerName;
    }

    public static boolean isUnderGit(FilePath path) {
        return GitUtil.getGitRootOrNull(path) != null;
    }

    public static Set<VirtualFile> gitRoots(Collection<? extends FilePath> filePaths) {
        return filePaths.stream().map(GitUtil::getGitRootOrNull).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static String gitTime(Date time) {
        long t = time.getTime() / 1000L;
        return Long.toString(t);
    }

    public static String formatLongRev(long rev) {
        return String.format("%015x%x", rev >>> 4, rev & 0xFL);
    }

    public static void getLocalCommittedChanges(Project project, VirtualFile root, Consumer<? super GitHandler> parametersSpecifier, Consumer<? super GitCommittedChangeList> consumer, boolean skipDiffsForMerge) throws VcsException {
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LOG);
        h.setSilent(true);
        h.addParameters("--pretty=format:%x04%x01%ct%n%H%n%P%n%an%x20%x3C%ae%x3E%n%cn%x20%x3C%ce%x3E%n%s%n%x03%n%b%n%x03", "--name-status");
        parametersSpecifier.consume((Object)h);
        String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        LOG.debug("getLocalCommittedChanges output: '" + output + "'");
        StringScanner s = new StringScanner(output);
        StringBuilder sb = new StringBuilder();
        boolean firstStep = true;
        while (s.hasMoreData()) {
            String line = s.line();
            boolean lineIsAStart = line.startsWith("\u0004\u0001");
            if (!firstStep && lineIsAStart) {
                StringScanner innerScanner = new StringScanner(sb.toString());
                sb.setLength(0);
                consumer.consume((Object)GitChangeUtils.parseChangeList(project, root, innerScanner, skipDiffsForMerge, h, false, false));
            }
            sb.append(lineIsAStart ? line.substring(2) : line).append('\n');
            firstStep = false;
        }
        if (sb.length() > 0) {
            StringScanner innerScanner = new StringScanner(sb.toString());
            sb.setLength(0);
            consumer.consume((Object)GitChangeUtils.parseChangeList(project, root, innerScanner, skipDiffsForMerge, h, false, false));
        }
        if (s.hasMoreData()) {
            throw new IllegalStateException("More input is avaialble: " + s.line());
        }
    }

    public static List<GitCommittedChangeList> getLocalCommittedChanges(Project project, VirtualFile root, Consumer<? super GitHandler> parametersSpecifier) throws VcsException {
        ArrayList<GitCommittedChangeList> rc = new ArrayList<GitCommittedChangeList>();
        GitUtil.getLocalCommittedChanges(project, root, parametersSpecifier, (Consumer<? super GitCommittedChangeList>)((Consumer)committedChangeList -> rc.add((GitCommittedChangeList)((Object)committedChangeList))), false);
        return rc;
    }

    @NotNull
    public static String unescapePath(@NotNull String path) throws VcsException {
        if (path == null) {
            GitUtil.$$$reportNull$$$0(17);
        }
        String QUOTE = "\"";
        if (path.startsWith("\"") && path.endsWith("\"")) {
            path = path.substring(1, path.length() - 1);
        }
        int l = path.length();
        StringBuilder rc = new StringBuilder(l);
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '\\') {
                if (++i >= l) {
                    throw new VcsException("Unterminated escape sequence in the path: " + path);
                }
                char e = path.charAt(i);
                switch (e) {
                    case '\\': {
                        rc.append('\\');
                        break;
                    }
                    case 't': {
                        rc.append('\t');
                        break;
                    }
                    case 'n': {
                        rc.append('\n');
                        break;
                    }
                    case '\"': {
                        rc.append('\"');
                        break;
                    }
                    default: {
                        if (VcsFileUtil.isOctal((char)e)) {
                            int n = 0;
                            for (int j = i; j < l; ++j) {
                                if (VcsFileUtil.isOctal((char)path.charAt(j))) {
                                    ++n;
                                    for (int k = 0; k < 3 && j < l && VcsFileUtil.isOctal((char)path.charAt(j)); ++j, ++k) {
                                    }
                                }
                                if (j + 1 >= l || path.charAt(j) != '\\' || !VcsFileUtil.isOctal((char)path.charAt(j + 1))) break;
                            }
                            byte[] b = new byte[n];
                            n = 0;
                            while (i < l) {
                                if (VcsFileUtil.isOctal((char)path.charAt(i))) {
                                    int code = 0;
                                    for (int k = 0; k < 3 && i < l && VcsFileUtil.isOctal((char)path.charAt(i)); ++i, ++k) {
                                        code = code * 8 + (path.charAt(i) - 48);
                                    }
                                    b[n++] = (byte)code;
                                }
                                if (i + 1 >= l || path.charAt(i) != '\\' || !VcsFileUtil.isOctal((char)path.charAt(i + 1))) break;
                                ++i;
                            }
                            --i;
                            assert (n == b.length);
                            String encoding = GitConfigUtil.getFileNameEncoding();
                            try {
                                rc.append(new String(b, encoding));
                                break;
                            }
                            catch (UnsupportedEncodingException e1) {
                                throw new IllegalStateException("The file name encoding is unsupported: " + encoding);
                            }
                        }
                        throw new VcsException("Unknown escape sequence '\\" + path.charAt(i) + "' in the path: " + path);
                    }
                }
                continue;
            }
            rc.append(c);
        }
        String string = rc.toString();
        if (string == null) {
            GitUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    public static boolean justOneGitRepository(Project project) {
        if (project.isDisposed()) {
            return true;
        }
        GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
        return !manager.moreThanOneRoot();
    }

    @Nullable
    public static GitRemote findRemoteByName(@NotNull GitRepository repository, @NotNull String name) {
        if (repository == null) {
            GitUtil.$$$reportNull$$$0(19);
        }
        if (name == null) {
            GitUtil.$$$reportNull$$$0(20);
        }
        return GitUtil.findRemoteByName(repository.getRemotes(), name);
    }

    @Nullable
    public static GitRemote findRemoteByName(Collection<GitRemote> remotes, @NotNull String name) {
        if (name == null) {
            GitUtil.$$$reportNull$$$0(21);
        }
        return (GitRemote)ContainerUtil.find(remotes, remote -> {
            if (name == null) {
                GitUtil.$$$reportNull$$$0(105);
            }
            return remote.getName().equals(name);
        });
    }

    @Nullable
    public static GitRemoteBranch findRemoteBranch(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String nameAtRemote) {
        if (repository == null) {
            GitUtil.$$$reportNull$$$0(22);
        }
        if (remote == null) {
            GitUtil.$$$reportNull$$$0(23);
        }
        if (nameAtRemote == null) {
            GitUtil.$$$reportNull$$$0(24);
        }
        return (GitRemoteBranch)ContainerUtil.find(repository.getBranches().getRemoteBranches(), remoteBranch -> {
            if (remote == null) {
                GitUtil.$$$reportNull$$$0(103);
            }
            if (nameAtRemote == null) {
                GitUtil.$$$reportNull$$$0(104);
            }
            return remoteBranch.getRemote().equals(remote) && remoteBranch.getNameForRemoteOperations().equals(GitBranchUtil.stripRefsPrefix(nameAtRemote));
        });
    }

    @NotNull
    public static GitRemoteBranch findOrCreateRemoteBranch(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String branchName) {
        if (repository == null) {
            GitUtil.$$$reportNull$$$0(25);
        }
        if (remote == null) {
            GitUtil.$$$reportNull$$$0(26);
        }
        if (branchName == null) {
            GitUtil.$$$reportNull$$$0(27);
        }
        GitRemoteBranch remoteBranch = GitUtil.findRemoteBranch(repository, remote, branchName);
        GitRemoteBranch gitRemoteBranch = (GitRemoteBranch)ObjectUtils.notNull((Object)remoteBranch, (Object)new GitStandardRemoteBranch(remote, branchName));
        if (gitRemoteBranch == null) {
            GitUtil.$$$reportNull$$$0(28);
        }
        return gitRemoteBranch;
    }

    @NotNull
    public static Collection<VirtualFile> getRootsFromRepositories(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitUtil.$$$reportNull$$$0(29);
        }
        List list = ContainerUtil.map(repositories, REPOSITORY_TO_ROOT);
        if (list == null) {
            GitUtil.$$$reportNull$$$0(30);
        }
        return list;
    }

    @NotNull
    public static Collection<GitRepository> getRepositoriesFromRoots(@NotNull GitRepositoryManager repositoryManager, @NotNull Collection<? extends VirtualFile> roots) {
        if (repositoryManager == null) {
            GitUtil.$$$reportNull$$$0(31);
        }
        if (roots == null) {
            GitUtil.$$$reportNull$$$0(32);
        }
        ArrayList<GitRepository> repositories = new ArrayList<GitRepository>(roots.size());
        for (VirtualFile virtualFile : roots) {
            GitRepository repo = (GitRepository)repositoryManager.getRepositoryForRoot(virtualFile);
            if (repo == null) {
                LOG.error("Repository not found for root " + virtualFile);
                continue;
            }
            repositories.add(repo);
        }
        ArrayList<GitRepository> arrayList = repositories;
        if (arrayList == null) {
            GitUtil.$$$reportNull$$$0(33);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<String> getPathsDiffBetweenRefs(@NotNull Git git, @NotNull GitRepository repository, @NotNull String beforeRef, @NotNull String afterRef) throws VcsException {
        String range;
        List<String> parameters;
        GitCommandResult result2;
        if (git == null) {
            GitUtil.$$$reportNull$$$0(34);
        }
        if (repository == null) {
            GitUtil.$$$reportNull$$$0(35);
        }
        if (beforeRef == null) {
            GitUtil.$$$reportNull$$$0(36);
        }
        if (afterRef == null) {
            GitUtil.$$$reportNull$$$0(37);
        }
        if (!(result2 = git.diff(repository, parameters = Arrays.asList("--name-only", "--pretty=format:"), range = beforeRef + ".." + afterRef)).success()) {
            LOG.info(String.format("Couldn't get diff in range [%s] for repository [%s]", range, repository.toLogString()));
            List<String> list = Collections.emptyList();
            if (list == null) {
                GitUtil.$$$reportNull$$$0(38);
            }
            return list;
        }
        HashSet<String> remoteChanges = new HashSet<String>();
        StringScanner s = new StringScanner(result2.getOutputAsJoinedString());
        while (s.hasMoreData()) {
            String relative = s.line();
            if (StringUtil.isEmptyOrSpaces((String)relative)) continue;
            String path = repository.getRoot().getPath() + "/" + GitUtil.unescapePath(relative);
            remoteChanges.add(path);
        }
        HashSet<String> hashSet = remoteChanges;
        if (hashSet == null) {
            GitUtil.$$$reportNull$$$0(39);
        }
        return hashSet;
    }

    @NotNull
    public static GitRepositoryManager getRepositoryManager(@NotNull Project project) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(40);
        }
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(project);
        if (gitRepositoryManager == null) {
            GitUtil.$$$reportNull$$$0(41);
        }
        return gitRepositoryManager;
    }

    @Nullable
    public static GitRepository getRepositoryForRootOrLogError(@NotNull Project project, @NotNull VirtualFile root) {
        GitRepositoryManager manager;
        GitRepository repository;
        if (project == null) {
            GitUtil.$$$reportNull$$$0(42);
        }
        if (root == null) {
            GitUtil.$$$reportNull$$$0(43);
        }
        if ((repository = (GitRepository)(manager = GitUtil.getRepositoryManager(project)).getRepositoryForRoot(root)) == null) {
            LOG.error("Repository is null for root " + root);
        }
        return repository;
    }

    @NotNull
    public static String getPrintableRemotes(@NotNull Collection<GitRemote> remotes) {
        if (remotes == null) {
            GitUtil.$$$reportNull$$$0(44);
        }
        String string = StringUtil.join(remotes, remote -> remote.getName() + ": [" + StringUtil.join(remote.getUrls(), (String)", ") + "]", (String)"\n");
        if (string == null) {
            GitUtil.$$$reportNull$$$0(45);
        }
        return string;
    }

    public static void showSubmittedFiles(final Project project, final String revision, final VirtualFile file, final boolean local, final boolean revertable) {
        new Task.Backgroundable(project, GitBundle.message("changes.retrieving", revision)){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                try {
                    VirtualFile vcsRoot = GitUtil.getGitRoot(file);
                    GitCommittedChangeList changeList = GitChangeUtils.getRevisionChanges(project, vcsRoot, revision, true, local, revertable);
                    if (changeList != null) {
                        UIUtil.invokeLaterIfNeeded(() -> 1.lambda$run$0(project, (CommittedChangeList)changeList, revision));
                    }
                }
                catch (VcsException e) {
                    UIUtil.invokeLaterIfNeeded(() -> GitUIUtil.showOperationError(project, e, "git show"));
                }
            }

            private static /* synthetic */ void lambda$run$0(Project project2, CommittedChangeList changeList, String revision2) {
                AbstractVcsHelper.getInstance((Project)project2).showChangesListBrowser(changeList, GitBundle.message("paths.affected.title", revision2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/GitUtil$1", "run"));
            }
        }.queue();
    }

    @Nullable
    public static GitBranchTrackInfo getTrackInfoForCurrentBranch(@NotNull GitRepository repository) {
        GitLocalBranch currentBranch;
        if (repository == null) {
            GitUtil.$$$reportNull$$$0(46);
        }
        if ((currentBranch = repository.getCurrentBranch()) == null) {
            return null;
        }
        return GitBranchUtil.getTrackInfoForBranch(repository, currentBranch);
    }

    @NotNull
    public static Map<VirtualFile, List<VirtualFile>> sortFilesByGitRootsIgnoringOthers(@NotNull Collection<? extends VirtualFile> files) {
        Map<VirtualFile, List<VirtualFile>> map2;
        if (files == null) {
            GitUtil.$$$reportNull$$$0(47);
        }
        try {
            map2 = GitUtil.sortFilesByGitRoot(files, true);
        }
        catch (VcsException e) {
            LOG.error("Should never happen, since we passed 'ignore non-git' parameter", (Throwable)e);
            Map<VirtualFile, List<VirtualFile>> map3 = Collections.emptyMap();
            if (map3 == null) {
                GitUtil.$$$reportNull$$$0(49);
            }
            return map3;
        }
        if (map2 == null) {
            GitUtil.$$$reportNull$$$0(48);
        }
        return map2;
    }

    public static boolean hasLocalChanges(boolean staged, Project project, VirtualFile root) throws VcsException {
        GitLineHandler diff = new GitLineHandler(project, root, GitCommand.DIFF);
        diff.addParameters("--name-only");
        if (staged) {
            diff.addParameters("--cached");
        }
        diff.setStdoutSuppressed(true);
        diff.setStderrSuppressed(true);
        diff.setSilent(true);
        String output = Git.getInstance().runCommand(diff).getOutputOrThrow(new int[0]);
        return !output.trim().isEmpty();
    }

    @Nullable
    public static VirtualFile findRefreshFileOrLog(@NotNull String absolutePath) {
        VirtualFile file;
        if (absolutePath == null) {
            GitUtil.$$$reportNull$$$0(50);
        }
        if ((file = LocalFileSystem.getInstance().findFileByPath(absolutePath)) == null) {
            file = LocalFileSystem.getInstance().refreshAndFindFileByPath(absolutePath);
        }
        if (file == null) {
            LOG.debug("VirtualFile not found for " + absolutePath);
        }
        return file;
    }

    @NotNull
    public static String toAbsolute(@NotNull VirtualFile root, @NotNull String relativePath) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(51);
        }
        if (relativePath == null) {
            GitUtil.$$$reportNull$$$0(52);
        }
        String string = StringUtil.trimEnd((String)root.getPath(), (String)"/") + "/" + StringUtil.trimStart((String)relativePath, (String)"/");
        if (string == null) {
            GitUtil.$$$reportNull$$$0(53);
        }
        return string;
    }

    @NotNull
    public static Collection<String> toAbsolute(@NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(54);
        }
        if (relativePaths == null) {
            GitUtil.$$$reportNull$$$0(55);
        }
        List list = ContainerUtil.map(relativePaths, s -> {
            if (root == null) {
                GitUtil.$$$reportNull$$$0(102);
            }
            return GitUtil.toAbsolute(root, s);
        });
        if (list == null) {
            GitUtil.$$$reportNull$$$0(56);
        }
        return list;
    }

    @NotNull
    public static List<Change> findLocalChangesForPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<String> affectedPaths, boolean relativePaths) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(57);
        }
        if (root == null) {
            GitUtil.$$$reportNull$$$0(58);
        }
        if (affectedPaths == null) {
            GitUtil.$$$reportNull$$$0(59);
        }
        ChangeListManagerEx changeListManager = (ChangeListManagerEx)ChangeListManager.getInstance((Project)project);
        ArrayList<Change> affectedChanges = new ArrayList<Change>();
        for (String path : affectedPaths) {
            String absolutePath = relativePaths ? GitUtil.toAbsolute(root, path) : path;
            VirtualFile file = GitUtil.findRefreshFileOrLog(absolutePath);
            if (file == null) continue;
            Change change = changeListManager.getChange(file);
            if (change != null) {
                affectedChanges.add(change);
                continue;
            }
            String message = "Change is not found for " + file.getPath();
            if (changeListManager.isInUpdate()) {
                message = message + " because ChangeListManager is being updated.";
            }
            LOG.debug(message);
        }
        ArrayList<Change> arrayList = affectedChanges;
        if (arrayList == null) {
            GitUtil.$$$reportNull$$$0(60);
        }
        return arrayList;
    }

    public static void showPathsInDialog(@NotNull Project project, @NotNull Collection<String> absolutePaths, @NotNull String title, @Nullable String description) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(61);
        }
        if (absolutePaths == null) {
            GitUtil.$$$reportNull$$$0(62);
        }
        if (title == null) {
            GitUtil.$$$reportNull$$$0(63);
        }
        DialogBuilder builder = new DialogBuilder(project);
        builder.setCenterPanel((JComponent)new GitSimplePathsBrowser(project, absolutePaths));
        if (description != null) {
            builder.setNorthPanel((JComponent)new MultiLineLabel(description));
        }
        builder.addOkAction();
        builder.setTitle(title);
        builder.show();
    }

    @NotNull
    public static String cleanupErrorPrefixes(@NotNull String msg) {
        if (msg == null) {
            GitUtil.$$$reportNull$$$0(64);
        }
        String[] PREFIXES = new String[]{"fatal:", "error:"};
        msg = msg.trim();
        for (String prefix : PREFIXES) {
            if (!msg.startsWith(prefix)) continue;
            msg = msg.substring(prefix.length()).trim();
        }
        String string = msg;
        if (string == null) {
            GitUtil.$$$reportNull$$$0(65);
        }
        return string;
    }

    @Nullable
    public static GitRemote getDefaultRemote(@NotNull Collection<GitRemote> remotes) {
        if (remotes == null) {
            GitUtil.$$$reportNull$$$0(66);
        }
        return (GitRemote)ContainerUtil.find(remotes, r -> r.getName().equals("origin"));
    }

    @Nullable
    public static GitRemote getDefaultOrFirstRemote(@NotNull Collection<GitRemote> remotes) {
        if (remotes == null) {
            GitUtil.$$$reportNull$$$0(67);
        }
        return (GitRemote)ObjectUtils.chooseNotNull((Object)GitUtil.getDefaultRemote(remotes), (Object)ContainerUtil.getFirstItem(remotes));
    }

    @NotNull
    public static String joinToHtml(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitUtil.$$$reportNull$$$0(68);
        }
        String string = StringUtil.join(repositories, repository -> repository.getPresentableUrl(), (String)"<br/>");
        if (string == null) {
            GitUtil.$$$reportNull$$$0(69);
        }
        return string;
    }

    @NotNull
    public static String mention(@NotNull GitRepository repository) {
        if (repository == null) {
            GitUtil.$$$reportNull$$$0(70);
        }
        String string = GitUtil.getRepositoryManager(repository.getProject()).moreThanOneRoot() ? " in " + DvcsUtil.getShortRepositoryName((Repository)repository) : "";
        if (string == null) {
            GitUtil.$$$reportNull$$$0(71);
        }
        return string;
    }

    @NotNull
    public static String mention(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitUtil.$$$reportNull$$$0(72);
        }
        String string = GitUtil.mention(repositories, -1);
        if (string == null) {
            GitUtil.$$$reportNull$$$0(73);
        }
        return string;
    }

    @NotNull
    public static String mention(@NotNull Collection<? extends GitRepository> repositories, int limit) {
        if (repositories == null) {
            GitUtil.$$$reportNull$$$0(74);
        }
        if (repositories.isEmpty()) {
            if ("" == null) {
                GitUtil.$$$reportNull$$$0(75);
            }
            return "";
        }
        String string = " in " + DvcsUtil.joinShortNames(repositories, (int)limit);
        if (string == null) {
            GitUtil.$$$reportNull$$$0(76);
        }
        return string;
    }

    public static void updateRepositories(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitUtil.$$$reportNull$$$0(77);
        }
        for (GitRepository gitRepository : repositories) {
            gitRepository.update();
        }
    }

    public static boolean hasGitRepositories(@NotNull Project project) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(78);
        }
        return !GitUtil.getRepositories(project).isEmpty();
    }

    @NotNull
    public static Collection<GitRepository> getRepositories(@NotNull Project project) {
        if (project == null) {
            GitUtil.$$$reportNull$$$0(79);
        }
        List<GitRepository> list = GitUtil.getRepositoryManager(project).getRepositories();
        if (list == null) {
            GitUtil.$$$reportNull$$$0(80);
        }
        return list;
    }

    public static boolean isCaseOnlyChange(@NotNull String oldPath, @NotNull String newPath) {
        if (oldPath == null) {
            GitUtil.$$$reportNull$$$0(81);
        }
        if (newPath == null) {
            GitUtil.$$$reportNull$$$0(82);
        }
        if (oldPath.equalsIgnoreCase(newPath)) {
            if (oldPath.equals(newPath)) {
                LOG.info("Comparing perfectly equal paths: " + newPath);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static String getLogString(@NotNull String root, @NotNull Collection<? extends Change> changes) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(83);
        }
        if (changes == null) {
            GitUtil.$$$reportNull$$$0(84);
        }
        String string = GitUtil.getLogString(root, changes, ChangesUtil::getBeforePath, ChangesUtil::getAfterPath);
        if (string == null) {
            GitUtil.$$$reportNull$$$0(85);
        }
        return string;
    }

    @NotNull
    public static <T> String getLogString(@NotNull String root, @NotNull Collection<T> changes, @NotNull Convertor<? super T, ? extends FilePath> beforePathGetter, @NotNull Convertor<? super T, ? extends FilePath> afterPathGetter) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(86);
        }
        if (changes == null) {
            GitUtil.$$$reportNull$$$0(87);
        }
        if (beforePathGetter == null) {
            GitUtil.$$$reportNull$$$0(88);
        }
        if (afterPathGetter == null) {
            GitUtil.$$$reportNull$$$0(89);
        }
        String string = StringUtil.join(changes, change -> {
            if (afterPathGetter == null) {
                GitUtil.$$$reportNull$$$0(99);
            }
            if (beforePathGetter == null) {
                GitUtil.$$$reportNull$$$0(100);
            }
            if (root == null) {
                GitUtil.$$$reportNull$$$0(101);
            }
            FilePath after = (FilePath)afterPathGetter.convert(change);
            FilePath before = (FilePath)beforePathGetter.convert(change);
            if (before == null) {
                return "A: " + GitUtil.getRelativePath(root, after);
            }
            if (after == null) {
                return "D: " + GitUtil.getRelativePath(root, before);
            }
            if (ChangesUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY.equals((Object)before, (Object)after)) {
                return "M: " + GitUtil.getRelativePath(root, after);
            }
            return "R: " + GitUtil.getRelativePath(root, before) + " -> " + GitUtil.getRelativePath(root, after);
        }, (String)", ");
        if (string == null) {
            GitUtil.$$$reportNull$$$0(90);
        }
        return string;
    }

    @Nullable
    public static String getRelativePath(@NotNull String root, @NotNull FilePath after) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(91);
        }
        if (after == null) {
            GitUtil.$$$reportNull$$$0(92);
        }
        return FileUtil.getRelativePath((String)root, (String)after.getPath(), (char)File.separatorChar);
    }

    @NotNull
    public static Collection<Change> findCorrespondentLocalChanges(@NotNull ChangeListManager changeListManager, @NotNull Collection<? extends Change> originalChanges) {
        if (changeListManager == null) {
            GitUtil.$$$reportNull$$$0(93);
        }
        if (originalChanges == null) {
            GitUtil.$$$reportNull$$$0(94);
        }
        OpenTHashSet allChanges = new OpenTHashSet(changeListManager.getAllChanges());
        List list = ContainerUtil.mapNotNull(originalChanges, arg_0 -> ((OpenTHashSet)allChanges).get(arg_0));
        if (list == null) {
            GitUtil.$$$reportNull$$$0(95);
        }
        return list;
    }

    public static void refreshVfs(@NotNull VirtualFile root, @Nullable Collection<Change> changes) {
        if (root == null) {
            GitUtil.$$$reportNull$$$0(96);
        }
        if (changes == null || Registry.is((String)"git.refresh.vfs.total")) {
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{root});
        } else {
            RefreshVFsSynchronously.updateChanges(changes);
        }
    }

    public static void updateAndRefreshVfs(@NotNull GitRepository repository, @Nullable Collection<Change> changes) {
        if (repository == null) {
            GitUtil.$$$reportNull$$$0(97);
        }
        repository.update();
        GitUtil.refreshVfs(repository.getRoot(), changes);
    }

    public static void updateAndRefreshVfs(GitRepository ... repositories) {
        Arrays.stream(repositories).forEach(Repository::update);
        for (GitRepository repository : repositories) {
            GitUtil.refreshVfs(repository.getRoot(), null);
        }
    }

    public static boolean isGitRoot(@NotNull String rootDir) {
        String dotGit;
        FileAttributes attributes;
        if (rootDir == null) {
            GitUtil.$$$reportNull$$$0(98);
        }
        if ((attributes = FileSystemUtil.getAttributes((String)(dotGit = rootDir + File.separatorChar + DOT_GIT))) == null) {
            return false;
        }
        if (attributes.isDirectory()) {
            FileAttributes headExists = FileSystemUtil.getAttributes((String)(dotGit + File.separatorChar + "HEAD"));
            return headExists != null && headExists.isFile();
        }
        if (!attributes.isFile()) {
            return false;
        }
        String content = DvcsUtil.tryLoadFileOrReturn((File)new File(dotGit), null, (String)"UTF-8");
        if (content == null) {
            return false;
        }
        String pathToDir = GitUtil.parsePathToRepository(content);
        return GitUtil.findRealRepositoryDir(rootDir, pathToDir) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 16: 
            case 18: 
            case 28: 
            case 30: 
            case 33: 
            case 38: 
            case 39: 
            case 41: 
            case 45: 
            case 48: 
            case 49: 
            case 53: 
            case 56: 
            case 60: 
            case 65: 
            case 69: 
            case 71: 
            case 73: 
            case 75: 
            case 76: 
            case 80: 
            case 85: 
            case 90: 
            case 95: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 16: 
            case 18: 
            case 28: 
            case 30: 
            case 33: 
            case 38: 
            case 39: 
            case 41: 
            case 45: 
            case 48: 
            case 49: 
            case 53: 
            case 56: 
            case 60: 
            case 65: 
            case 69: 
            case 71: 
            case 73: 
            case 75: 
            case 76: 
            case 80: 
            case 85: 
            case 90: 
            case 95: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 16: 
            case 18: 
            case 28: 
            case 30: 
            case 33: 
            case 38: 
            case 39: 
            case 41: 
            case 45: 
            case 48: 
            case 49: 
            case 53: 
            case 56: 
            case 60: 
            case 65: 
            case 69: 
            case 71: 
            case 73: 
            case 75: 
            case 76: 
            case 80: 
            case 85: 
            case 90: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/GitUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dotGit";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 10: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 19: 
            case 22: 
            case 25: 
            case 35: 
            case 46: 
            case 70: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 20: 
            case 21: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 23: 
            case 26: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 24: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameAtRemote";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 29: 
            case 68: 
            case 72: 
            case 74: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryManager";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeRef";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterRef";
                break;
            }
            case 40: 
            case 42: 
            case 57: 
            case 61: 
            case 78: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 43: 
            case 51: 
            case 54: 
            case 58: 
            case 83: 
            case 86: 
            case 91: 
            case 96: 
            case 101: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 44: 
            case 66: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotes";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absolutePath";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePaths";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedPaths";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absolutePaths";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPath";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPath";
                break;
            }
            case 84: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 88: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforePathGetter";
                break;
            }
            case 89: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterPathGetter";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListManager";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/GitUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePathToRepository";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "sortFilesByGitRoot";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "sortFilePathsByGitRoot";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getGitRoots";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapePath";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateRemoteBranch";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsFromRepositories";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoriesFromRoots";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsDiffBetweenRefs";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryManager";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrintableRemotes";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "sortFilesByGitRootsIgnoringOthers";
                break;
            }
            case 53: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "toAbsolute";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "findLocalChangesForPaths";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanupErrorPrefixes";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "joinToHtml";
                break;
            }
            case 71: 
            case 73: 
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "mention";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 85: 
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogString";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "findCorrespondentLocalChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findGitDir";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findRealRepositoryDir";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parsePathToRepository";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 16: 
            case 18: 
            case 28: 
            case 30: 
            case 33: 
            case 38: 
            case 39: 
            case 41: 
            case 45: 
            case 48: 
            case 49: 
            case 53: 
            case 56: 
            case 60: 
            case 65: 
            case 69: 
            case 71: 
            case 73: 
            case 75: 
            case 76: 
            case 80: 
            case 85: 
            case 90: 
            case 95: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readContent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sortFilesByGitRoot";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sortFilePathsByGitRoot";
                break;
            }
            case 12: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getGitRoot";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getGitRootOrNull";
                break;
            }
            case 14: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "isGitRoot";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "unescapePath";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findRemoteByName";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findRemoteBranch";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateRemoteBranch";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getRootsFromRepositories";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoriesFromRoots";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getPathsDiffBetweenRefs";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryManager";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryForRootOrLogError";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getPrintableRemotes";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getTrackInfoForCurrentBranch";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "sortFilesByGitRootsIgnoringOthers";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "findRefreshFileOrLog";
                break;
            }
            case 51: 
            case 52: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "toAbsolute";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "findLocalChangesForPaths";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "showPathsInDialog";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "cleanupErrorPrefixes";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRemote";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultOrFirstRemote";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "joinToHtml";
                break;
            }
            case 70: 
            case 72: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "mention";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "updateRepositories";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "hasGitRepositories";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getRepositories";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "isCaseOnlyChange";
                break;
            }
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getLogString";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "findCorrespondentLocalChanges";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "refreshVfs";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "updateAndRefreshVfs";
                break;
            }
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getLogString$8";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "lambda$toAbsolute$5";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findRemoteBranch$3";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findRemoteByName$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 16: 
            case 18: 
            case 28: 
            case 30: 
            case 33: 
            case 38: 
            case 39: 
            case 41: 
            case 45: 
            case 48: 
            case 49: 
            case 53: 
            case 56: 
            case 60: 
            case 65: 
            case 69: 
            case 71: 
            case 73: 
            case 75: 
            case 76: 
            case 80: 
            case 85: 
            case 90: 
            case 95: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

