/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetTypeId;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacetModelBase
implements FacetModel {
    private volatile Map<FacetTypeId, Collection<Facet>> myType2Facets;
    private volatile Map<Pair<Facet, FacetTypeId>, Collection<Facet>> myChildFacets;
    private volatile Facet[] mySortedFacets;

    @NotNull
    public Facet[] getSortedFacets() {
        if (this.mySortedFacets == null) {
            Facet[] allFacets = this.getAllFacets();
            if (allFacets.length == 0) {
                this.mySortedFacets = Facet.EMPTY_ARRAY;
            } else {
                LinkedHashSet facets = new LinkedHashSet();
                for (Facet facet : allFacets) {
                    FacetModelBase.addUnderlyingFacets(facets, facet);
                }
                this.mySortedFacets = facets.toArray(Facet.EMPTY_ARRAY);
            }
        }
        if (this.mySortedFacets == null) {
            FacetModelBase.$$$reportNull$$$0(0);
        }
        return this.mySortedFacets;
    }

    private static void addUnderlyingFacets(LinkedHashSet<? super Facet> facets, Facet facet) {
        Facet underlyingFacet = facet.getUnderlyingFacet();
        if (underlyingFacet != null && !facets.contains(facet)) {
            FacetModelBase.addUnderlyingFacets(facets, underlyingFacet);
        }
        facets.add((Facet)facet);
    }

    @NotNull
    public <F extends Facet> Collection<F> getFacetsByType(@NotNull Facet underlyingFacet, FacetTypeId<F> typeId) {
        Collection<Facet> facets;
        if (underlyingFacet == null) {
            FacetModelBase.$$$reportNull$$$0(1);
        }
        if (this.myChildFacets == null) {
            MultiValuesMap children2 = new MultiValuesMap();
            for (Facet facet : this.getAllFacets()) {
                Facet underlying = facet.getUnderlyingFacet();
                if (underlying == null) continue;
                children2.put((Object)Pair.create((Object)underlying, (Object)facet.getTypeId()), (Object)facet);
            }
            HashMap<Pair<Facet, FacetTypeId>, Collection<Facet>> childFacets = new HashMap<Pair<Facet, FacetTypeId>, Collection<Facet>>();
            for (Pair pair : children2.keySet()) {
                Collection facets2 = children2.get((Object)pair);
                childFacets.put((Pair<Facet, FacetTypeId>)pair, Collections.unmodifiableCollection(facets2));
            }
            this.myChildFacets = childFacets;
        }
        Collection<Object> collection = (facets = this.myChildFacets.get(new Pair((Object)underlyingFacet, typeId))) != null ? facets : Collections.emptyList();
        if (collection == null) {
            FacetModelBase.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public String getFacetName(@NotNull Facet facet) {
        if (facet == null) {
            FacetModelBase.$$$reportNull$$$0(3);
        }
        String string = facet.getName();
        if (string == null) {
            FacetModelBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public <F extends Facet> F findFacet(FacetTypeId<F> type, String name) {
        Collection<F> fs = this.getFacetsByType(type);
        for (Facet f : fs) {
            if (!f.getName().equals(name)) continue;
            return (F)f;
        }
        return null;
    }

    @Nullable
    public <F extends Facet> F getFacetByType(@NotNull Facet underlyingFacet, FacetTypeId<F> typeId) {
        Collection<F> fs;
        if (underlyingFacet == null) {
            FacetModelBase.$$$reportNull$$$0(5);
        }
        return (F)((fs = this.getFacetsByType(underlyingFacet, typeId)).isEmpty() ? null : (Facet)fs.iterator().next());
    }

    @Nullable
    public <F extends Facet> F getFacetByType(FacetTypeId<F> typeId) {
        Collection<F> facets = this.getFacetsByType(typeId);
        return (F)(facets.isEmpty() ? null : (Facet)facets.iterator().next());
    }

    @NotNull
    public <F extends Facet> Collection<F> getFacetsByType(FacetTypeId<F> typeId) {
        Collection<Facet> facets;
        if (this.myType2Facets == null) {
            MultiValuesMap typeToFacets = new MultiValuesMap();
            for (Facet facet : this.getAllFacets()) {
                typeToFacets.put((Object)facet.getTypeId(), (Object)facet);
            }
            HashMap<FacetTypeId, Collection<Facet>> typeToFacetsCollection = new HashMap<FacetTypeId, Collection<Facet>>();
            for (FacetTypeId id : typeToFacets.keySet()) {
                Collection facets2 = typeToFacets.get((Object)id);
                typeToFacetsCollection.put(id, Collections.unmodifiableCollection(facets2));
            }
            this.myType2Facets = typeToFacetsCollection;
        }
        Collection<Object> collection = (facets = this.myType2Facets.get(typeId)) != null ? facets : Collections.emptyList();
        if (collection == null) {
            FacetModelBase.$$$reportNull$$$0(6);
        }
        return collection;
    }

    protected void facetsChanged() {
        this.myChildFacets = null;
        this.myType2Facets = null;
        this.mySortedFacets = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/FacetModelBase";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "underlyingFacet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedFacets";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/FacetModelBase";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetsByType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFacetsByType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFacetName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFacetByType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

