/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.AbstractCommonCheckinAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCommitChangesAction
extends AbstractCommonCheckinAction {
    @Override
    @NotNull
    protected FilePath[] getRoots(@NotNull VcsContext context) {
        if (context == null) {
            AbstractCommitChangesAction.$$$reportNull$$$0(0);
        }
        FilePath[] filePathArray = AbstractCommitChangesAction.getAllContentRoots(context);
        if (filePathArray == null) {
            AbstractCommitChangesAction.$$$reportNull$$$0(1);
        }
        return filePathArray;
    }

    @Override
    protected boolean approximatelyHasRoots(@NotNull VcsContext dataContext) {
        if (dataContext == null) {
            AbstractCommitChangesAction.$$$reportNull$$$0(2);
        }
        return ProjectLevelVcsManager.getInstance((Project)dataContext.getProject()).hasAnyMappings();
    }

    @Override
    protected void update(@NotNull VcsContext vcsContext, @NotNull Presentation presentation) {
        if (vcsContext == null) {
            AbstractCommitChangesAction.$$$reportNull$$$0(3);
        }
        if (presentation == null) {
            AbstractCommitChangesAction.$$$reportNull$$$0(4);
        }
        super.update(vcsContext, presentation);
        if (presentation.isEnabledAndVisible()) {
            Object[] changes2 = vcsContext.getSelectedChanges();
            if (((String)vcsContext.getPlace()).equals("ChangesViewPopup")) {
                Object[] changeLists = vcsContext.getSelectedChangeLists();
                presentation.setEnabled(!ArrayUtil.isEmpty((Object[])changeLists) ? changeLists.length == 1 && !changeLists[0].getChanges().isEmpty() : !ArrayUtil.isEmpty((Object[])changes2));
            }
            if (presentation.isEnabled() && !ArrayUtil.isEmpty((Object[])changes2)) {
                AbstractCommitChangesAction.disableIfAnyHijackedChanges((Project)ObjectUtils.notNull((Object)vcsContext.getProject()), presentation, (Change[])changes2);
            }
        }
    }

    private static void disableIfAnyHijackedChanges(@NotNull Project project, @NotNull Presentation presentation, @NotNull Change[] changes2) {
        if (project == null) {
            AbstractCommitChangesAction.$$$reportNull$$$0(5);
        }
        if (presentation == null) {
            AbstractCommitChangesAction.$$$reportNull$$$0(6);
        }
        if (changes2 == null) {
            AbstractCommitChangesAction.$$$reportNull$$$0(7);
        }
        ChangeListManager manager = ChangeListManager.getInstance((Project)project);
        boolean hasHijackedChanges = Stream.of(changes2).anyMatch(change -> change.getFileStatus() == FileStatus.HIJACKED && manager.getChangeList(change) == null);
        presentation.setEnabled(!hasHijackedChanges);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/AbstractCommitChangesAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsContext";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/AbstractCommitChangesAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "approximatelyHasRoots";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "disableIfAnyHijackedChanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

