/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.AppTopics;
import com.intellij.history.LocalHistory;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.lang.FileASTNode;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.EditorHighlighterCache;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbModeAction;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.NoAccessDuringPsiEvents;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.CollectingContentIterator;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdaterImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FlushingDaemon;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.PlatformIdTableBuilding;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartFMap;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.GistManagerImpl;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import com.intellij.util.indexing.ContentHashesSupport;
import com.intellij.util.indexing.CustomImplementationFileBasedIndexExtension;
import com.intellij.util.indexing.DeletedVirtualFileStub;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexProjectHandler;
import com.intellij.util.indexing.FileBasedIndexScanRunnableCollector;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.GlobalIndexFilter;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexAccessValidator;
import com.intellij.util.indexing.IndexConfiguration;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexedFilesListener;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.InvertedIndexUtil;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.PerIndexDocumentVersionMap;
import com.intellij.util.indexing.PersistentIndicesConfiguration;
import com.intellij.util.indexing.ProjectFilesCondition;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.indexing.RebuildStatus;
import com.intellij.util.indexing.SharedIndicesData;
import com.intellij.util.indexing.SilentProgressIndicator;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.StorageGuard;
import com.intellij.util.indexing.SubstitutedFileType;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.UpdateTask;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareMapIndexStorage;
import com.intellij.util.indexing.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.VfsEventsMerger;
import com.intellij.util.indexing.impl.InvertedIndexValueIterator;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileBasedIndexImpl
extends FileBasedIndex
implements BaseComponent,
Disposable {
    static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.indexing.FileBasedIndexImpl");
    private static final String CORRUPTION_MARKER_NAME = "corruption.marker";
    private static final NotificationGroup NOTIFICATIONS = new NotificationGroup("Indexing", NotificationDisplayType.BALLOON, false);
    private final List<ID<?, ?>> myIndicesForDirectories;
    private final Map<ID<?, ?>, DocumentUpdateTask> myUnsavedDataUpdateTasks;
    private final Set<ID<?, ?>> myNotRequiringContentIndices;
    private final Set<ID<?, ?>> myRequiringContentIndices;
    private final Set<ID<?, ?>> myPsiDependentIndices;
    private final Set<FileType> myNoLimitCheckTypes;
    private final PerIndexDocumentVersionMap myLastIndexedDocStamps;
    @NotNull
    private final ChangedFilesCollector myChangedFilesCollector;
    private final List<IndexableFileSet> myIndexableSets;
    private final Map<IndexableFileSet, Project> myIndexableSetToProjectMap;
    private final MessageBusConnection myConnection;
    private final FileDocumentManager myFileDocumentManager;
    private final FileTypeManagerImpl myFileTypeManager;
    private final Set<ID<?, ?>> myUpToDateIndicesForUnsavedOrTransactedDocuments;
    private volatile SmartFMap<Document, PsiFile> myTransactionMap;
    private final boolean myIsUnitTestMode;
    @Nullable
    private ScheduledFuture<?> myFlushingFuture;
    private final AtomicInteger myLocalModCount;
    private final AtomicInteger myFilesModCount;
    private final AtomicInteger myUpdatingFiles;
    private final Set<Project> myProjectsBeingUpdated;
    private final IndexAccessValidator myAccessValidator;
    private volatile boolean myInitialized;
    private Future<IndexConfiguration> myStateFuture;
    private volatile IndexConfiguration myState;
    private volatile Future<?> myAllIndicesInitializedFuture;
    private final AtomicBoolean myShutdownPerformed;
    private static final ThreadLocal<Integer> myUpToDateCheckState = new ThreadLocal();
    private final ThreadLocal<Boolean> myReentrancyGuard;
    private static final Key<SoftReference<ProjectIndexableFilesFilter>> ourProjectFilesSetKey = Key.create((String)"projectFiles");
    private final Lock myCalcIndexableFilesLock;
    private static final Key<WeakReference<FileContentImpl>> ourFileContentKey = Key.create((String)"unsaved.document.index.content");
    private final StorageGuard myStorageLock;
    private volatile boolean myPreviousDataBufferingState;
    private final Object myBufferingStateUpdateLock;
    static final Key<Boolean> ourPhysicalContentKey = Key.create((String)"physical.content.flag");
    private final VirtualFileUpdateTask myForceUpdateTask;
    private final AtomicInteger myForceUpdateRequests;
    private final Lock myReadLock;
    private final Lock myWriteLock;

    private IndexConfiguration getState() {
        IndexConfiguration state;
        if (!this.myInitialized) {
            LOG.error("Unexpected initialization problem");
        }
        if ((state = this.myState) == null) {
            try {
                this.myState = state = this.myStateFuture.get();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return state;
    }

    public FileBasedIndexImpl(VirtualFileManager vfManager, FileDocumentManager fdm, FileTypeManagerImpl fileTypeManager, @NotNull MessageBus bus) {
        if (bus == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(0);
        }
        this.myIndicesForDirectories = new SmartList();
        this.myUnsavedDataUpdateTasks = new ConcurrentHashMap();
        this.myNotRequiringContentIndices = new THashSet();
        this.myRequiringContentIndices = new THashSet();
        this.myPsiDependentIndices = new THashSet();
        this.myNoLimitCheckTypes = new THashSet();
        this.myLastIndexedDocStamps = new PerIndexDocumentVersionMap();
        this.myIndexableSets = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myIndexableSetToProjectMap = new THashMap();
        this.myUpToDateIndicesForUnsavedOrTransactedDocuments = ContainerUtil.newConcurrentSet();
        this.myTransactionMap = SmartFMap.emptyMap();
        this.myLocalModCount = new AtomicInteger();
        this.myFilesModCount = new AtomicInteger();
        this.myUpdatingFiles = new AtomicInteger();
        this.myProjectsBeingUpdated = ContainerUtil.newConcurrentSet();
        this.myAccessValidator = new IndexAccessValidator();
        this.myShutdownPerformed = new AtomicBoolean(false);
        this.myReentrancyGuard = ThreadLocal.withInitial(() -> Boolean.FALSE);
        this.myCalcIndexableFilesLock = new ReentrantLock();
        this.myStorageLock = new StorageGuard();
        this.myBufferingStateUpdateLock = new Object();
        this.myForceUpdateTask = new VirtualFileUpdateTask();
        this.myForceUpdateRequests = new AtomicInteger();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.myReadLock = lock.readLock();
        this.myWriteLock = lock.writeLock();
        this.myFileDocumentManager = fdm;
        this.myFileTypeManager = fileTypeManager;
        this.myIsUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        MessageBusConnection connection = bus.connect();
        connection.subscribe(PsiDocumentTransactionListener.TOPIC, (Object)new PsiDocumentTransactionListener(){

            @Override
            public void transactionStarted(@NotNull Document doc, @NotNull PsiFile file2) {
                if (doc == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                FileBasedIndexImpl.this.myTransactionMap = FileBasedIndexImpl.this.myTransactionMap.plus((Object)doc, (Object)file2);
                FileBasedIndexImpl.this.myUpToDateIndicesForUnsavedOrTransactedDocuments.clear();
            }

            @Override
            public void transactionCompleted(@NotNull Document doc, @NotNull PsiFile file2) {
                if (doc == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                FileBasedIndexImpl.this.myTransactionMap = FileBasedIndexImpl.this.myTransactionMap.minus((Object)doc);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "doc";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "transactionStarted";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "transactionCompleted";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){
            @Nullable
            private Map<FileType, Set<String>> myTypeToExtensionMap;

            public void beforeFileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                FileBasedIndexImpl.cleanupProcessedFlag();
                this.myTypeToExtensionMap = new THashMap();
                for (FileType type : FileBasedIndexImpl.this.myFileTypeManager.getRegisteredFileTypes()) {
                    this.myTypeToExtensionMap.put(type, this.getExtensions(type));
                }
            }

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                Map<FileType, Set<String>> oldExtensions = this.myTypeToExtensionMap;
                this.myTypeToExtensionMap = null;
                if (oldExtensions != null) {
                    THashMap newExtensions = new THashMap();
                    for (FileType type : FileBasedIndexImpl.this.myFileTypeManager.getRegisteredFileTypes()) {
                        newExtensions.put(type, this.getExtensions(type));
                    }
                    if (!newExtensions.keySet().containsAll(oldExtensions.keySet())) {
                        this.rebuildAllIndices();
                        return;
                    }
                    for (Map.Entry entry : oldExtensions.entrySet()) {
                        FileType fileType = (FileType)entry.getKey();
                        Set strings = (Set)entry.getValue();
                        if (((Set)newExtensions.get(fileType)).containsAll(strings)) continue;
                        this.rebuildAllIndices();
                        return;
                    }
                }
            }

            @NotNull
            private Set<String> getExtensions(@NotNull FileType type) {
                if (type == null) {
                    2.$$$reportNull$$$0(2);
                }
                THashSet set = new THashSet();
                for (FileNameMatcher matcher : FileBasedIndexImpl.this.myFileTypeManager.getAssociations(type)) {
                    set.add(matcher.getPresentableString());
                }
                THashSet tHashSet = set;
                if (tHashSet == null) {
                    2.$$$reportNull$$$0(3);
                }
                return tHashSet;
            }

            private void rebuildAllIndices() {
                FileBasedIndexImpl.this.doClearIndices();
                FileBasedIndexImpl.scheduleIndexRebuild("File type change");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/util/indexing/FileBasedIndexImpl$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexImpl$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getExtensions";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "beforeFileTypesChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "fileTypesChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getExtensions";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerListener(){

            public void fileContentReloaded(@NotNull VirtualFile file2, @NotNull Document document) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    3.$$$reportNull$$$0(1);
                }
                FileBasedIndexImpl.this.cleanupMemoryStorage(true);
            }

            public void unsavedDocumentsDropped() {
                FileBasedIndexImpl.this.cleanupMemoryStorage(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/util/indexing/FileBasedIndexImpl$3";
                objectArray[2] = "fileContentReloaded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void writeActionStarted(@NotNull Object action) {
                if (action == null) {
                    4.$$$reportNull$$$0(0);
                }
                FileBasedIndexImpl.this.myUpToDateIndicesForUnsavedOrTransactedDocuments.clear();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/util/indexing/FileBasedIndexImpl$4", "writeActionStarted"));
            }
        });
        this.myChangedFilesCollector = new ChangedFilesCollector();
        this.myConnection = connection;
        this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)this.myChangedFilesCollector);
    }

    @VisibleForTesting
    void doClearIndices() {
        this.waitUntilIndicesAreInitialized();
        IndexingStamp.flushCaches();
        for (ID<?, ?> indexId : this.getState().getIndexIDs()) {
            try {
                this.clearIndex(indexId);
            }
            catch (StorageException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    boolean processChangedFiles(@NotNull Project project, @NotNull Processor<? super VirtualFile> processor2) {
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(1);
        }
        if (processor2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(2);
        }
        return Stream.concat(this.myChangedFilesCollector.myVfsEventsMerger.getChangedFiles(), this.myChangedFilesCollector.myFilesToUpdate.values().stream()).filter(this.filesToBeIndexedForProjectCondition(project)).distinct().mapToInt(f -> {
            if (processor2 == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(152);
            }
            return processor2.process(f) ? 1 : 0;
        }).allMatch(success2 -> success2 == 1);
    }

    public static boolean isProjectOrWorkspaceFile(@NotNull VirtualFile file2, @Nullable FileType fileType) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(3);
        }
        return ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)file2, (FileType)fileType);
    }

    static boolean belongsToScope(VirtualFile file2, VirtualFile restrictedTo, GlobalSearchScope filter) {
        if (!(file2 instanceof VirtualFileWithId) || !file2.isValid()) {
            return false;
        }
        return !(restrictedTo != null && !Comparing.equal((Object)file2, (Object)restrictedTo) || filter != null && restrictedTo == null && !filter.accept(file2));
    }

    public void requestReindex(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(4);
        }
        ((GistManagerImpl)GistManager.getInstance()).invalidateData();
        this.myChangedFilesCollector.invalidateIndicesRecursively(file2, true);
        if (this.myInitialized) {
            this.myChangedFilesCollector.ensureUpToDateAsync();
        }
    }

    public void initComponent() {
        long started = System.nanoTime();
        List extensions = IndexInfrastructure.hasIndices() ? FileBasedIndexExtension.EXTENSION_POINT_NAME.getExtensionList() : Collections.emptyList();
        LOG.info("Index exts enumerated:" + (System.nanoTime() - started) / 1000000L + ", number of extensions:" + extensions.size());
        started = System.nanoTime();
        this.myStateFuture = IndexInfrastructure.submitGenesisTask(new FileIndexDataInitialization(extensions));
        LOG.info("Index scheduled:" + (System.nanoTime() - started) / 1000000L);
        if (!IndexInfrastructure.ourDoAsyncIndicesInitialization) {
            this.waitUntilIndicesAreInitialized();
        }
    }

    private void waitUntilIndicesAreInitialized() {
        try {
            this.myStateFuture.get();
        }
        catch (Throwable t) {
            LOG.error(t);
        }
    }

    private static <K, V> boolean registerIndexer(@NotNull FileBasedIndexExtension<K, V> extension, IndexConfiguration state) throws IOException {
        if (extension == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(5);
        }
        ID name = extension.getName();
        int version = extension.getVersion();
        File versionFile = IndexInfrastructure.getVersionFile(name);
        boolean versionChanged = false;
        if (IndexingStamp.versionDiffers(name, version)) {
            boolean versionFileExisted = versionFile.exists();
            if (versionFileExisted) {
                versionChanged = true;
                LOG.info("Version has changed for index " + name + ". The index will be rebuilt.");
            }
            if (extension.hasSnapshotMapping() && versionChanged) {
                FileUtil.deleteWithRenaming((File)IndexInfrastructure.getPersistentIndexRootDir(name));
            }
            File rootDir = IndexInfrastructure.getIndexRootDir(name);
            if (versionFileExisted) {
                FileUtil.deleteWithRenaming((File)rootDir);
            }
            IndexingStamp.rewriteVersion(name, version);
        }
        FileBasedIndexImpl.initIndexStorage(extension, version, state);
        return versionChanged;
    }

    private static <K, V> void initIndexStorage(@NotNull FileBasedIndexExtension<K, V> extension, int version, IndexConfiguration state) throws IOException {
        if (extension == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(6);
        }
        VfsAwareMapIndexStorage storage2 = null;
        ID name = extension.getName();
        boolean contentHashesEnumeratorOk = false;
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                if (extension.hasSnapshotMapping()) {
                    ContentHashesSupport.initContentHashesEnumerator();
                    contentHashesEnumeratorOk = true;
                }
                storage2 = new VfsAwareMapIndexStorage(IndexInfrastructure.getStorageFile(name), extension.getKeyDescriptor(), extension.getValueExternalizer(), extension.getCacheSize(), extension.keyIsUniqueForIndexedFile(), extension.traceKeyHashToVirtualFileMapping());
                FileBasedIndex.InputFilter inputFilter = extension.getInputFilter();
                THashSet addedTypes = new THashSet();
                if (inputFilter instanceof FileBasedIndex.FileTypeSpecificInputFilter) {
                    ((FileBasedIndex.FileTypeSpecificInputFilter)inputFilter).registerFileTypesUsedForIndexing(arg_0 -> FileBasedIndexImpl.lambda$initIndexStorage$2((Set)addedTypes, arg_0));
                }
                state.registerIndex(name, FileBasedIndexImpl.createIndex(extension, new MemoryIndexStorage(storage2, name)), file2 -> file2 instanceof VirtualFileWithId && inputFilter.acceptInput(file2) && !GlobalIndexFilter.isExcludedFromIndexViaFilters(file2, name), version + GlobalIndexFilter.getFiltersVersion(name), (Collection<? extends FileType>)addedTypes);
                break;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                boolean instantiatedStorage = storage2 != null;
                try {
                    if (storage2 != null) {
                        storage2.close();
                    }
                    storage2 = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                FileUtil.deleteWithRenaming((File)IndexInfrastructure.getIndexRootDir(name));
                if (extension.hasSnapshotMapping() && (!contentHashesEnumeratorOk || instantiatedStorage)) {
                    FileUtil.deleteWithRenaming((File)IndexInfrastructure.getPersistentIndexRootDir(name));
                }
                IndexingStamp.rewriteVersion(name, version);
                continue;
            }
        }
    }

    private static void saveRegisteredIndicesAndDropUnregisteredOnes(@NotNull Collection<ID<?, ?>> ids) {
        Throwable throwable;
        if (ids == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(7);
        }
        if (ApplicationManager.getApplication().isDisposed() || !IndexInfrastructure.hasIndices()) {
            return;
        }
        File registeredIndicesFile = new File(PathManager.getIndexRoot(), "registered");
        THashSet indicesToDrop = new THashSet();
        try {
            throwable = null;
            try (Iterator in = new DataInputStream(new BufferedInputStream(new FileInputStream(registeredIndicesFile)));){
                int size = ((DataInputStream)((Object)in)).readInt();
                for (int idx = 0; idx < size; ++idx) {
                    indicesToDrop.add(IOUtil.readString((DataInput)((Object)in)));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException in) {
            // empty catch block
        }
        for (ID<?, ?> key : ids) {
            indicesToDrop.remove(key.getName());
        }
        if (!indicesToDrop.isEmpty()) {
            LOG.info("Dropping indices:" + StringUtil.join((Collection)indicesToDrop, (String)","));
            for (String s : indicesToDrop) {
                FileUtil.deleteWithRenaming((File)IndexInfrastructure.getIndexRootDir(ID.create((String)s)));
            }
        }
        FileUtil.createIfDoesntExist((File)registeredIndicesFile);
        try {
            throwable = null;
            try (DataOutputStream os = new DataOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(registeredIndicesFile)));){
                os.writeInt(ids.size());
                for (ID<?, ?> id : ids) {
                    IOUtil.writeString((String)id.getName(), (DataOutput)os);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    private static <K, V> UpdatableIndex<K, V, FileContent> createIndex(@NotNull FileBasedIndexExtension<K, V> extension, @NotNull MemoryIndexStorage<K, V> storage2) throws StorageException, IOException {
        VfsAwareMapReduceIndex index;
        if (extension == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(8);
        }
        if (storage2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(9);
        }
        if (extension instanceof CustomImplementationFileBasedIndexExtension) {
            UpdatableIndex custom = ((CustomImplementationFileBasedIndexExtension)extension).createIndexImplementation(extension, storage2);
            if (!(custom instanceof VfsAwareMapReduceIndex)) {
                UpdatableIndex updatableIndex = custom;
                if (updatableIndex == null) {
                    FileBasedIndexImpl.$$$reportNull$$$0(10);
                }
                return updatableIndex;
            }
            index = (VfsAwareMapReduceIndex)custom;
        } else {
            index = new VfsAwareMapReduceIndex(extension, storage2);
        }
        VfsAwareMapReduceIndex vfsAwareMapReduceIndex = index;
        if (vfsAwareMapReduceIndex == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(11);
        }
        return vfsAwareMapReduceIndex;
    }

    public void dispose() {
        this.performShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performShutdown() {
        if (!this.myShutdownPerformed.compareAndSet(false, true)) {
            return;
        }
        this.waitUntilAllIndicesAreInitialized();
        try {
            if (this.myFlushingFuture != null) {
                this.myFlushingFuture.cancel(false);
                this.myFlushingFuture = null;
            }
        }
        finally {
            LOG.info("START INDEX SHUTDOWN");
            try {
                PersistentIndicesConfiguration.saveConfiguration();
                for (VirtualFile file2 : this.myChangedFilesCollector.getAllFilesToUpdate()) {
                    if (file2.isValid()) continue;
                    this.removeDataFromIndicesForFile(Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2)), file2);
                }
                IndexingStamp.flushCaches();
                IndexConfiguration state = this.getState();
                for (ID<?, ?> indexId : state.getIndexIDs()) {
                    try {
                        UpdatableIndex<?, ?, FileContent> index = state.getIndex(indexId);
                        assert (index != null);
                        if (!RebuildStatus.isOk(indexId)) {
                            index.clear();
                        }
                        index.dispose();
                    }
                    catch (Throwable throwable) {
                        LOG.info("Problem disposing " + indexId, throwable);
                    }
                }
                ContentHashesSupport.flushContentHashes();
                SharedIndicesData.flushData();
                this.myConnection.disconnect();
            }
            catch (Throwable e) {
                LOG.error("Problems during index shutdown", e);
            }
            LOG.info("END INDEX SHUTDOWN");
        }
    }

    private void waitUntilAllIndicesAreInitialized() {
        try {
            this.waitUntilIndicesAreInitialized();
            this.myAllIndicesInitializedFuture.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void removeDataFromIndicesForFile(int fileId, VirtualFile file2) {
        VirtualFile originalFile = file2 instanceof DeletedVirtualFileStub ? ((DeletedVirtualFileStub)file2).getOriginalFile() : file2;
        List<ID<?, ?>> states = IndexingStamp.getNontrivialFileIndexedStates(fileId);
        if (!states.isEmpty()) {
            ProgressManager.getInstance().executeNonCancelableSection(() -> this.removeFileDataFromIndices(states, fileId, originalFile));
        }
    }

    private void removeFileDataFromIndices(@NotNull Collection<ID<?, ?>> affectedIndices, int inputId, VirtualFile file2) {
        if (affectedIndices == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(12);
        }
        this.removeTransientFileDataFromIndices(affectedIndices, inputId, file2);
        Throwable unexpectedError = null;
        for (ID<?, ?> indexId : affectedIndices) {
            try {
                this.updateSingleIndex(indexId, null, inputId, null);
            }
            catch (ProcessCanceledException pce) {
                LOG.error((Throwable)pce);
            }
            catch (Throwable e) {
                LOG.info(e);
                if (unexpectedError != null) continue;
                unexpectedError = e;
            }
        }
        IndexingStamp.flushCache(inputId);
        if (unexpectedError != null) {
            LOG.error(unexpectedError);
        }
    }

    private void removeTransientFileDataFromIndices(Collection<ID<?, ?>> indices, int inputId, VirtualFile file2) {
        for (ID<?, ?> indexId : indices) {
            MapReduceIndex index = (MapReduceIndex)this.myState.getIndex(indexId);
            assert (index != null);
            index.removeTransientDataForFile(inputId);
        }
        Document document = this.myFileDocumentManager.getCachedDocument(file2);
        if (document != null) {
            this.myLastIndexedDocStamps.clearForDocument(document);
            document.putUserData(ourFileContentKey, null);
        }
        if (!this.myUpToDateIndicesForUnsavedOrTransactedDocuments.isEmpty()) {
            this.myUpToDateIndicesForUnsavedOrTransactedDocuments.clear();
        }
    }

    private void flushAllIndices(long modCount) {
        if (HeavyProcessLatch.INSTANCE.isRunning()) {
            return;
        }
        IndexingStamp.flushCaches();
        IndexConfiguration state = this.getState();
        for (ID<?, ?> indexId : new ArrayList(state.getIndexIDs())) {
            if (HeavyProcessLatch.INSTANCE.isRunning() || modCount != (long)this.myLocalModCount.get()) {
                return;
            }
            try {
                UpdatableIndex<?, ?, FileContent> index = state.getIndex(indexId);
                if (index == null) continue;
                index.flush();
            }
            catch (Throwable e) {
                this.requestRebuild(indexId, e);
            }
        }
        ContentHashesSupport.flushContentHashes();
        SharedIndicesData.flushData();
    }

    @NotNull
    public <K> Collection<K> getAllKeys(@NotNull ID<K, ?> indexId, @NotNull Project project) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(13);
        }
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(14);
        }
        THashSet allKeys = new THashSet();
        this.processAllKeys(indexId, Processors.cancelableCollectProcessor((Collection)allKeys), project);
        THashSet tHashSet = allKeys;
        if (tHashSet == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(15);
        }
        return tHashSet;
    }

    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<K> processor2, @Nullable Project project) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(16);
        }
        if (processor2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(17);
        }
        return this.processAllKeys(indexId, processor2, (GlobalSearchScope)(project == null ? new EverythingGlobalScope() : GlobalSearchScope.allScope((Project)project)), null);
    }

    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<K> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(18);
        }
        if (processor2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(19);
        }
        if (scope == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(20);
        }
        try {
            this.waitUntilIndicesAreInitialized();
            UpdatableIndex<K, ?, FileContent> index = this.getIndex(indexId);
            if (index == null) {
                return true;
            }
            this.ensureUpToDate(indexId, scope.getProject(), scope);
            return index.processAllKeys(processor2, scope, idFilter);
        }
        catch (StorageException e) {
            this.scheduleRebuild(indexId, e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StorageException || cause instanceof IOException) {
                this.scheduleRebuild(indexId, cause);
            }
            throw e;
        }
        return false;
    }

    public static <T, E extends Throwable> T disableUpToDateCheckIn(@NotNull ThrowableComputable<T, E> runnable2) throws E {
        if (runnable2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(21);
        }
        FileBasedIndexImpl.disableUpToDateCheckForCurrentThread();
        try {
            Object object = runnable2.compute();
            return (T)object;
        }
        finally {
            FileBasedIndexImpl.enableUpToDateCheckForCurrentThread();
        }
    }

    private static void disableUpToDateCheckForCurrentThread() {
        Integer currentValue = myUpToDateCheckState.get();
        myUpToDateCheckState.set(currentValue == null ? 1 : currentValue + 1);
    }

    private static void enableUpToDateCheckForCurrentThread() {
        Integer currentValue = myUpToDateCheckState.get();
        if (currentValue != null) {
            int newValue = currentValue - 1;
            if (newValue != 0) {
                myUpToDateCheckState.set(newValue);
            } else {
                myUpToDateCheckState.remove();
            }
        }
    }

    private static boolean isUpToDateCheckEnabled() {
        Integer value = myUpToDateCheckState.get();
        return value == null || value == 0;
    }

    public <K> void ensureUpToDate(@NotNull ID<K, ?> indexId, @Nullable Project project, @Nullable GlobalSearchScope filter) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(22);
        }
        this.ensureUpToDate(indexId, project, filter, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <K> void ensureUpToDate(@NotNull ID<K, ?> indexId, @Nullable Project project, @Nullable GlobalSearchScope filter, @Nullable VirtualFile restrictedFile) {
        block12: {
            if (indexId == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(23);
            }
            ProgressManager.checkCanceled();
            this.myChangedFilesCollector.ensureUpToDate();
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!this.needsFileContentLoading(indexId)) {
                return;
            }
            if (filter == GlobalSearchScope.EMPTY_SCOPE) {
                return;
            }
            if (ActionUtil.isDumbMode((Project)project)) {
                FileBasedIndexImpl.handleDumbMode(project);
            }
            NoAccessDuringPsiEvents.checkCallContext();
            if (this.myReentrancyGuard.get().booleanValue()) {
                return;
            }
            this.myReentrancyGuard.set(Boolean.TRUE);
            try {
                if (!FileBasedIndexImpl.isUpToDateCheckEnabled()) break block12;
                try {
                    if (!RebuildStatus.isOk(indexId)) {
                        throw new ProcessCanceledException();
                    }
                    this.forceUpdate(project, filter, restrictedFile);
                    this.indexUnsavedDocuments(indexId, project, filter, restrictedFile);
                }
                catch (RuntimeException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof StorageException || cause instanceof IOException) {
                        this.scheduleRebuild(indexId, e);
                        break block12;
                    }
                    throw e;
                }
            }
            finally {
                this.myReentrancyGuard.set(Boolean.FALSE);
            }
        }
    }

    private static void handleDumbMode(@Nullable Project project) {
        BackgroundableProcessIndicator indicator;
        ProgressIndicator progressIndicator;
        ProgressManager.checkCanceled();
        if (project != null && (progressIndicator = ProgressManager.getInstance().getProgressIndicator()) instanceof BackgroundableProcessIndicator && (indicator = (BackgroundableProcessIndicator)progressIndicator).getDumbModeAction() == DumbModeAction.WAIT) {
            assert (!ApplicationManager.getApplication().isDispatchThread());
            DumbService.getInstance((Project)project).waitForSmartMode();
            return;
        }
        throw IndexNotReadyException.create(project == null ? null : DumbServiceImpl.getInstance(project).getDumbModeStartTrace());
    }

    @NotNull
    public <K, V> List<V> getValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull GlobalSearchScope filter) {
        Iterator virtualFileIterator;
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(24);
        }
        if (dataKey == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(25);
        }
        if (filter == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(26);
        }
        VirtualFile restrictToFile = null;
        if (filter instanceof Iterable && (virtualFileIterator = ((Iterable)filter).iterator()).hasNext()) {
            VirtualFile restrictToFileCandidate = (VirtualFile)virtualFileIterator.next();
            if (!virtualFileIterator.hasNext()) {
                restrictToFile = restrictToFileCandidate;
            }
        }
        SmartList values = new SmartList();
        FileBasedIndex.ValueProcessor processor2 = (arg_0, arg_1) -> FileBasedIndexImpl.lambda$getValues$6((List)values, arg_0, arg_1);
        if (restrictToFile != null) {
            this.processValuesInOneFile(indexId, dataKey, restrictToFile, processor2, filter);
        } else {
            this.processValuesInScope(indexId, dataKey, true, filter, null, processor2);
        }
        SmartList smartList = values;
        if (smartList == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(27);
        }
        return smartList;
    }

    @NotNull
    public <K, V> Collection<VirtualFile> getContainingFiles(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull GlobalSearchScope filter) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(28);
        }
        if (dataKey == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(29);
        }
        if (filter == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(30);
        }
        THashSet files2 = new THashSet();
        this.processValuesInScope(indexId, dataKey, false, filter, null, (arg_0, arg_1) -> FileBasedIndexImpl.lambda$getContainingFiles$7((Set)files2, arg_0, arg_1));
        THashSet tHashSet = files2;
        if (tHashSet == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(31);
        }
        return tHashSet;
    }

    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull FileBasedIndex.ValueProcessor<V> processor2, @NotNull GlobalSearchScope filter) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(32);
        }
        if (dataKey == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(33);
        }
        if (processor2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(34);
        }
        if (filter == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(35);
        }
        return this.processValues(indexId, dataKey, inFile, processor2, filter, null);
    }

    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull FileBasedIndex.ValueProcessor<V> processor2, @NotNull GlobalSearchScope filter, @Nullable IdFilter idFilter) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(36);
        }
        if (dataKey == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(37);
        }
        if (processor2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(38);
        }
        if (filter == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(39);
        }
        return inFile != null ? this.processValuesInOneFile(indexId, dataKey, inFile, processor2, filter) : this.processValuesInScope(indexId, dataKey, false, filter, idFilter, processor2);
    }

    public <K, V> long getIndexModificationStamp(ID<K, V> indexId, @NotNull Project project) {
        UpdatableIndex<K, V, FileContent> index;
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(40);
        }
        if ((index = this.getState().getIndex(indexId)) instanceof MapReduceIndex) {
            this.ensureUpToDate(indexId, project, GlobalSearchScope.allScope((Project)project));
            return ((MapReduceIndex)index).getModificationStamp();
        }
        return -1L;
    }

    public <K, V> boolean processAllValues(@NotNull ID<K, V> indexId, @NotNull K key, @NotNull Project project, @NotNull IdValueProcessor<? super V> processor2) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(41);
        }
        if (key == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(42);
        }
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(43);
        }
        if (processor2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(44);
        }
        return this.processValueIterator(indexId, key, null, GlobalSearchScope.allScope((Project)project), valueIt -> {
            if (processor2 == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(151);
            }
            while (valueIt.hasNext()) {
                Object value = valueIt.next();
                ValueContainer.IntIterator inputIdsIterator = valueIt.getInputIdsIterator();
                while (inputIdsIterator.hasNext()) {
                    if (!processor2.process(inputIdsIterator.next(), value)) {
                        return false;
                    }
                    ProgressManager.checkCanceled();
                }
            }
            return true;
        });
    }

    @Nullable
    private <K, V, R> R processExceptions(@NotNull ID<K, V> indexId, @Nullable VirtualFile restrictToFile, @NotNull GlobalSearchScope filter, @NotNull ThrowableConvertor<? super UpdatableIndex<K, V, FileContent>, ? extends R, ? extends StorageException> computable) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(45);
        }
        if (filter == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(46);
        }
        if (computable == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(47);
        }
        try {
            this.waitUntilIndicesAreInitialized();
            UpdatableIndex index = this.getIndex(indexId);
            if (index == null) {
                return null;
            }
            Project project = filter.getProject();
            this.ensureUpToDate(indexId, project, filter, restrictToFile);
            return (R)this.myAccessValidator.validate(indexId, () -> {
                if (computable == null) {
                    FileBasedIndexImpl.$$$reportNull$$$0(149);
                }
                return ConcurrencyUtil.withLock((Lock)index.getReadLock(), () -> {
                    if (computable == null) {
                        FileBasedIndexImpl.$$$reportNull$$$0(150);
                    }
                    return computable.convert((Object)index);
                });
            });
        }
        catch (StorageException e) {
            this.scheduleRebuild(indexId, e);
        }
        catch (RuntimeException e) {
            Throwable cause = FileBasedIndexImpl.getCauseToRebuildIndex(e);
            if (cause != null) {
                this.scheduleRebuild(indexId, cause);
            }
            throw e;
        }
        return null;
    }

    private <K, V> boolean processValuesInOneFile(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull VirtualFile restrictToFile, @NotNull FileBasedIndex.ValueProcessor<? super V> processor2, @NotNull GlobalSearchScope scope) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(48);
        }
        if (dataKey == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(49);
        }
        if (restrictToFile == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(50);
        }
        if (processor2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(51);
        }
        if (scope == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(52);
        }
        if (!(restrictToFile instanceof VirtualFileWithId)) {
            return true;
        }
        int restrictedFileId = FileBasedIndexImpl.getFileId((VirtualFile)restrictToFile);
        return this.processValueIterator(indexId, dataKey, restrictToFile, scope, valueIt -> {
            if (processor2 == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(147);
            }
            if (restrictToFile == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(148);
            }
            while (valueIt.hasNext()) {
                Object value = valueIt.next();
                if (valueIt.getValueAssociationPredicate().contains(restrictedFileId) && !processor2.process(restrictToFile, value)) {
                    return false;
                }
                ProgressManager.checkCanceled();
            }
            return true;
        });
    }

    private <K, V> boolean processValuesInScope(@NotNull ID<K, V> indexId, @NotNull K dataKey, boolean ensureValueProcessedOnce, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter, @NotNull FileBasedIndex.ValueProcessor<? super V> processor2) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(53);
        }
        if (dataKey == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(54);
        }
        if (scope == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(55);
        }
        if (processor2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(56);
        }
        PersistentFS fs = (PersistentFS)ManagingFS.getInstance();
        IdFilter filter = idFilter != null ? idFilter : this.projectIndexableFiles(scope.getProject());
        return this.processValueIterator(indexId, dataKey, null, scope, valueIt -> {
            if (scope == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(145);
            }
            if (processor2 == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(146);
            }
            block0: while (valueIt.hasNext()) {
                Object value = valueIt.next();
                ValueContainer.IntIterator inputIdsIterator = valueIt.getInputIdsIterator();
                while (inputIdsIterator.hasNext()) {
                    int id = inputIdsIterator.next();
                    if (filter != null && !filter.containsFileId(id)) continue;
                    VirtualFile file2 = IndexInfrastructure.findFileByIdIfCached(fs, id);
                    if (file2 != null && scope.accept(file2)) {
                        if (!processor2.process(file2, value)) {
                            return false;
                        }
                        if (ensureValueProcessedOnce) {
                            ProgressManager.checkCanceled();
                            continue block0;
                        }
                    }
                    ProgressManager.checkCanceled();
                }
            }
            return true;
        });
    }

    private <K, V> boolean processValueIterator(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile restrictToFile, @NotNull GlobalSearchScope scope, @NotNull Processor<? super InvertedIndexValueIterator<V>> valueProcessor) {
        Boolean result2;
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(57);
        }
        if (dataKey == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(58);
        }
        if (scope == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(59);
        }
        if (valueProcessor == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(60);
        }
        return (result2 = (Boolean)this.processExceptions(indexId, restrictToFile, scope, index -> {
            if (valueProcessor == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(143);
            }
            if (dataKey == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(144);
            }
            return valueProcessor.process((Object)((InvertedIndexValueIterator)index.getData(dataKey).getValueIterator()));
        })) == null || result2 != false;
    }

    public <K, V> boolean processFilesContainingAllKeys(@NotNull ID<K, V> indexId, @NotNull Collection<K> dataKeys, @NotNull GlobalSearchScope filter, @Nullable Condition<V> valueChecker, @NotNull Processor<VirtualFile> processor2) {
        ProjectIndexableFilesFilter filesSet;
        TIntHashSet set;
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(61);
        }
        if (dataKeys == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(62);
        }
        if (filter == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(63);
        }
        if (processor2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(64);
        }
        return (set = this.collectFileIdsContainingAllKeys(indexId, dataKeys, filter, valueChecker, filesSet = this.projectIndexableFiles(filter.getProject()))) != null && FileBasedIndexImpl.processVirtualFiles(set, filter, processor2);
    }

    void filesUpdateEnumerationFinished() {
    }

    public void cleanupForNextTest() {
        this.myChangedFilesCollector.ensureUpToDate();
        this.myTransactionMap = SmartFMap.emptyMap();
        IndexConfiguration state = this.getState();
        for (ID<?, ?> indexId : state.getIndexIDs()) {
            MapReduceIndex index = (MapReduceIndex)state.getIndex(indexId);
            assert (index != null);
            MemoryIndexStorage memStorage = (MemoryIndexStorage)index.getStorage();
            ConcurrencyUtil.withLock((Lock)index.getReadLock(), () -> memStorage.clearCaches());
        }
    }

    public IndexedFilesListener getChangedFilesCollector() {
        return this.myChangedFilesCollector;
    }

    void filesUpdateStarted(Project project) {
        this.myChangedFilesCollector.ensureUpToDate();
        this.myProjectsBeingUpdated.add(project);
        this.myFilesModCount.incrementAndGet();
    }

    void filesUpdateFinished(@NotNull Project project) {
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(65);
        }
        this.myProjectsBeingUpdated.remove(project);
        this.myFilesModCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ProjectIndexableFilesFilter projectIndexableFiles(@Nullable Project project) {
        if (project == null || this.myUpdatingFiles.get() > 0) {
            return null;
        }
        if (this.myProjectsBeingUpdated.contains(project)) {
            return null;
        }
        SoftReference reference2 = (SoftReference)project.getUserData(ourProjectFilesSetKey);
        ProjectIndexableFilesFilter data = (ProjectIndexableFilesFilter)((Object)com.intellij.reference.SoftReference.dereference((Reference)reference2));
        int currentFileModCount = this.myFilesModCount.get();
        if (data != null && data.myModificationCount == currentFileModCount) {
            return data;
        }
        if (this.myCalcIndexableFilesLock.tryLock()) {
            try {
                reference2 = (SoftReference)project.getUserData(ourProjectFilesSetKey);
                data = (ProjectIndexableFilesFilter)((Object)com.intellij.reference.SoftReference.dereference((Reference)reference2));
                if (data != null && data.myModificationCount == currentFileModCount) {
                    ProjectIndexableFilesFilter projectIndexableFilesFilter = data;
                    return projectIndexableFilesFilter;
                }
                long start2 = System.currentTimeMillis();
                TIntArrayList filesSet = new TIntArrayList();
                this.iterateIndexableFiles(fileOrDir -> {
                    ProgressManager.checkCanceled();
                    if (fileOrDir instanceof VirtualFileWithId) {
                        filesSet.add(((VirtualFileWithId)fileOrDir).getId());
                    }
                    return true;
                }, project, (ProgressIndicator)SilentProgressIndicator.create());
                ProjectIndexableFilesFilter filter = new ProjectIndexableFilesFilter(filesSet, currentFileModCount);
                project.putUserData(ourProjectFilesSetKey, new SoftReference<ProjectIndexableFilesFilter>(filter));
                long finish = System.currentTimeMillis();
                LOG.debug(filesSet.size() + " files iterated in " + (finish - start2) + " ms");
                ProjectIndexableFilesFilter projectIndexableFilesFilter = filter;
                return projectIndexableFilesFilter;
            }
            finally {
                this.myCalcIndexableFilesLock.unlock();
            }
        }
        return null;
    }

    @Nullable
    private <K, V> TIntHashSet collectFileIdsContainingAllKeys(@NotNull ID<K, V> indexId, @NotNull Collection<K> dataKeys, @NotNull GlobalSearchScope filter, @Nullable Condition<? super V> valueChecker, @Nullable ProjectIndexableFilesFilter projectFilesFilter) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(66);
        }
        if (dataKeys == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(67);
        }
        if (filter == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(68);
        }
        ThrowableConvertor convertor = index -> {
            if (dataKeys == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(142);
            }
            return InvertedIndexUtil.collectInputIdsContainingAllKeys((InvertedIndex)index, (Collection)dataKeys, __ -> {
                ProgressManager.checkCanceled();
                return true;
            }, (Condition)valueChecker, projectFilesFilter == null ? null : projectFilesFilter::containsFileId);
        };
        return (TIntHashSet)this.processExceptions(indexId, null, filter, convertor);
    }

    private static boolean processVirtualFiles(@NotNull TIntHashSet ids, @NotNull GlobalSearchScope filter, @NotNull Processor<? super VirtualFile> processor2) {
        if (ids == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(69);
        }
        if (filter == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(70);
        }
        if (processor2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(71);
        }
        PersistentFS fs = (PersistentFS)ManagingFS.getInstance();
        return ids.forEach(id -> {
            if (filter == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(140);
            }
            if (processor2 == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(141);
            }
            ProgressManager.checkCanceled();
            VirtualFile file2 = IndexInfrastructure.findFileByIdIfCached(fs, id);
            if (file2 != null && filter.accept(file2)) {
                return processor2.process((Object)file2);
            }
            return true;
        });
    }

    @Nullable
    public static Throwable getCauseToRebuildIndex(@NotNull RuntimeException e) {
        if (e == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(72);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (e instanceof ProcessCanceledException) {
            return null;
        }
        if (e instanceof IndexOutOfBoundsException) {
            return e;
        }
        Throwable cause = e.getCause();
        if (cause instanceof StorageException || cause instanceof IOException || cause instanceof IllegalArgumentException) {
            return cause;
        }
        return null;
    }

    public <K, V> boolean getFilesWithKey(@NotNull ID<K, V> indexId, @NotNull Set<K> dataKeys, @NotNull Processor<VirtualFile> processor2, @NotNull GlobalSearchScope filter) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(73);
        }
        if (dataKeys == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(74);
        }
        if (processor2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(75);
        }
        if (filter == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(76);
        }
        return this.processFilesContainingAllKeys(indexId, dataKeys, filter, null, processor2);
    }

    public <K> void scheduleRebuild(@NotNull ID<K, ?> indexId, @NotNull Throwable e) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(77);
        }
        if (e == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(78);
        }
        this.requestRebuild(indexId, e);
    }

    private static void scheduleIndexRebuild(String reason) {
        LOG.info("scheduleIndexRebuild, reason: " + reason);
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            DumbService.getInstance((Project)project).queueTask((DumbModeTask)new UnindexedFilesUpdater(project));
        }
    }

    void clearIndicesIfNecessary() {
        this.waitUntilIndicesAreInitialized();
        for (ID<?, ?> indexId : this.getState().getIndexIDs()) {
            try {
                RebuildStatus.clearIndexIfNecessary(indexId, (ThrowableRunnable<StorageException>)((ThrowableRunnable)() -> this.getIndex(indexId).clear()));
            }
            catch (StorageException e) {
                this.requestRebuild(indexId);
                LOG.error((Throwable)e);
            }
        }
    }

    private void clearIndex(@NotNull ID<?, ?> indexId) throws StorageException {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(79);
        }
        this.advanceIndexVersion(indexId);
        UpdatableIndex<?, ?, FileContent> index = this.myState.getIndex(indexId);
        assert (index != null) : "Index with key " + indexId + " not found or not registered properly";
        index.clear();
    }

    private void advanceIndexVersion(ID<?, ?> indexId) {
        try {
            IndexingStamp.rewriteVersion(indexId, this.myState.getIndexVersion(indexId));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private Set<Document> getUnsavedDocuments() {
        Document[] documents = this.myFileDocumentManager.getUnsavedDocuments();
        if (documents.length == 0) {
            Set<Document> set = Collections.emptySet();
            if (set == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(80);
            }
            return set;
        }
        if (documents.length == 1) {
            Set<Document> set = Collections.singleton(documents[0]);
            if (set == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(81);
            }
            return set;
        }
        THashSet tHashSet = new THashSet(Arrays.asList(documents));
        if (tHashSet == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(82);
        }
        return tHashSet;
    }

    @NotNull
    private Set<Document> getTransactedDocuments() {
        Set set = this.myTransactionMap.keySet();
        if (set == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(83);
        }
        return set;
    }

    private void indexUnsavedDocuments(@NotNull ID<?, ?> indexId, @Nullable Project project, GlobalSearchScope filter, VirtualFile restrictedFile) {
        List documentsToProcessForProject;
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(84);
        }
        if (this.myUpToDateIndicesForUnsavedOrTransactedDocuments.contains(indexId)) {
            return;
        }
        Object documents = this.getUnsavedDocuments();
        boolean psiBasedIndex = this.myPsiDependentIndices.contains(indexId);
        if (psiBasedIndex) {
            Document[] uncommittedDocuments;
            Set<Document> transactedDocuments = this.getTransactedDocuments();
            if (documents.isEmpty()) {
                documents = transactedDocuments;
            } else if (!transactedDocuments.isEmpty()) {
                documents = new THashSet(documents);
                documents.addAll(transactedDocuments);
            }
            Document[] documentArray = uncommittedDocuments = project != null ? PsiDocumentManager.getInstance((Project)project).getUncommittedDocuments() : Document.EMPTY_ARRAY;
            if (uncommittedDocuments.length > 0) {
                List<Document> uncommittedDocumentsCollection = Arrays.asList(uncommittedDocuments);
                if (documents.isEmpty()) {
                    documents = uncommittedDocumentsCollection;
                } else {
                    if (!(documents instanceof THashSet)) {
                        documents = new THashSet((Collection)documents);
                    }
                    documents.addAll(uncommittedDocumentsCollection);
                }
            }
        }
        if (!documents.isEmpty() && !(documentsToProcessForProject = ContainerUtil.filter(documents, document -> FileBasedIndexImpl.belongsToScope(this.myFileDocumentManager.getFile(document), restrictedFile, filter))).isEmpty()) {
            DocumentUpdateTask task = this.myUnsavedDataUpdateTasks.get(indexId);
            assert (task != null) : "Task for unsaved data indexing was not initialized for index " + indexId;
            if (this.runUpdate(true, (Computable<Boolean>)((Computable)() -> task.processAll(documentsToProcessForProject, project))) && documentsToProcessForProject.size() == documents.size() && !this.hasActiveTransactions()) {
                ProgressManager.checkCanceled();
                this.myUpToDateIndicesForUnsavedOrTransactedDocuments.add(indexId);
            }
        }
    }

    private boolean hasActiveTransactions() {
        return !this.myTransactionMap.isEmpty();
    }

    private boolean indexUnsavedDocument(@NotNull Document document, @NotNull ID<?, ?> requestedIndexId, Project project, @NotNull VirtualFile vFile) {
        if (document == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(85);
        }
        if (requestedIndexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(86);
        }
        if (vFile == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(87);
        }
        PsiFile dominantContentFile = project == null ? null : FileBasedIndexImpl.findLatestKnownPsiForUncomittedDocument(document, project);
        DocumentContent content = dominantContentFile != null && dominantContentFile.getViewProvider().getModificationStamp() != document.getModificationStamp() ? new PsiContent(document, dominantContentFile) : new AuthenticContent(document);
        boolean psiBasedIndex = this.myPsiDependentIndices.contains(requestedIndexId);
        long currentDocStamp = psiBasedIndex ? PsiDocumentManager.getInstance((Project)project).getLastCommittedStamp(document) : content.getModificationStamp();
        long previousDocStamp = this.myLastIndexedDocStamps.get(document, requestedIndexId);
        if (previousDocStamp == currentDocStamp) {
            return false;
        }
        CharSequence contentText = content.getText();
        this.myFileTypeManager.freezeFileTypeTemporarilyIn(vFile, () -> {
            void previousDocStamp;
            if (vFile == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(137);
            }
            if (requestedIndexId == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(138);
            }
            if (document == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(139);
            }
            if (this.getAffectedIndexCandidates(vFile).contains(requestedIndexId) && this.getInputFilter(requestedIndexId).acceptInput(vFile)) {
                int inputId = Math.abs(FileBasedIndexImpl.getFileId((VirtualFile)vFile));
                if (!this.isTooLarge(vFile, contentText.length())) {
                    FileContentImpl newFc;
                    WeakReference previousContentRef = (WeakReference)document.getUserData(ourFileContentKey);
                    FileContentImpl previousContent = (FileContentImpl)((Object)((Object)com.intellij.reference.SoftReference.dereference((Reference)previousContentRef)));
                    if (previousContent != null && previousContent.getStamp() == currentDocStamp) {
                        newFc = previousContent;
                    } else {
                        newFc = new FileContentImpl(vFile, contentText, currentDocStamp);
                        document.putUserData(ourFileContentKey, new WeakReference<FileContentImpl>(newFc));
                    }
                    FileBasedIndexImpl.initFileContent(newFc, project, dominantContentFile);
                    newFc.ensureThreadSafeLighterAST();
                    if (content instanceof AuthenticContent) {
                        newFc.putUserData(PlatformIdTableBuilding.EDITOR_HIGHLIGHTER, EditorHighlighterCache.getEditorHighlighterForCachesBuilding(document));
                    }
                    try {
                        this.getIndex(requestedIndexId).update(inputId, (Object)newFc).compute();
                    }
                    finally {
                        FileBasedIndexImpl.cleanFileContent(newFc, dominantContentFile);
                    }
                } else {
                    this.getIndex(requestedIndexId).update(inputId, null).compute();
                }
            }
            long previousState = this.myLastIndexedDocStamps.set(document, requestedIndexId, currentDocStamp);
            assert (previousState == previousDocStamp);
        });
        return true;
    }

    @ApiStatus.Experimental
    public void runCleanupAction(@NotNull Runnable cleanupAction) {
        if (cleanupAction == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(88);
        }
        Computable updateComputable = () -> {
            if (cleanupAction == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(136);
            }
            cleanupAction.run();
            return true;
        };
        this.runUpdate(false, (Computable<Boolean>)updateComputable);
        this.runUpdate(true, (Computable<Boolean>)updateComputable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runUpdate(boolean transientInMemoryIndices, Computable<Boolean> update) {
        StorageGuard.StorageModeExitHandler storageModeExitHandler = this.myStorageLock.enter(transientInMemoryIndices);
        if (this.myPreviousDataBufferingState != transientInMemoryIndices) {
            Object object = this.myBufferingStateUpdateLock;
            synchronized (object) {
                if (this.myPreviousDataBufferingState != transientInMemoryIndices) {
                    IndexConfiguration state = this.getState();
                    for (ID<?, ?> indexId : state.getIndexIDs()) {
                        MapReduceIndex index = (MapReduceIndex)state.getIndex(indexId);
                        assert (index != null);
                        ((MemoryIndexStorage)index.getStorage()).setBufferingEnabled(transientInMemoryIndices);
                    }
                    this.myPreviousDataBufferingState = transientInMemoryIndices;
                }
            }
        }
        try {
            boolean bl = (Boolean)update.compute();
            return bl;
        }
        finally {
            storageModeExitHandler.leave();
        }
    }

    private void cleanupMemoryStorage(boolean skipPsiBasedIndices) {
        this.myLastIndexedDocStamps.clear();
        IndexConfiguration state = this.myState;
        if (state == null) {
            return;
        }
        for (ID<?, ?> indexId : state.getIndexIDs()) {
            if (skipPsiBasedIndices && this.myPsiDependentIndices.contains(indexId)) continue;
            MapReduceIndex index = (MapReduceIndex)state.getIndex(indexId);
            assert (index != null);
            MemoryIndexStorage memStorage = (MemoryIndexStorage)index.getStorage();
            ConcurrencyUtil.withLock((Lock)index.getWriteLock(), () -> memStorage.clearMemoryMap());
            memStorage.fireMemoryStorageCleared();
        }
    }

    public void requestRebuild(@NotNull ID<?, ?> indexId, Throwable throwable) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(89);
        }
        FileBasedIndexImpl.cleanupProcessedFlag();
        if (RebuildStatus.requestRebuild(indexId)) {
            String message = "Rebuild requested for index " + indexId;
            Application app = ApplicationManager.getApplication();
            if (app.isUnitTestMode() && app.isReadAccessAllowed() && !app.isDispatchThread()) {
                LOG.error(message, throwable);
            } else {
                LOG.info(message, throwable);
            }
            FileBasedIndexImpl.cleanupProcessedFlag();
            if (!this.myInitialized) {
                return;
            }
            this.advanceIndexVersion(indexId);
            Runnable rebuildRunnable = () -> FileBasedIndexImpl.scheduleIndexRebuild("checkRebuild");
            if (this.myIsUnitTestMode) {
                rebuildRunnable.run();
            } else {
                TransactionGuard.getInstance().submitTransactionLater((Disposable)app, rebuildRunnable);
            }
        }
    }

    public <K, V> UpdatableIndex<K, V, FileContent> getIndex(ID<K, V> indexId) {
        return this.getState().getIndex(indexId);
    }

    private FileBasedIndex.InputFilter getInputFilter(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(90);
        }
        if (!this.myInitialized) {
            this.waitUntilIndicesAreInitialized();
        }
        return this.getState().getInputFilter(indexId);
    }

    @NotNull
    Collection<VirtualFile> getFilesToUpdate(Project project) {
        Collection collection = this.myChangedFilesCollector.getAllFilesToUpdate().stream().filter(this.filesToBeIndexedForProjectCondition(project)).collect(Collectors.toList());
        if (collection == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(91);
        }
        return collection;
    }

    @NotNull
    private Predicate<VirtualFile> filesToBeIndexedForProjectCondition(Project project) {
        Predicate<VirtualFile> predicate = virtualFile -> {
            if (virtualFile instanceof DeletedVirtualFileStub) {
                return true;
            }
            for (IndexableFileSet set : this.myIndexableSets) {
                Project proj = this.myIndexableSetToProjectMap.get(set);
                if (proj != null && !proj.equals(project) || !((Boolean)ReadAction.compute(() -> set.isInSet(virtualFile))).booleanValue()) continue;
                return true;
            }
            return false;
        };
        if (predicate == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(92);
        }
        return predicate;
    }

    public boolean isFileUpToDate(VirtualFile file2) {
        return !this.myChangedFilesCollector.isScheduledForUpdate(file2);
    }

    void processRefreshedFile(@Nullable Project project, @NotNull com.intellij.ide.caches.FileContent fileContent) {
        VirtualFile file2;
        if (fileContent == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(93);
        }
        if (this.myChangedFilesCollector.isScheduledForUpdate(file2 = fileContent.getVirtualFile())) {
            this.indexFileContent(project, fileContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexFileContent(@Nullable Project project, @NotNull com.intellij.ide.caches.FileContent content) {
        if (content == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(94);
        }
        VirtualFile file2 = content.getVirtualFile();
        int fileId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
        try {
            if (file2.isValid() && content.getTimeStamp() != file2.getTimeStamp()) {
                content = new com.intellij.ide.caches.FileContent(file2);
            }
            if (!file2.isValid() || this.isTooLarge(file2)) {
                this.removeDataFromIndicesForFile(fileId, file2);
                if (file2 instanceof DeletedVirtualFileStub && ((DeletedVirtualFileStub)file2).isResurrected()) {
                    this.doIndexFileContent(project, new com.intellij.ide.caches.FileContent(((DeletedVirtualFileStub)file2).getOriginalFile()));
                }
            } else {
                this.doIndexFileContent(project, content);
            }
        }
        finally {
            IndexingStamp.flushCache(fileId);
        }
        this.myChangedFilesCollector.removeFileIdFromFilesScheduledForUpdate(fileId);
    }

    private void doIndexFileContent(@Nullable Project project, @NotNull com.intellij.ide.caches.FileContent content) {
        if (content == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(95);
        }
        VirtualFile file2 = content.getVirtualFile();
        this.myFileTypeManager.freezeFileTypeTemporarilyIn(file2, () -> {
            if (content == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(135);
            }
            FileType fileType = file2.getFileType();
            Project finalProject = project == null ? ProjectUtil.guessProjectForFile((VirtualFile)file2) : project;
            PsiFile psiFile = null;
            FileContentImpl fc = null;
            int inputId = Math.abs(FileBasedIndexImpl.getFileId((VirtualFile)file2));
            THashSet currentIndexedStates = new THashSet(IndexingStamp.getNontrivialFileIndexedStates(inputId));
            List<ID<?, ?>> affectedIndexCandidates = this.getAffectedIndexCandidates(file2);
            int size = affectedIndexCandidates.size();
            for (int i = 0; i < size; ++i) {
                ID<?, ?> indexId = affectedIndexCandidates.get(i);
                if (!this.shouldIndexFile(file2, indexId)) continue;
                if (fc == null) {
                    byte[] currentBytes;
                    try {
                        currentBytes = content.getBytes();
                    }
                    catch (IOException e) {
                        currentBytes = ArrayUtil.EMPTY_BYTE_ARRAY;
                    }
                    fc = new FileContentImpl(file2, currentBytes);
                    if (IdIndex.ourSnapshotMappingsEnabled) {
                        FileType substituteFileType = SubstitutedFileType.substituteFileType(file2, fileType, finalProject);
                        byte[] hash = fileType.isBinary() ? ContentHashesSupport.calcContentHash(currentBytes, substituteFileType) : ContentHashesSupport.calcContentHashWithFileType(currentBytes, fc.getCharset(), substituteFileType);
                        fc.setHash(hash);
                    }
                    psiFile = (PsiFile)content.getUserData(IndexingDataKeys.PSI_FILE);
                    FileBasedIndexImpl.initFileContent(fc, finalProject, psiFile);
                }
                try {
                    ProgressManager.checkCanceled();
                    this.updateSingleIndex(indexId, file2, inputId, fc);
                    currentIndexedStates.remove(indexId);
                    continue;
                }
                catch (ProcessCanceledException e) {
                    FileBasedIndexImpl.cleanFileContent(fc, psiFile);
                    throw e;
                }
            }
            if (psiFile != null) {
                psiFile.putUserData(PsiFileImpl.BUILDING_STUB, null);
            }
            for (ID indexId : currentIndexedStates) {
                if (this.getIndex(indexId).isIndexedStateForFile(inputId, file2)) continue;
                ProgressManager.checkCanceled();
                this.updateSingleIndex(indexId, file2, inputId, null);
            }
        });
    }

    public boolean isIndexingCandidate(@NotNull VirtualFile file2, @NotNull ID<?, ?> indexId) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(96);
        }
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(97);
        }
        return !this.isTooLarge(file2) && this.getAffectedIndexCandidates(file2).contains(indexId);
    }

    @NotNull
    private List<ID<?, ?>> getAffectedIndexCandidates(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(98);
        }
        if (file2.isDirectory()) {
            List<Object> list2 = FileBasedIndexImpl.isProjectOrWorkspaceFile(file2, null) ? Collections.emptyList() : this.myIndicesForDirectories;
            if (list2 == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(99);
            }
            return list2;
        }
        FileType fileType = file2.getFileType();
        if (FileBasedIndexImpl.isProjectOrWorkspaceFile(file2, fileType)) {
            List<ID<?, ?>> list3 = Collections.emptyList();
            if (list3 == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(100);
            }
            return list3;
        }
        List<ID<?, ?>> list4 = this.getState().getFileTypesForIndex(fileType);
        if (list4 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(101);
        }
        return list4;
    }

    private static void cleanFileContent(@NotNull FileContentImpl fc, PsiFile psiFile) {
        if (fc == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(102);
        }
        if (psiFile != null) {
            psiFile.putUserData(PsiFileImpl.BUILDING_STUB, null);
        }
        fc.putUserData(IndexingDataKeys.PSI_FILE, null);
    }

    private static void initFileContent(@NotNull FileContentImpl fc, Project project, PsiFile psiFile) {
        if (fc == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(103);
        }
        if (psiFile != null) {
            psiFile.putUserData(PsiFileImpl.BUILDING_STUB, (Object)true);
            fc.putUserData(IndexingDataKeys.PSI_FILE, psiFile);
        }
        fc.putUserData(IndexingDataKeys.PROJECT, project);
    }

    private void updateSingleIndex(@NotNull ID<?, ?> indexId, VirtualFile file2, int inputId, @Nullable FileContent currentFC) {
        boolean hasContent;
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(104);
        }
        if (!RebuildStatus.isOk(indexId) && !this.myIsUnitTestMode) {
            return;
        }
        this.myLocalModCount.incrementAndGet();
        UpdatableIndex<?, ?, FileContent> index = this.getIndex(indexId);
        assert (index != null);
        boolean bl = hasContent = currentFC != null;
        if (hasContent && currentFC.getUserData(ourPhysicalContentKey) == null) {
            currentFC.putUserData(ourPhysicalContentKey, (Object)Boolean.TRUE);
        }
        boolean updateCalculated = false;
        try {
            Computable update = index.update(inputId, currentFC);
            updateCalculated = true;
            this.scheduleUpdate(indexId, (Computable<Boolean>)update, file2, inputId, hasContent);
        }
        catch (RuntimeException exception) {
            Throwable causeToRebuildIndex = FileBasedIndexImpl.getCauseToRebuildIndex(exception);
            if (causeToRebuildIndex != null && (updateCalculated || causeToRebuildIndex instanceof IOException)) {
                this.requestRebuild(indexId, exception);
                return;
            }
            throw exception;
        }
    }

    private void forceUpdate(@Nullable Project project, @Nullable GlobalSearchScope filter, @Nullable VirtualFile restrictedTo) {
        Collection<VirtualFile> allFilesToUpdate = this.myChangedFilesCollector.getAllFilesToUpdate();
        if (!allFilesToUpdate.isEmpty()) {
            boolean includeFilesFromOtherProjects = restrictedTo == null && (this.myForceUpdateRequests.incrementAndGet() & 0x3F) == 0;
            List virtualFilesToBeUpdatedForProject = ContainerUtil.filter(allFilesToUpdate, (Condition)new ProjectFilesCondition(this.projectIndexableFiles(project), filter, restrictedTo, includeFilesFromOtherProjects));
            if (!virtualFilesToBeUpdatedForProject.isEmpty()) {
                this.myForceUpdateTask.processAll(virtualFilesToBeUpdatedForProject, project);
            }
        }
    }

    private void scheduleUpdate(@NotNull ID<?, ?> indexId, @NotNull Computable<Boolean> update, VirtualFile file2, int inputId, boolean hasContent) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(105);
        }
        if (update == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(106);
        }
        if (this.runUpdate(false, update)) {
            ConcurrencyUtil.withLock((Lock)this.myReadLock, () -> {
                if (indexId == null) {
                    FileBasedIndexImpl.$$$reportNull$$$0(134);
                }
                UpdatableIndex index = this.getIndex(indexId);
                if (hasContent) {
                    index.setIndexedStateForFile(inputId, file2);
                } else {
                    index.resetIndexedStateForFile(inputId);
                }
            });
        }
    }

    private boolean needsFileContentLoading(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(107);
        }
        return !this.myNotRequiringContentIndices.contains(indexId);
    }

    @Nullable
    private IndexableFileSet getIndexableSetForFile(VirtualFile file2) {
        for (IndexableFileSet set : this.myIndexableSets) {
            if (!set.isInSet(file2)) continue;
            return set;
        }
        return null;
    }

    private void doTransientStateChangeForFile(int fileId, @NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(108);
        }
        this.waitUntilIndicesAreInitialized();
        if (!this.clearUpToDateStateForPsiIndicesOfUnsavedDocuments(file2, IndexingStamp.getNontrivialFileIndexedStates(fileId))) {
            this.clearUpToDateStateForPsiIndicesOfVirtualFile(file2);
        }
    }

    private void doInvalidateIndicesForFile(int fileId, @NotNull VirtualFile file2, boolean contentChanged) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(109);
        }
        this.waitUntilIndicesAreInitialized();
        FileBasedIndexImpl.cleanProcessedFlag(file2);
        List<ID<?, ?>> nontrivialFileIndexedStates = IndexingStamp.getNontrivialFileIndexedStates(fileId);
        Collection fileIndexedStatesToUpdate = ContainerUtil.intersection(nontrivialFileIndexedStates, this.myRequiringContentIndices);
        if (contentChanged) {
            if (!fileIndexedStatesToUpdate.isEmpty()) {
                int size = nontrivialFileIndexedStates.size();
                for (int i = 0; i < size; ++i) {
                    ID<?, ?> indexId = nontrivialFileIndexedStates.get(i);
                    if (!this.needsFileContentLoading(indexId)) continue;
                    this.getIndex(indexId).resetIndexedStateForFile(fileId);
                }
                this.removeTransientFileDataFromIndices(nontrivialFileIndexedStates, fileId, file2);
                if (file2.isValid()) {
                    if (!this.isTooLarge(file2)) {
                        this.myChangedFilesCollector.scheduleForUpdate(file2);
                    } else {
                        this.myChangedFilesCollector.scheduleForUpdate((VirtualFile)new DeletedVirtualFileStub((VirtualFileWithId)file2));
                    }
                } else {
                    LOG.info("Unexpected state in update:" + file2);
                }
            }
        } else {
            for (ID<?, ?> indexId : nontrivialFileIndexedStates) {
                if (!this.myNotRequiringContentIndices.contains(indexId)) continue;
                this.updateSingleIndex(indexId, null, fileId, null);
            }
            if (!fileIndexedStatesToUpdate.isEmpty()) {
                this.myChangedFilesCollector.scheduleForUpdate((VirtualFile)new DeletedVirtualFileStub((VirtualFileWithId)file2));
            } else {
                this.myChangedFilesCollector.removeScheduledFileFromUpdate(file2);
            }
        }
    }

    private void scheduleFileForIndexing(int fileId, @NotNull VirtualFile file2, boolean contentChange) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(110);
        }
        boolean fileIsDirectory = file2.isDirectory();
        if (!contentChange) {
            FileContentImpl fileContent = null;
            for (ID<?, ?> indexId : fileIsDirectory ? this.myIndicesForDirectories : this.myNotRequiringContentIndices) {
                if (!this.getInputFilter(indexId).acceptInput(file2)) continue;
                if (fileContent == null) {
                    fileContent = new FileContentImpl(file2);
                    if (fileId < 0) {
                        fileId = -fileId;
                    }
                }
                this.updateSingleIndex(indexId, file2, fileId, fileContent);
            }
        }
        if (!fileIsDirectory) {
            if (!file2.isValid() || this.isTooLarge(file2)) {
                this.myChangedFilesCollector.removeScheduledFileFromUpdate(file2);
            } else {
                int finalFileId = fileId;
                this.myFileTypeManager.freezeFileTypeTemporarilyIn(file2, () -> {
                    if (file2 == null) {
                        FileBasedIndexImpl.$$$reportNull$$$0(133);
                    }
                    List<ID<?, ?>> candidates = this.getAffectedIndexCandidates(file2);
                    boolean scheduleForUpdate = false;
                    int size = candidates.size();
                    for (int i = 0; i < size; ++i) {
                        ID<?, ?> indexId = candidates.get(i);
                        if (!this.needsFileContentLoading(indexId) || !this.getInputFilter(indexId).acceptInput(file2)) continue;
                        this.getIndex(indexId).resetIndexedStateForFile(finalFileId);
                        scheduleForUpdate = true;
                    }
                    if (scheduleForUpdate) {
                        IndexingStamp.flushCache(finalFileId);
                        this.myChangedFilesCollector.scheduleForUpdate(file2);
                    }
                });
            }
        }
    }

    private boolean clearUpToDateStateForPsiIndicesOfUnsavedDocuments(@NotNull VirtualFile file2, Collection<? extends ID<?, ?>> affectedIndices) {
        Document document;
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(111);
        }
        if (!this.myUpToDateIndicesForUnsavedOrTransactedDocuments.isEmpty()) {
            this.myUpToDateIndicesForUnsavedOrTransactedDocuments.clear();
        }
        if ((document = this.myFileDocumentManager.getCachedDocument(file2)) != null && this.myFileDocumentManager.isDocumentUnsaved(document)) {
            this.myLastIndexedDocStamps.clearForDocument(document);
            document.putUserData(ourFileContentKey, null);
            return true;
        }
        this.removeTransientFileDataFromIndices(ContainerUtil.intersection(affectedIndices, this.myPsiDependentIndices), FileBasedIndexImpl.getFileId((VirtualFile)file2), file2);
        return false;
    }

    static int getIdMaskingNonIdBasedFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(112);
        }
        return file2 instanceof VirtualFileWithId ? ((VirtualFileWithId)file2).getId() : 0;
    }

    private boolean shouldIndexFile(@NotNull VirtualFile file2, @NotNull ID<?, ?> indexId) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(113);
        }
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(114);
        }
        return this.getInputFilter(indexId).acceptInput(file2) && (FileBasedIndexImpl.isMock(file2) || !this.getIndex(indexId).isIndexedStateForFile(((NewVirtualFile)file2).getId(), file2));
    }

    static boolean isMock(VirtualFile file2) {
        return !(file2 instanceof NewVirtualFile);
    }

    private boolean isTooLarge(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(115);
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(file2)) {
            return !this.myNoLimitCheckTypes.contains(file2.getFileType()) || SingleRootFileViewProvider.isTooLargeForContentLoading(file2);
        }
        return false;
    }

    private boolean isTooLarge(@NotNull VirtualFile file2, long contentSize) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(116);
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(file2, contentSize)) {
            return !this.myNoLimitCheckTypes.contains(file2.getFileType()) || SingleRootFileViewProvider.isTooLargeForContentLoading(file2, contentSize);
        }
        return false;
    }

    @NotNull
    CollectingContentIterator createContentIterator(@Nullable ProgressIndicator indicator) {
        UnindexedFilesFinder unindexedFilesFinder = new UnindexedFilesFinder();
        if (unindexedFilesFinder == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(117);
        }
        return unindexedFilesFinder;
    }

    public void registerIndexableSet(@NotNull IndexableFileSet set, @Nullable Project project) {
        if (set == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(118);
        }
        this.myIndexableSets.add(set);
        this.myIndexableSetToProjectMap.put(set, project);
        if (project != null) {
            ((PsiManagerImpl)PsiManager.getInstance((Project)project)).addTreeChangePreprocessor(event -> {
                VirtualFile virtualFile;
                PsiFile file2;
                if (event.isGenericChange() && event.getCode() == PsiTreeChangeEventImpl.PsiEventType.CHILDREN_CHANGED && (file2 = event.getFile()) != null && (virtualFile = file2.getVirtualFile()) instanceof VirtualFileWithId) {
                    this.myChangedFilesCollector.myVfsEventsMerger.recordTransientStateChangeEvent(FileBasedIndexImpl.getFileId((VirtualFile)virtualFile), virtualFile);
                }
            });
        }
    }

    private void clearUpToDateStateForPsiIndicesOfVirtualFile(VirtualFile virtualFile) {
        if (virtualFile instanceof VirtualFileWithId) {
            int fileId = ((VirtualFileWithId)virtualFile).getId();
            boolean wasIndexed = false;
            List<ID<?, ?>> candidates = this.getAffectedIndexCandidates(virtualFile);
            for (ID<?, ?> psiBackedIndex : this.myPsiDependentIndices) {
                if (!candidates.contains(psiBackedIndex) || !this.getInputFilter(psiBackedIndex).acceptInput(virtualFile)) continue;
                this.getIndex(psiBackedIndex).resetIndexedStateForFile(fileId);
                wasIndexed = true;
            }
            if (wasIndexed) {
                this.myChangedFilesCollector.scheduleForUpdate(virtualFile);
                IndexingStamp.flushCache(fileId);
            }
        }
    }

    public void removeIndexableSet(@NotNull IndexableFileSet set) {
        if (set == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(119);
        }
        if (!this.myIndexableSetToProjectMap.containsKey(set)) {
            return;
        }
        this.myIndexableSets.remove(set);
        this.myIndexableSetToProjectMap.remove(set);
        for (VirtualFile file2 : this.myChangedFilesCollector.getAllFilesToUpdate()) {
            int fileId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
            if (!file2.isValid()) {
                this.removeDataFromIndicesForFile(fileId, file2);
                this.myChangedFilesCollector.removeFileIdFromFilesScheduledForUpdate(fileId);
                continue;
            }
            if (this.getIndexableSetForFile(file2) != null) continue;
            this.myChangedFilesCollector.removeFileIdFromFilesScheduledForUpdate(fileId);
        }
        IndexingStamp.flushCaches();
    }

    public VirtualFile findFileById(Project project, int id) {
        return IndexInfrastructure.findFileById((PersistentFS)ManagingFS.getInstance(), id);
    }

    @Nullable
    private static PsiFile findLatestKnownPsiForUncomittedDocument(@NotNull Document doc, @NotNull Project project) {
        if (doc == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(120);
        }
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(121);
        }
        return PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(doc);
    }

    private static void cleanupProcessedFlag() {
        VirtualFile[] roots;
        for (VirtualFile root : roots = ManagingFS.getInstance().getRoots()) {
            FileBasedIndexImpl.cleanProcessedFlag(root);
        }
    }

    private static void cleanProcessedFlag(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(122);
        }
        if (!(file2 instanceof VirtualFileSystemEntry)) {
            return;
        }
        VirtualFileSystemEntry nvf = (VirtualFileSystemEntry)file2;
        if (file2.isDirectory()) {
            nvf.setFileIndexed(false);
            for (VirtualFile child2 : nvf.getCachedChildren()) {
                FileBasedIndexImpl.cleanProcessedFlag(child2);
            }
        } else {
            nvf.setFileIndexed(false);
        }
    }

    public void iterateIndexableFilesConcurrently(@NotNull ContentIterator processor2, @NotNull Project project, @NotNull ProgressIndicator indicator) {
        if (processor2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(123);
        }
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(124);
        }
        if (indicator == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(125);
        }
        PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible(FileBasedIndexImpl.collectScanRootRunnables(processor2, project, indicator));
    }

    public void iterateIndexableFiles(@NotNull ContentIterator processor2, @NotNull Project project, ProgressIndicator indicator) {
        if (processor2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(126);
        }
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(127);
        }
        for (Runnable r : FileBasedIndexImpl.collectScanRootRunnables(processor2, project, indicator)) {
            r.run();
        }
    }

    @NotNull
    private static List<Runnable> collectScanRootRunnables(@NotNull ContentIterator processor2, @NotNull Project project, ProgressIndicator indicator) {
        if (processor2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(128);
        }
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(129);
        }
        FileBasedIndexScanRunnableCollector collector = FileBasedIndexScanRunnableCollector.getInstance(project);
        List<Runnable> list2 = collector.collectScanRootRunnables(processor2, indicator);
        if (list2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(130);
        }
        return list2;
    }

    public void invalidateCaches() {
        File indexRoot = PathManager.getIndexRoot();
        File corruptionMarker = new File(indexRoot, CORRUPTION_MARKER_NAME);
        LOG.info("Requesting explicit indices invalidation", new Throwable());
        try {
            new FileOutputStream(corruptionMarker).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    public void waitForVfsEventsExecuted(long timeout, @NotNull TimeUnit timeUnit) throws Exception {
        void unit;
        if (timeUnit == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(131);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> this.lambda$waitForVfsEventsExecuted$31(timeout, (TimeUnit)unit));
        while (!future2.isDone()) {
            UIUtil.dispatchAllInvocationEvents();
        }
        future2.get();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$waitForVfsEventsExecuted$31(long timeout, @NotNull TimeUnit timeUnit) {
        if (timeUnit == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(132);
        }
        try {
            void unit;
            ((BoundedTaskExecutor)this.myChangedFilesCollector.myVfsEventsExecutor).waitAllTasksExecuted(timeout, (TimeUnit)unit);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ boolean lambda$getContainingFiles$7(Set files2, VirtualFile file2, Object value) {
        files2.add(file2);
        return true;
    }

    private static /* synthetic */ boolean lambda$getValues$6(List values, VirtualFile file2, Object value) {
        values.add(value);
        return true;
    }

    private static /* synthetic */ void lambda$initIndexStorage$2(Set addedTypes, FileType type) {
        if (type != null) {
            addedTypes.add(type);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 15: 
            case 27: 
            case 31: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 91: 
            case 92: 
            case 99: 
            case 100: 
            case 101: 
            case 117: 
            case 130: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 15: 
            case 27: 
            case 31: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 91: 
            case 92: 
            case 99: 
            case 100: 
            case 101: 
            case 117: 
            case 130: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 1: 
            case 14: 
            case 40: 
            case 43: 
            case 65: 
            case 121: 
            case 124: 
            case 127: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 17: 
            case 19: 
            case 34: 
            case 38: 
            case 44: 
            case 51: 
            case 56: 
            case 64: 
            case 71: 
            case 75: 
            case 123: 
            case 126: 
            case 128: 
            case 141: 
            case 146: 
            case 147: 
            case 151: 
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 4: 
            case 96: 
            case 98: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 122: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 7: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 10: 
            case 11: 
            case 15: 
            case 27: 
            case 31: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 91: 
            case 92: 
            case 99: 
            case 100: 
            case 101: 
            case 117: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/FileBasedIndexImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedIndices";
                break;
            }
            case 13: 
            case 16: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 32: 
            case 36: 
            case 41: 
            case 45: 
            case 48: 
            case 53: 
            case 57: 
            case 61: 
            case 66: 
            case 73: 
            case 77: 
            case 79: 
            case 84: 
            case 89: 
            case 90: 
            case 97: 
            case 104: 
            case 105: 
            case 107: 
            case 114: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 20: 
            case 52: 
            case 55: 
            case 59: 
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 25: 
            case 29: 
            case 33: 
            case 37: 
            case 49: 
            case 54: 
            case 58: 
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKey";
                break;
            }
            case 26: 
            case 30: 
            case 35: 
            case 39: 
            case 46: 
            case 63: 
            case 68: 
            case 70: 
            case 76: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 47: 
            case 149: 
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 50: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictToFile";
                break;
            }
            case 60: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueProcessor";
                break;
            }
            case 62: 
            case 67: 
            case 74: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKeys";
                break;
            }
            case 72: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 85: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 86: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestedIndexId";
                break;
            }
            case 87: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 88: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cleanupAction";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
            case 94: 
            case 95: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 102: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fc";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 118: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 131: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexImpl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createIndex";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeys";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFiles";
                break;
            }
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsavedDocuments";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransactedDocuments";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToUpdate";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "filesToBeIndexedForProjectCondition";
                break;
            }
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedIndexCandidates";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "createContentIterator";
                break;
            }
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "collectScanRootRunnables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processChangedFiles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isProjectOrWorkspaceFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "requestReindex";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerIndexer";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "initIndexStorage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "saveRegisteredIndicesAndDropUnregisteredOnes";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createIndex";
                break;
            }
            case 10: 
            case 11: 
            case 15: 
            case 27: 
            case 31: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 91: 
            case 92: 
            case 99: 
            case 100: 
            case 101: 
            case 117: 
            case 130: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeFileDataFromIndices";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAllKeys";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "disableUpToDateCheckIn";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "ensureUpToDate";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFiles";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processValues";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getIndexModificationStamp";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "processAllValues";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "processExceptions";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "processValuesInOneFile";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "processValuesInScope";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "processValueIterator";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "processFilesContainingAllKeys";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "filesUpdateFinished";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "collectFileIdsContainingAllKeys";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "processVirtualFiles";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getCauseToRebuildIndex";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getFilesWithKey";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "scheduleRebuild";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "clearIndex";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "indexUnsavedDocuments";
                break;
            }
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "indexUnsavedDocument";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "runCleanupAction";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "requestRebuild";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getInputFilter";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "processRefreshedFile";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "indexFileContent";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "doIndexFileContent";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "isIndexingCandidate";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedIndexCandidates";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "cleanFileContent";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "initFileContent";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "updateSingleIndex";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "scheduleUpdate";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "needsFileContentLoading";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "doTransientStateChangeForFile";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "doInvalidateIndicesForFile";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "scheduleFileForIndexing";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "clearUpToDateStateForPsiIndicesOfUnsavedDocuments";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "getIdMaskingNonIdBasedFile";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "shouldIndexFile";
                break;
            }
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "isTooLarge";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "registerIndexableSet";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "removeIndexableSet";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "findLatestKnownPsiForUncomittedDocument";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "cleanProcessedFlag";
                break;
            }
            case 123: 
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "iterateIndexableFilesConcurrently";
                break;
            }
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "iterateIndexableFiles";
                break;
            }
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "collectScanRootRunnables";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "waitForVfsEventsExecuted";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "lambda$waitForVfsEventsExecuted$31";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "lambda$scheduleFileForIndexing$29";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "lambda$scheduleUpdate$28";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doIndexFileContent$27";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runCleanupAction$22";
                break;
            }
            case 137: 
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "lambda$indexUnsavedDocument$21";
                break;
            }
            case 140: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processVirtualFiles$18";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectFileIdsContainingAllKeys$17";
                break;
            }
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processValueIterator$13";
                break;
            }
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processValuesInScope$12";
                break;
            }
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processValuesInOneFile$11";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processExceptions$10";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$9";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processAllValues$8";
                break;
            }
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processChangedFiles$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 15: 
            case 27: 
            case 31: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 91: 
            case 92: 
            case 99: 
            case 100: 
            case 101: 
            case 117: 
            case 130: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class FileIndexDataInitialization
    extends IndexInfrastructure.DataInitialization<IndexConfiguration> {
        private final IndexConfiguration state;
        private final AtomicBoolean versionChanged;
        private boolean currentVersionCorrupted;
        private SerializationManagerEx mySerializationManagerEx;

        FileIndexDataInitialization(List<? extends FileBasedIndexExtension> extensions) {
            if (extensions == null) {
                FileIndexDataInitialization.$$$reportNull$$$0(0);
            }
            this.state = new IndexConfiguration();
            this.versionChanged = new AtomicBoolean();
            if (!extensions.isEmpty()) {
                extensions = ContainerUtil.copyList(extensions);
                extensions.sort(Comparator.comparingInt(o -> o.dependsOnFileContent() ? 1 : 0));
            }
            for (FileBasedIndexExtension extension : extensions) {
                ID name = extension.getName();
                RebuildStatus.registerIndex(name);
                FileBasedIndexImpl.this.myUnsavedDataUpdateTasks.put(name, new DocumentUpdateTask(name));
                if (!extension.dependsOnFileContent()) {
                    if (extension.indexDirectories()) {
                        FileBasedIndexImpl.this.myIndicesForDirectories.add(name);
                    }
                    FileBasedIndexImpl.this.myNotRequiringContentIndices.add(name);
                } else {
                    FileBasedIndexImpl.this.myRequiringContentIndices.add(name);
                }
                if (extension instanceof PsiDependentIndex) {
                    FileBasedIndexImpl.this.myPsiDependentIndices.add(name);
                }
                FileBasedIndexImpl.this.myNoLimitCheckTypes.addAll(extension.getFileTypesWithSizeLimitNotApplicable());
                this.addNestedInitializationTask(() -> {
                    try {
                        this.versionChanged.compareAndSet(false, FileBasedIndexImpl.registerIndexer(extension, this.state));
                    }
                    catch (IOException io) {
                        throw io;
                    }
                    catch (Throwable t) {
                        PluginManager.handleComponentError(t, extension.getClass().getName(), null);
                    }
                });
            }
        }

        @Override
        protected void prepare() {
            this.mySerializationManagerEx = SerializationManagerEx.getInstanceEx();
            File indexRoot = PathManager.getIndexRoot();
            PersistentIndicesConfiguration.loadConfiguration();
            File corruptionMarker = new File(indexRoot, FileBasedIndexImpl.CORRUPTION_MARKER_NAME);
            boolean bl = this.currentVersionCorrupted = IndexInfrastructure.hasIndices() && corruptionMarker.exists();
            if (this.currentVersionCorrupted) {
                FileUtil.deleteWithRenaming((File)indexRoot);
                indexRoot.mkdirs();
                this.mySerializationManagerEx.reinitializeNameStorage();
                ID.reinitializeDiskStorage();
                PersistentIndicesConfiguration.saveConfiguration();
                FileUtil.delete((File)corruptionMarker);
            }
        }

        @Override
        protected void onThrowable(@NotNull Throwable t) {
            if (t == null) {
                FileIndexDataInitialization.$$$reportNull$$$0(1);
            }
            LOG.error(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected IndexConfiguration finish() {
            IndexConfiguration indexConfiguration;
            try {
                this.state.finalizeFileTypeMappingForIndices();
                String rebuildNotification = null;
                if (this.currentVersionCorrupted) {
                    rebuildNotification = "Index files on disk are corrupted. Indices will be rebuilt.";
                } else if (this.versionChanged.get()) {
                    rebuildNotification = "Index file format has changed for some indices. These indices will be rebuilt.";
                }
                if (rebuildNotification != null && !ApplicationManager.getApplication().isHeadlessEnvironment() && Registry.is((String)"ide.showIndexRebuildMessage")) {
                    NOTIFICATIONS.createNotification("Index Rebuild", rebuildNotification, NotificationType.INFORMATION, null).notify(null);
                }
                this.state.freeze();
                FileBasedIndexImpl.this.myState = this.state;
                for (ID<?, ?> indexId : this.state.getIndexIDs()) {
                    try {
                        RebuildStatus.clearIndexIfNecessary(indexId, (ThrowableRunnable<StorageException>)((ThrowableRunnable)() -> FileBasedIndexImpl.this.clearIndex(indexId)));
                    }
                    catch (StorageException e) {
                        FileBasedIndexImpl.this.requestRebuild(indexId);
                        LOG.error((Throwable)e);
                    }
                }
                FileBasedIndexImpl.this.registerIndexableSet(new AdditionalIndexableFileSet(), null);
                indexConfiguration = this.state;
            }
            catch (Throwable throwable) {
                ShutDownTracker.getInstance().registerShutdownTask(() -> FileBasedIndexImpl.this.performShutdown());
                FileBasedIndexImpl.saveRegisteredIndicesAndDropUnregisteredOnes(this.state.getIndexIDs());
                FileBasedIndexImpl.this.myFlushingFuture = FlushingDaemon.everyFiveSeconds(new Runnable(){
                    private int lastModCount;

                    @Override
                    public void run() {
                        FileIndexDataInitialization.this.mySerializationManagerEx.flushNameStorage();
                        int currentModCount = FileBasedIndexImpl.this.myLocalModCount.get();
                        if (this.lastModCount == currentModCount) {
                            FileBasedIndexImpl.this.flushAllIndices(this.lastModCount);
                        }
                        this.lastModCount = currentModCount;
                    }
                });
                FileBasedIndexImpl.this.myAllIndicesInitializedFuture = IndexInfrastructure.submitGenesisTask(() -> {
                    if (!FileBasedIndexImpl.this.myShutdownPerformed.get()) {
                        FileBasedIndexImpl.this.myChangedFilesCollector.ensureUpToDateAsync();
                    }
                    return null;
                });
                FileBasedIndexImpl.this.myInitialized = true;
                throw throwable;
            }
            ShutDownTracker.getInstance().registerShutdownTask(() -> FileBasedIndexImpl.this.performShutdown());
            FileBasedIndexImpl.saveRegisteredIndicesAndDropUnregisteredOnes(this.state.getIndexIDs());
            FileBasedIndexImpl.this.myFlushingFuture = FlushingDaemon.everyFiveSeconds(new /* invalid duplicate definition of identical inner class */);
            FileBasedIndexImpl.this.myAllIndicesInitializedFuture = IndexInfrastructure.submitGenesisTask(() -> {
                if (!FileBasedIndexImpl.this.myShutdownPerformed.get()) {
                    FileBasedIndexImpl.this.myChangedFilesCollector.ensureUpToDateAsync();
                }
                return null;
            });
            FileBasedIndexImpl.this.myInitialized = true;
            return indexConfiguration;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extensions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "t";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexImpl$FileIndexDataInitialization";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onThrowable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class DocumentUpdateTask
    extends UpdateTask<Document> {
        private final ID<?, ?> myIndexId;

        DocumentUpdateTask(ID<?, ?> indexId) {
            this.myIndexId = indexId;
        }

        @Override
        void doProcess(Document document, Project project) {
            FileBasedIndexImpl.this.indexUnsavedDocument(document, this.myIndexId, project, FileBasedIndexImpl.this.myFileDocumentManager.getFile(document));
        }
    }

    private class UnindexedFilesFinder
    implements CollectingContentIterator {
        private final List<VirtualFile> myFiles = new ArrayList<VirtualFile>();
        private final boolean myDoTraceForFilesToBeIndexed = LOG.isTraceEnabled();

        private UnindexedFilesFinder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public List<VirtualFile> getFiles() {
            List<VirtualFile> files2;
            List<VirtualFile> list2 = this.myFiles;
            synchronized (list2) {
                files2 = this.myFiles;
            }
            BitSet usedFileIds = new BitSet(files2.size());
            ArrayList<VirtualFile> localFileSystemFiles = new ArrayList<VirtualFile>(files2.size() / 2);
            ArrayList<VirtualFile> archiveFiles = new ArrayList<VirtualFile>(files2.size() / 2);
            for (VirtualFile file2 : files2) {
                int fileId = ((VirtualFileWithId)file2).getId();
                if (fileId > 0) {
                    if (usedFileIds.get(fileId)) continue;
                    usedFileIds.set(fileId);
                }
                if (file2.getFileSystem() instanceof LocalFileSystem) {
                    localFileSystemFiles.add(file2);
                    continue;
                }
                archiveFiles.add(file2);
            }
            localFileSystemFiles.addAll(archiveFiles);
            ArrayList<VirtualFile> arrayList = localFileSystemFiles;
            if (arrayList == null) {
                UnindexedFilesFinder.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        public boolean processFile(@NotNull VirtualFile file2) {
            if (file2 == null) {
                UnindexedFilesFinder.$$$reportNull$$$0(1);
            }
            return (Boolean)ReadAction.compute(() -> {
                if (file2 == null) {
                    UnindexedFilesFinder.$$$reportNull$$$0(2);
                }
                if (!file2.isValid()) {
                    return true;
                }
                if (file2 instanceof VirtualFileSystemEntry && ((VirtualFileSystemEntry)file2).isFileIndexed()) {
                    return true;
                }
                if (!(file2 instanceof VirtualFileWithId)) {
                    return true;
                }
                FileBasedIndexImpl.this.myFileTypeManager.freezeFileTypeTemporarilyIn(file2, () -> {
                    if (file2 == null) {
                        UnindexedFilesFinder.$$$reportNull$$$0(3);
                    }
                    boolean oldStuff = true;
                    if (file2.isDirectory() || !FileBasedIndexImpl.this.isTooLarge(file2)) {
                        List affectedIndexCandidates = FileBasedIndexImpl.this.getAffectedIndexCandidates(file2);
                        int size = affectedIndexCandidates.size();
                        for (int i = 0; i < size; ++i) {
                            ID indexId = (ID)affectedIndexCandidates.get(i);
                            try {
                                if (!FileBasedIndexImpl.this.needsFileContentLoading(indexId) || !FileBasedIndexImpl.this.shouldIndexFile(file2, indexId)) continue;
                                if (this.myDoTraceForFilesToBeIndexed) {
                                    LOG.trace("Scheduling indexing of " + file2 + " by request of index " + indexId);
                                }
                                List<VirtualFile> list2 = this.myFiles;
                                synchronized (list2) {
                                    this.myFiles.add(file2);
                                }
                                oldStuff = false;
                                break;
                            }
                            catch (RuntimeException e) {
                                Throwable cause = e.getCause();
                                if (cause instanceof IOException || cause instanceof StorageException) {
                                    LOG.info((Throwable)e);
                                    FileBasedIndexImpl.this.requestRebuild(indexId);
                                    continue;
                                }
                                throw e;
                            }
                        }
                    }
                    FileContentImpl fileContent = null;
                    int inputId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
                    for (ID indexId : FileBasedIndexImpl.this.myNotRequiringContentIndices) {
                        if (!FileBasedIndexImpl.this.shouldIndexFile(file2, indexId)) continue;
                        oldStuff = false;
                        if (fileContent == null) {
                            fileContent = new FileContentImpl(file2);
                        }
                        FileBasedIndexImpl.this.updateSingleIndex(indexId, file2, inputId, fileContent);
                    }
                    IndexingStamp.flushCache(inputId);
                    if (oldStuff && file2 instanceof VirtualFileSystemEntry) {
                        ((VirtualFileSystemEntry)file2).setFileIndexed(true);
                    }
                });
                ProgressManager.checkCanceled();
                return true;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/indexing/FileBasedIndexImpl$UnindexedFilesFinder";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiles";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexImpl$UnindexedFilesFinder";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "processFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$processFile$1";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$null$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class ChangedFilesCollector
    extends IndexedFilesListener {
        private final IntObjectMap<VirtualFile> myFilesToUpdate = ContainerUtil.createConcurrentIntObjectMap();
        private final VfsEventsMerger myVfsEventsMerger = new VfsEventsMerger();
        private final AtomicInteger myProcessedEventIndex = new AtomicInteger();
        private final Phaser myWorkersFinishedSync = new Phaser(){

            @Override
            protected boolean onAdvance(int phase, int registeredParties) {
                return false;
            }
        };
        private final ExecutorService myVfsEventsExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"FileBasedIndex Vfs Event Processor");
        private final AtomicInteger myScheduledVfsEventsWorkers = new AtomicInteger();

        private ChangedFilesCollector() {
        }

        @Override
        protected void buildIndicesForFileRecursively(@NotNull VirtualFile file2, boolean contentChange) {
            if (file2 == null) {
                ChangedFilesCollector.$$$reportNull$$$0(0);
            }
            FileBasedIndexImpl.cleanProcessedFlag(file2);
            if (!contentChange) {
                FileBasedIndexImpl.this.myUpdatingFiles.incrementAndGet();
            }
            super.buildIndicesForFileRecursively(file2, contentChange);
            if (!contentChange && FileBasedIndexImpl.this.myUpdatingFiles.decrementAndGet() == 0) {
                FileBasedIndexImpl.this.myFilesModCount.incrementAndGet();
            }
        }

        @Override
        protected void iterateIndexableFiles(@NotNull VirtualFile file2, @NotNull ContentIterator iterator) {
            if (file2 == null) {
                ChangedFilesCollector.$$$reportNull$$$0(1);
            }
            if (iterator == null) {
                ChangedFilesCollector.$$$reportNull$$$0(2);
            }
            for (IndexableFileSet set : FileBasedIndexImpl.this.myIndexableSets) {
                if (!set.isInSet(file2)) continue;
                set.iterateIndexableFilesIn(file2, iterator);
            }
        }

        @Override
        protected void buildIndicesForFile(@NotNull VirtualFile file2, boolean contentChange) {
            if (file2 == null) {
                ChangedFilesCollector.$$$reportNull$$$0(3);
            }
            int fileId = FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2);
            this.myVfsEventsMerger.recordFileEvent(fileId, file2, contentChange);
        }

        @Override
        protected void doInvalidateIndicesForFile(@NotNull VirtualFile file2, boolean contentChange) {
            if (file2 == null) {
                ChangedFilesCollector.$$$reportNull$$$0(4);
            }
            int fileId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
            this.myVfsEventsMerger.recordBeforeFileEvent(fileId, file2, contentChange);
        }

        void scheduleForUpdate(VirtualFile file2) {
            IndexableFileSet setForFile;
            if (!(file2 instanceof DeletedVirtualFileStub) && (setForFile = FileBasedIndexImpl.this.getIndexableSetForFile(file2)) == null) {
                return;
            }
            int fileId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
            VirtualFile previousVirtualFile = (VirtualFile)this.myFilesToUpdate.put(fileId, (Object)file2);
            if (previousVirtualFile instanceof DeletedVirtualFileStub && !previousVirtualFile.equals(file2)) {
                assert (((DeletedVirtualFileStub)previousVirtualFile).getOriginalFile().equals(file2));
                ((DeletedVirtualFileStub)previousVirtualFile).setResurrected(true);
                this.myFilesToUpdate.put(fileId, (Object)previousVirtualFile);
            }
        }

        private void removeScheduledFileFromUpdate(VirtualFile file2) {
            int fileId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
            VirtualFile previousVirtualFile = (VirtualFile)this.myFilesToUpdate.remove(fileId);
            if (previousVirtualFile instanceof DeletedVirtualFileStub) {
                assert (((DeletedVirtualFileStub)previousVirtualFile).getOriginalFile().equals(file2));
                ((DeletedVirtualFileStub)previousVirtualFile).setResurrected(false);
                this.myFilesToUpdate.put(fileId, (Object)previousVirtualFile);
            }
        }

        private void removeFileIdFromFilesScheduledForUpdate(int fileId) {
            this.myFilesToUpdate.remove(fileId);
        }

        Collection<VirtualFile> getAllFilesToUpdate() {
            this.ensureUpToDate();
            if (this.myFilesToUpdate.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<VirtualFile>(this.myFilesToUpdate.values());
        }

        @Override
        public void before(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                ChangedFilesCollector.$$$reportNull$$$0(5);
            }
            for (VFileEvent vFileEvent : events) {
                if (!this.memoryStorageCleaningNeeded(vFileEvent)) continue;
                FileBasedIndexImpl.this.cleanupMemoryStorage(false);
                break;
            }
            super.before(events);
        }

        private boolean memoryStorageCleaningNeeded(VFileEvent event) {
            Object requestor = event.getRequestor();
            return requestor instanceof FileDocumentManager || requestor instanceof PsiManager || requestor == LocalHistory.VFS_EVENT_REQUESTOR;
        }

        @Override
        public void after(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                ChangedFilesCollector.$$$reportNull$$$0(6);
            }
            super.after(events);
            if (FileBasedIndexImpl.this.myInitialized) {
                this.ensureUpToDateAsync();
            }
        }

        boolean isScheduledForUpdate(VirtualFile file2) {
            return this.myFilesToUpdate.containsKey(Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2)));
        }

        void ensureUpToDate() {
            if (!FileBasedIndexImpl.isUpToDateCheckEnabled()) {
                return;
            }
            FileBasedIndexImpl.this.waitUntilIndicesAreInitialized();
            if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                this.processFilesInReadAction();
            } else {
                this.processFilesInReadActionWithYieldingToWriteAction();
            }
        }

        void ensureUpToDateAsync() {
            if (this.myVfsEventsMerger.getApproximateChangesCount() >= 20 && this.myScheduledVfsEventsWorkers.compareAndSet(0, 1)) {
                this.myVfsEventsExecutor.submit(this::scheduledEventProcessingInReadActionWithYieldingToWriteAction);
                if (Registry.is((String)"try.starting.dumb.mode.where.many.files.changed")) {
                    Runnable startDumbMode = () -> {
                        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                            DumbServiceImpl dumbService = DumbServiceImpl.getInstance(project);
                            DumbModeTask task = FileBasedIndexProjectHandler.createChangedFilesIndexingTask(project);
                            if (task == null) continue;
                            dumbService.queueTask(task);
                        }
                    };
                    Application app = ApplicationManager.getApplication();
                    if (!app.isHeadlessEnvironment() && app.isDispatchThread() && !LaterInvocator.isInModalContext()) {
                        startDumbMode.run();
                    } else {
                        app.invokeLater(startDumbMode, ModalityState.NON_MODAL);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processFilesInReadAction() {
            assert (ApplicationManager.getApplication().isReadAccessAllowed());
            int publishedEventIndex = this.myVfsEventsMerger.getPublishedEventIndex();
            int processedEventIndex = this.myProcessedEventIndex.get();
            if (processedEventIndex == publishedEventIndex) {
                return;
            }
            this.myWorkersFinishedSync.register();
            int phase = this.myWorkersFinishedSync.getPhase();
            try {
                this.myVfsEventsMerger.processChanges(info -> (Boolean)ConcurrencyUtil.withLock((Lock)FileBasedIndexImpl.this.myWriteLock, () -> {
                    try {
                        ProgressManager.getInstance().executeNonCancelableSection(() -> {
                            int fileId = info.getFileId();
                            VirtualFile file2 = info.getFile();
                            if (info.isTransientStateChanged()) {
                                FileBasedIndexImpl.this.doTransientStateChangeForFile(fileId, file2);
                            }
                            if (info.isBeforeContentChanged()) {
                                FileBasedIndexImpl.this.doInvalidateIndicesForFile(fileId, file2, true);
                            }
                            if (info.isContentChanged()) {
                                FileBasedIndexImpl.this.scheduleFileForIndexing(fileId, file2, true);
                            }
                            if (info.isFileRemoved()) {
                                FileBasedIndexImpl.this.doInvalidateIndicesForFile(fileId, file2, false);
                            }
                            if (info.isFileAdded()) {
                                FileBasedIndexImpl.this.scheduleFileForIndexing(fileId, file2, false);
                            }
                        });
                    }
                    finally {
                        IndexingStamp.flushCache(info.getFileId());
                    }
                    return true;
                }));
            }
            finally {
                this.myWorkersFinishedSync.arriveAndDeregister();
            }
            this.myWorkersFinishedSync.awaitAdvance(phase);
            if (this.myVfsEventsMerger.getPublishedEventIndex() == publishedEventIndex) {
                this.myProcessedEventIndex.compareAndSet(processedEventIndex, publishedEventIndex);
            }
        }

        private void processFilesInReadActionWithYieldingToWriteAction() {
            while (this.myVfsEventsMerger.hasChanges()) {
                if (ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(this::processFilesInReadAction)) continue;
                ProgressIndicatorUtils.yieldToPendingWriteActions();
            }
        }

        private void scheduledEventProcessingInReadActionWithYieldingToWriteAction() {
            try {
                this.processFilesInReadActionWithYieldingToWriteAction();
            }
            finally {
                this.myScheduledVfsEventsWorkers.decrementAndGet();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterator";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buildIndicesForFileRecursively";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "iterateIndexableFiles";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buildIndicesForFile";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doInvalidateIndicesForFile";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "before";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "after";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class VirtualFileUpdateTask
    extends UpdateTask<VirtualFile> {
        private VirtualFileUpdateTask() {
        }

        @Override
        void doProcess(VirtualFile item, Project project) {
            FileBasedIndexImpl.this.processRefreshedFile(project, new com.intellij.ide.caches.FileContent(item));
        }
    }

    private static class PsiContent
    implements DocumentContent {
        private final Document myDocument;
        private final PsiFile myFile;

        private PsiContent(Document document, PsiFile file2) {
            this.myDocument = document;
            this.myFile = file2;
        }

        @Override
        @NotNull
        public CharSequence getText() {
            if (this.myFile.getViewProvider().getModificationStamp() != this.myDocument.getModificationStamp()) {
                FileASTNode node = this.myFile.getNode();
                assert (node != null);
                CharSequence charSequence = node.getChars();
                if (charSequence == null) {
                    PsiContent.$$$reportNull$$$0(0);
                }
                return charSequence;
            }
            CharSequence charSequence = this.myDocument.getImmutableCharSequence();
            if (charSequence == null) {
                PsiContent.$$$reportNull$$$0(1);
            }
            return charSequence;
        }

        @Override
        public long getModificationStamp() {
            return this.myFile.getViewProvider().getModificationStamp();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl$PsiContent", "getText"));
        }
    }

    private static class AuthenticContent
    implements DocumentContent {
        private final Document myDocument;

        private AuthenticContent(Document document) {
            this.myDocument = document;
        }

        @Override
        @NotNull
        public CharSequence getText() {
            CharSequence charSequence = this.myDocument.getImmutableCharSequence();
            if (charSequence == null) {
                AuthenticContent.$$$reportNull$$$0(0);
            }
            return charSequence;
        }

        @Override
        public long getModificationStamp() {
            return this.myDocument.getModificationStamp();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl$AuthenticContent", "getText"));
        }
    }

    private static interface DocumentContent {
        @NotNull
        public CharSequence getText();

        public long getModificationStamp();
    }

    public static final class ProjectIndexableFilesFilter
    extends IdFilter {
        private static final int SHIFT = 6;
        private static final int MASK = 63;
        private final long[] myBitMask;
        private final int myModificationCount;
        private final int myMinId;
        private final int myMaxId;

        private ProjectIndexableFilesFilter(@NotNull TIntArrayList set, int modificationCount) {
            if (set == null) {
                ProjectIndexableFilesFilter.$$$reportNull$$$0(0);
            }
            this.myModificationCount = modificationCount;
            int[] minMax = new int[2];
            if (!set.isEmpty()) {
                minMax[0] = minMax[1] = set.get(0);
            }
            set.forEach(value -> {
                if (value < 0) {
                    value = -value;
                }
                minMax[0] = Math.min(minMax[0], value);
                minMax[1] = Math.max(minMax[1], value);
                return true;
            });
            this.myMaxId = minMax[1];
            this.myMinId = minMax[0];
            this.myBitMask = new long[(this.myMaxId - this.myMinId >> 6) + 1];
            set.forEach(value -> {
                if (value < 0) {
                    value = -value;
                }
                int n = (value -= this.myMinId) >> 6;
                this.myBitMask[n] = this.myBitMask[n] | 1L << (value & 0x3F);
                return true;
            });
        }

        public boolean containsFileId(int id) {
            if (id < this.myMinId) {
                return false;
            }
            if (id > this.myMaxId) {
                return false;
            }
            return (this.myBitMask[(id -= this.myMinId) >> 6] & 1L << (id & 0x3F)) != 0L;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/util/indexing/FileBasedIndexImpl$ProjectIndexableFilesFilter", "<init>"));
        }
    }

    @FunctionalInterface
    public static interface IdValueProcessor<V> {
        public boolean process(int var1, V var2);
    }
}

