/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.slim;

import com.intellij.codeInsight.generation.CommenterDataHolder;
import com.intellij.codeInsight.generation.IndentedCommenter;
import com.intellij.codeInsight.generation.SelfManagingCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.slim.SlimLanguage;
import org.jetbrains.plugins.slim.psi.impl.SlimFilterImpl;

public final class SlimCommenter
implements IndentedCommenter,
SelfManagingCommenter<SlimCommenterData> {
    @NonNls
    private static final String LINE_COMMENT_PREFIX = "/ ";

    @NotNull
    public String getLineCommentPrefix() {
        if (LINE_COMMENT_PREFIX == null) {
            SlimCommenter.$$$reportNull$$$0(0);
        }
        return LINE_COMMENT_PREFIX;
    }

    @Nullable
    public String getBlockCommentPrefix() {
        return null;
    }

    @Nullable
    public String getBlockCommentSuffix() {
        return null;
    }

    public String getCommentedBlockCommentPrefix() {
        return null;
    }

    public String getCommentedBlockCommentSuffix() {
        return null;
    }

    public Boolean forceIndentedLineComment() {
        return true;
    }

    @NotNull
    public SlimCommenterData createLineCommentingState(int startLine, int endLine, @NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            SlimCommenter.$$$reportNull$$$0(1);
        }
        if (file == null) {
            SlimCommenter.$$$reportNull$$$0(2);
        }
        SlimCommenterData slimCommenterData = new SlimCommenterData(startLine, endLine, document, file);
        if (slimCommenterData == null) {
            SlimCommenter.$$$reportNull$$$0(3);
        }
        return slimCommenterData;
    }

    @Nullable
    public SlimCommenterData createBlockCommentingState(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            SlimCommenter.$$$reportNull$$$0(4);
        }
        if (file == null) {
            SlimCommenter.$$$reportNull$$$0(5);
        }
        return null;
    }

    public void commentLine(int line, int offset, @NotNull Document document, @NotNull SlimCommenterData data) {
        Language commenterLanguage;
        String commentPrefix;
        if (document == null) {
            SlimCommenter.$$$reportNull$$$0(6);
        }
        if (data == null) {
            SlimCommenter.$$$reportNull$$$0(7);
        }
        if ((commentPrefix = ((Commenter)LanguageCommenters.INSTANCE.forLanguage(commenterLanguage = data.getLanguages().get(line - data.getStartLineNumber()))).getLineCommentPrefix()) != null) {
            document.insertString(offset, (CharSequence)commentPrefix);
        }
    }

    public void uncommentLine(int line, int offset, @NotNull Document document, @NotNull SlimCommenterData data) {
        String commentPrefix;
        if (document == null) {
            SlimCommenter.$$$reportNull$$$0(8);
        }
        if (data == null) {
            SlimCommenter.$$$reportNull$$$0(9);
        }
        if ((commentPrefix = SlimCommenter.getLineCommentPrefixThatCommentsTheLine(line, offset, document, data)) != null) {
            document.deleteString(offset, offset + commentPrefix.length());
        }
    }

    public boolean isLineCommented(int line, int offset, @NotNull Document document, @NotNull SlimCommenterData data) {
        if (document == null) {
            SlimCommenter.$$$reportNull$$$0(10);
        }
        if (data == null) {
            SlimCommenter.$$$reportNull$$$0(11);
        }
        return SlimCommenter.getLineCommentPrefixThatCommentsTheLine(line, offset, document, data) != null;
    }

    @Nullable
    private static String getLineCommentPrefixThatCommentsTheLine(int line, int offset, @NotNull Document document, @NotNull SlimCommenterData data) {
        if (document == null) {
            SlimCommenter.$$$reportNull$$$0(12);
        }
        if (data == null) {
            SlimCommenter.$$$reportNull$$$0(13);
        }
        Language commenterLanguage = data.getLanguages().get(line - data.getStartLineNumber());
        String commentPrefix = ((Commenter)LanguageCommenters.INSTANCE.forLanguage(commenterLanguage)).getLineCommentPrefix();
        ArrayList<String> commentPrefixVariants = new ArrayList<String>();
        if (commentPrefix != null) {
            commentPrefixVariants.add(commentPrefix);
            if (commenterLanguage == SlimLanguage.INSTANCE) {
                commentPrefixVariants.add(commentPrefix.trim());
            }
        }
        for (String commentPrefixVariant : commentPrefixVariants) {
            if (!CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)offset, (CharSequence)commentPrefixVariant)) continue;
            return commentPrefixVariant;
        }
        return null;
    }

    @Nullable
    public String getCommentPrefix(int line, @NotNull Document document, @NotNull SlimCommenterData data) {
        if (document == null) {
            SlimCommenter.$$$reportNull$$$0(14);
        }
        if (data == null) {
            SlimCommenter.$$$reportNull$$$0(15);
        }
        return null;
    }

    @Nullable
    public TextRange getBlockCommentRange(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull SlimCommenterData data) {
        if (document == null) {
            SlimCommenter.$$$reportNull$$$0(16);
        }
        if (data == null) {
            SlimCommenter.$$$reportNull$$$0(17);
        }
        return null;
    }

    @Nullable
    public String getBlockCommentPrefix(int selectionStart, @NotNull Document document, @NotNull SlimCommenterData data) {
        if (document == null) {
            SlimCommenter.$$$reportNull$$$0(18);
        }
        if (data == null) {
            SlimCommenter.$$$reportNull$$$0(19);
        }
        return null;
    }

    @Nullable
    public String getBlockCommentSuffix(int selectionEnd, @NotNull Document document, @NotNull SlimCommenterData data) {
        if (document == null) {
            SlimCommenter.$$$reportNull$$$0(20);
        }
        if (data == null) {
            SlimCommenter.$$$reportNull$$$0(21);
        }
        return null;
    }

    public void uncommentBlockComment(int startOffset, int endOffset, Document document, SlimCommenterData data) {
    }

    @NotNull
    public TextRange insertBlockComment(int startOffset, int endOffset, Document document, SlimCommenterData data) {
        TextRange textRange = new TextRange(startOffset, endOffset);
        if (textRange == null) {
            SlimCommenter.$$$reportNull$$$0(22);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/slim/SlimCommenter";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineCommentPrefix";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/slim/SlimCommenter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineCommentingState";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "insertBlockComment";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createLineCommentingState";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createBlockCommentingState";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "commentLine";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "uncommentLine";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isLineCommented";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getLineCommentPrefixThatCommentsTheLine";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCommentPrefix";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getBlockCommentRange";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getBlockCommentPrefix";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getBlockCommentSuffix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class SlimCommenterData
    extends CommenterDataHolder {
        private final List<Language> myLanguages;
        private final int startLineNumber;

        SlimCommenterData(int startLine, int endLine, @NotNull Document document, @NotNull PsiFile file) {
            if (document == null) {
                SlimCommenterData.$$$reportNull$$$0(0);
            }
            if (file == null) {
                SlimCommenterData.$$$reportNull$$$0(1);
            }
            this.startLineNumber = startLine;
            this.myLanguages = new ArrayList<Language>();
            for (int i = startLine; i <= endLine; ++i) {
                int lineStartOffset = document.getLineStartOffset(i);
                PsiElement element = file.findElementAt(lineStartOffset);
                PsiElement filter = PsiTreeUtil.getParentOfType((PsiElement)element, SlimFilterImpl.class);
                if (filter != null) {
                    PsiElement filterContent = filter.getChildren()[1];
                    this.myLanguages.add(filterContent.getLanguage());
                    continue;
                }
                this.myLanguages.add(SlimLanguage.INSTANCE);
            }
        }

        public List<Language> getLanguages() {
            return this.myLanguages;
        }

        public int getStartLineNumber() {
            return this.startLineNumber;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/slim/SlimCommenter$SlimCommenterData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

