/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Driver;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Cassandra;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.jdbc.BaseExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.CassandraExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.CassandraIntermediateFacade;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateRdbmsProvider;

public class CassandraIntermediateProvider
extends JdbcIntermediateRdbmsProvider {
    public static final CassandraIntermediateProvider INSTANCE = new CassandraIntermediateProvider();
    static final Pattern CASSANDRA_CONNECTION_STRING_PATTERN = Pattern.compile("^jdbc:cassandra:.+$");
    static final String CASSANDRA_CONNECTION_STRING_EXAMPLE = "jdbc:cassandra://localhost:8123";

    @Override
    @NotNull
    protected String getConnectionStringExample() {
        return CASSANDRA_CONNECTION_STRING_EXAMPLE;
    }

    @Override
    protected Driver loadDriver(String connectionString) {
        return null;
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        return Cassandra.RDBMS;
    }

    @Override
    @NotNull
    public Pattern connectionStringPattern() {
        return CASSANDRA_CONNECTION_STRING_PATTERN;
    }

    @Override
    public byte specificity() {
        return 10;
    }

    @Override
    @NotNull
    protected CassandraIntermediateFacade instantiateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, int connectionsLimit, @NotNull Driver driver) {
        return new CassandraIntermediateFacade(connectionString, connectionProperties, driver, connectionsLimit, CassandraExceptionRecognizer.INSTANCE);
    }

    @Override
    @NotNull
    public BaseExceptionRecognizer getExceptionRecognizer() {
        return CassandraExceptionRecognizer.INSTANCE;
    }
}

