/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.javascript.buildTools.base.JsbtInvalidSetting;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskListFetchFail;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsbtTaskFetchException
extends Exception {
    private final VirtualFile myBuildfile;
    private final List<JsbtInvalidSetting> myInvalidSettings;
    private final JsbtTaskListFetchFail myFetchFail;

    private JsbtTaskFetchException(@NotNull VirtualFile buildfile, @Nullable String message, @NotNull List<JsbtInvalidSetting> invalidSettings, @Nullable JsbtTaskListFetchFail fetchFail) {
        if (buildfile == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(0);
        }
        if (invalidSettings == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(1);
        }
        super(message);
        this.myBuildfile = buildfile;
        this.myInvalidSettings = ImmutableList.copyOf(invalidSettings);
        this.myFetchFail = fetchFail;
    }

    @NotNull
    public VirtualFile getBuildfile() {
        VirtualFile virtualFile = this.myBuildfile;
        if (virtualFile == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    public boolean hasInvalidSettings() {
        return !this.myInvalidSettings.isEmpty();
    }

    @Nullable
    public JsbtTaskListFetchFail getFetchFail() {
        return this.myFetchFail;
    }

    @NotNull
    public String getDescription() {
        if (!this.myInvalidSettings.isEmpty()) {
            StringBuilder buf = new StringBuilder("Cannot fetch task list, because of invalid parameters:");
            for (JsbtInvalidSetting setting : this.myInvalidSettings) {
                buf.append("\n");
                buf.append(setting.getName());
                if (setting.getValue() != null) {
                    buf.append(":").append(setting.getValue());
                }
                buf.append(" (").append(setting.getErrorMessage()).append(")");
            }
            String string = buf.toString();
            if (string == null) {
                JsbtTaskFetchException.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (this.myFetchFail != null) {
            String string = this.myFetchFail.getDescription();
            if (string == null) {
                JsbtTaskFetchException.$$$reportNull$$$0(4);
            }
            return string;
        }
        throw new AssertionError((Object)"Unreachable assertion");
    }

    @NotNull
    public static JsbtTaskFetchException newInvalidSettings(@NotNull VirtualFile buildfile, @NotNull List<JsbtInvalidSetting> invalidSettings) {
        if (buildfile == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(5);
        }
        if (invalidSettings == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(6);
        }
        JsbtTaskFetchException jsbtTaskFetchException = new JsbtTaskFetchException(buildfile, null, invalidSettings, null);
        if (jsbtTaskFetchException == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(7);
        }
        return jsbtTaskFetchException;
    }

    @NotNull
    public static JsbtTaskFetchException newBuildfileSyntaxError(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(8);
        }
        JsbtTaskFetchException jsbtTaskFetchException = new JsbtTaskFetchException(buildfile, null, (List<JsbtInvalidSetting>)ImmutableList.of(), null);
        if (jsbtTaskFetchException == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(9);
        }
        return jsbtTaskFetchException;
    }

    @NotNull
    public static JsbtTaskFetchException newGenericException(@NotNull VirtualFile buildfile, @NotNull String message) {
        if (buildfile == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(10);
        }
        if (message == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(11);
        }
        JsbtTaskFetchException jsbtTaskFetchException = new JsbtTaskFetchException(buildfile, message, (List<JsbtInvalidSetting>)ImmutableList.of(), null);
        if (jsbtTaskFetchException == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(12);
        }
        return jsbtTaskFetchException;
    }

    @NotNull
    public static JsbtTaskFetchException newFetchFail(@NotNull VirtualFile buildfile, @NotNull JsbtService service, @NotNull String buildToolName, @Nullable Icon icon, @NotNull String message, @NotNull GeneralCommandLine commandLine, @Nullable String commandLineFoldedText, @Nullable ExecutionException executionException, @Nullable ProcessHandler processHandler, @Nullable ProcessOutput processOutput) {
        if (buildfile == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(13);
        }
        if (service == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(14);
        }
        if (buildToolName == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(15);
        }
        if (message == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(16);
        }
        if (commandLine == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(17);
        }
        JsbtTaskFetchException jsbtTaskFetchException = new JsbtTaskFetchException(buildfile, null, (List<JsbtInvalidSetting>)ImmutableList.of(), new JsbtTaskListFetchFail(buildfile, service, buildToolName, icon, message, commandLine, commandLineFoldedText, executionException, processHandler, processOutput));
        if (jsbtTaskFetchException == null) {
            JsbtTaskFetchException.$$$reportNull$$$0(18);
        }
        return jsbtTaskFetchException;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfile";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidSettings";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskFetchException";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildToolName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskFetchException";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildfile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "newInvalidSettings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuildfileSyntaxError";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "newGenericException";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "newFetchFail";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 18: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "newInvalidSettings";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "newBuildfileSyntaxError";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "newGenericException";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "newFetchFail";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

