/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs.importer;

import com.google.gson.JsonElement;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.linter.jscs.config.JscsOption;
import com.intellij.lang.javascript.linter.jscs.importer.AppliedRule;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;

public abstract class PairImportRule
implements AppliedRule {
    private String myTextValue;
    private final StringBuilder myResultDescription = new StringBuilder();
    private boolean myApplied;

    protected PairImportRule() {
    }

    protected void append(String text) {
        if (this.myResultDescription.length() > 0) {
            this.myResultDescription.append("<br/>");
        }
        this.myResultDescription.append(text);
    }

    public boolean apply(JsonElement element1, JsonElement element2, CommonCodeStyleSettings settings, JSCodeStyleSettings jsCodeStyleSettings) {
        this.myTextValue = element1.toString() + " and " + element2.toString();
        this.myApplied = this.applyImpl(element1, element2, settings, jsCodeStyleSettings);
        return this.myApplied;
    }

    public abstract JscsOption getPairRule();

    protected abstract boolean applyImpl(JsonElement var1, JsonElement var2, CommonCodeStyleSettings var3, JSCodeStyleSettings var4);

    @Override
    public String getTextValue() {
        return this.myTextValue;
    }

    @Override
    public String getResultDescription() {
        return this.myResultDescription.toString();
    }

    @Override
    public boolean isApplied() {
        return this.myApplied;
    }
}

