/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.i18n.I18nProvider;
import org.jetbrains.plugins.ruby.i18n.indexes.I18nTranslationKeysIndex;
import org.jetbrains.plugins.ruby.i18n.locales.I18nYAMLAdapter;
import org.jetbrains.plugins.ruby.i18n.locales.LocaleEntry;
import org.jetbrains.plugins.ruby.i18n.locales.YAMLLocaleEntry;
import org.jetbrains.plugins.ruby.i18n.locales.YamlKeyFakePsiElement;
import org.jetbrains.plugins.ruby.i18n.refactoring.safeDelete.RubyI18nSafeDeleteSupport;
import org.jetbrains.plugins.ruby.i18n.refactoring.safeDelete.YamlI18nSafeDeleteSupport;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;

public class YamlI18nProvider
extends I18nProvider {
    @NotNull
    public LocaleEntry createLocaleEntry(@NotNull PsiFile psiFile, @NotNull String localesRootPath) {
        if (psiFile == null) {
            YamlI18nProvider.$$$reportNull$$$0(0);
        }
        if (localesRootPath == null) {
            YamlI18nProvider.$$$reportNull$$$0(1);
        }
        if (!(psiFile instanceof YAMLFile)) {
            throw new IllegalArgumentException();
        }
        YAMLLocaleEntry yAMLLocaleEntry = new YAMLLocaleEntry((YAMLFile)psiFile, localesRootPath);
        if (yAMLLocaleEntry == null) {
            YamlI18nProvider.$$$reportNull$$$0(2);
        }
        return yAMLLocaleEntry;
    }

    public List<?> getDictionaryDependencies(@NotNull Module module) {
        FileBasedIndexImpl fileBasedIndex;
        if (module == null) {
            YamlI18nProvider.$$$reportNull$$$0(3);
        }
        if ((fileBasedIndex = (FileBasedIndexImpl)ObjectUtils.tryCast((Object)FileBasedIndex.getInstance(), FileBasedIndexImpl.class)) != null) {
            ModificationTracker tracker = () -> {
                if (module == null) {
                    YamlI18nProvider.$$$reportNull$$$0(7);
                }
                return fileBasedIndex.getIndexModificationStamp(I18nTranslationKeysIndex.KEY, module.getProject());
            };
            return Collections.singletonList(tracker);
        }
        return super.getDictionaryDependencies(module);
    }

    public boolean isTranslationElement(@NotNull PsiElement element) {
        if (element == null) {
            YamlI18nProvider.$$$reportNull$$$0(4);
        }
        return I18nYAMLAdapter.isTranslationElement(element);
    }

    @Nullable
    public String getTranslation(@Nullable PsiElement element) {
        return I18nYAMLAdapter.getTranslation(element);
    }

    @Nullable
    public String getKeyText(@Nullable PsiElement element) {
        if (element instanceof PsiNamedElement) {
            return ((PsiNamedElement)element).getName();
        }
        return null;
    }

    @Nullable
    public PsiElement getKeyElement(@Nullable PsiElement element) {
        return element;
    }

    @Nullable
    public String getFullKey(@Nullable PsiElement element) {
        return I18nYAMLAdapter.getI18nKeyPath(element);
    }

    public boolean canBeTranslationReferenceTarget(@NotNull PsiElement element) {
        if (element == null) {
            YamlI18nProvider.$$$reportNull$$$0(5);
        }
        return element instanceof YAMLKeyValue || element instanceof YamlKeyFakePsiElement;
    }

    @NotNull
    public RubyI18nSafeDeleteSupport createSafeDeleteSupport() {
        RubyI18nSafeDeleteSupport rubyI18nSafeDeleteSupport = YamlI18nSafeDeleteSupport.INSTANCE;
        if (rubyI18nSafeDeleteSupport == null) {
            YamlI18nProvider.$$$reportNull$$$0(6);
        }
        return rubyI18nSafeDeleteSupport;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localesRootPath";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/YamlI18nProvider";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/YamlI18nProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocaleEntry";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createSafeDeleteSupport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLocaleEntry";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDictionaryDependencies";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isTranslationElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canBeTranslationReferenceTarget";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDictionaryDependencies$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

