/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.awt;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelativePoint {
    private Component myComponent;
    private Point myPointOnComponent;
    private Component myOriginalComponent;
    private Point myOriginalPoint;

    public RelativePoint(@NotNull MouseEvent event) {
        if (event == null) {
            RelativePoint.$$$reportNull$$$0(0);
        }
        this.init(event.getComponent(), event.getPoint());
    }

    public RelativePoint(@NotNull Component aComponent, Point aPointOnComponent) {
        if (aComponent == null) {
            RelativePoint.$$$reportNull$$$0(1);
        }
        this.init(aComponent, aPointOnComponent);
    }

    public RelativePoint(@NotNull Point screenPoint) {
        if (screenPoint == null) {
            RelativePoint.$$$reportNull$$$0(2);
        }
        Point p = new Point(screenPoint.x, screenPoint.y);
        Window[] windows = Window.getWindows();
        Window targetWindow = null;
        for (Window each : windows) {
            if (!each.isActive()) continue;
            targetWindow = each;
            break;
        }
        if (targetWindow == null) {
            targetWindow = JOptionPane.getRootFrame();
        }
        SwingUtilities.convertPointFromScreen(p, targetWindow);
        this.init(targetWindow, p);
    }

    private void init(@NotNull Component aComponent, Point aPointOnComponent) {
        if (aComponent == null) {
            RelativePoint.$$$reportNull$$$0(3);
        }
        if (aComponent.isShowing()) {
            this.myComponent = SwingUtilities.getRootPane(aComponent);
            this.myPointOnComponent = SwingUtilities.convertPoint(aComponent, aPointOnComponent, this.myComponent);
        } else {
            this.myComponent = aComponent;
            this.myPointOnComponent = aPointOnComponent;
        }
        this.myOriginalComponent = aComponent;
        this.myOriginalPoint = aPointOnComponent;
    }

    public Component getComponent() {
        return this.myComponent;
    }

    public Point getPoint() {
        return this.myPointOnComponent;
    }

    public Point getPoint(@Nullable Component aTargetComponent) {
        boolean window = aTargetComponent instanceof Window;
        if (aTargetComponent == null || !window && (aTargetComponent.getParent() == null || SwingUtilities.getWindowAncestor(aTargetComponent) == null)) {
            return new Point();
        }
        return SwingUtilities.convertPoint(this.getComponent(), this.getPoint(), aTargetComponent);
    }

    @NotNull
    public RelativePoint getPointOn(@NotNull Component aTargetComponent) {
        if (aTargetComponent == null) {
            RelativePoint.$$$reportNull$$$0(4);
        }
        Point point = this.getPoint(aTargetComponent);
        RelativePoint relativePoint = new RelativePoint(aTargetComponent, point);
        if (relativePoint == null) {
            RelativePoint.$$$reportNull$$$0(5);
        }
        return relativePoint;
    }

    @NotNull
    public Point getScreenPoint() {
        Point point = (Point)this.getPoint().clone();
        SwingUtilities.convertPointToScreen(point, this.getComponent());
        Point point2 = point;
        if (point2 == null) {
            RelativePoint.$$$reportNull$$$0(6);
        }
        return point2;
    }

    @NotNull
    public MouseEvent toMouseEvent() {
        MouseEvent mouseEvent = new MouseEvent(this.myComponent, 0, 0L, 0, this.myPointOnComponent.x, this.myPointOnComponent.y, 1, false);
        if (mouseEvent == null) {
            RelativePoint.$$$reportNull$$$0(7);
        }
        return mouseEvent;
    }

    @NotNull
    public String toString() {
        String string = this.getPoint() + " on " + this.getComponent();
        if (string == null) {
            RelativePoint.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static RelativePoint getCenterOf(@NotNull JComponent component) {
        if (component == null) {
            RelativePoint.$$$reportNull$$$0(9);
        }
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height / 2);
        RelativePoint relativePoint = new RelativePoint(component, point);
        if (relativePoint == null) {
            RelativePoint.$$$reportNull$$$0(10);
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint getSouthEastOf(@NotNull JComponent component) {
        if (component == null) {
            RelativePoint.$$$reportNull$$$0(11);
        }
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x + visibleRect.width, visibleRect.y + visibleRect.height);
        RelativePoint relativePoint = new RelativePoint(component, point);
        if (relativePoint == null) {
            RelativePoint.$$$reportNull$$$0(12);
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint getSouthWestOf(@NotNull JComponent component) {
        if (component == null) {
            RelativePoint.$$$reportNull$$$0(13);
        }
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x, visibleRect.y + visibleRect.height);
        RelativePoint relativePoint = new RelativePoint(component, point);
        if (relativePoint == null) {
            RelativePoint.$$$reportNull$$$0(14);
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint getSouthOf(@NotNull JComponent component) {
        if (component == null) {
            RelativePoint.$$$reportNull$$$0(15);
        }
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height);
        RelativePoint relativePoint = new RelativePoint(component, point);
        if (relativePoint == null) {
            RelativePoint.$$$reportNull$$$0(16);
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint getNorthWestOf(@NotNull JComponent component) {
        if (component == null) {
            RelativePoint.$$$reportNull$$$0(17);
        }
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x, visibleRect.y);
        RelativePoint relativePoint = new RelativePoint(component, point);
        if (relativePoint == null) {
            RelativePoint.$$$reportNull$$$0(18);
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint getNorthEastOf(@NotNull JComponent component) {
        if (component == null) {
            RelativePoint.$$$reportNull$$$0(19);
        }
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x + visibleRect.width, visibleRect.y);
        RelativePoint relativePoint = new RelativePoint(component, point);
        if (relativePoint == null) {
            RelativePoint.$$$reportNull$$$0(20);
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint fromScreen(Point screenPoint) {
        Frame root = JOptionPane.getRootFrame();
        SwingUtilities.convertPointFromScreen(screenPoint, root);
        RelativePoint relativePoint = new RelativePoint(root, screenPoint);
        if (relativePoint == null) {
            RelativePoint.$$$reportNull$$$0(21);
        }
        return relativePoint;
    }

    public Component getOriginalComponent() {
        return this.myOriginalComponent;
    }

    public Point getOriginalPoint() {
        return this.myOriginalPoint;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenPoint";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aTargetComponent";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/awt/RelativePoint";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/awt/RelativePoint";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPointOn";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getScreenPoint";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toMouseEvent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCenterOf";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSouthEastOf";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSouthWestOf";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSouthOf";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getNorthWestOf";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNorthEastOf";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "fromScreen";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPointOn";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCenterOf";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSouthEastOf";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSouthWestOf";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSouthOf";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getNorthWestOf";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getNorthEastOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

