/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action;

import java.sql.Connection;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.util.ICommand;

public class ShowNativeSQLCommand
implements ICommand {
    private final ISQLPanelAPI _panel;

    public ShowNativeSQLCommand(ISQLPanelAPI panel) {
        if (panel == null) {
            throw new IllegalArgumentException("ISQLPanelAPI == null");
        }
        this._panel = panel;
    }

    @Override
    public void execute() {
        ISession session = this._panel.getSession();
        Connection conn = session.getSQLConnection().getConnection();
        try {
            String sql = conn.nativeSQL(this._panel.getSQLScriptToBeExecuted());
            if (sql.length() > 0) {
                this._panel.appendSQLScript("\n" + sql, true);
            }
        }
        catch (SQLException ex) {
            session.showErrorMessage(ex);
        }
    }
}

