/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nimrod;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalCheckBoxUI;
import javax.swing.plaf.metal.MetalIconFactory;
import net.sf.nimrod.NimRODIconFactory;
import net.sf.nimrod.NimRODLookAndFeel;
import net.sf.nimrod.NimRODUtils;

public class NimRODCheckBoxUI
extends MetalCheckBoxUI {
    boolean oldOpaque;

    public static ComponentUI createUI(JComponent c) {
        return new NimRODCheckBoxUI();
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        this.oldOpaque = b.isOpaque();
        b.setOpaque(false);
        this.icon = NimRODIconFactory.getCheckBoxIcon();
    }

    @Override
    public void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        b.setOpaque(this.oldOpaque);
        this.icon = MetalIconFactory.getCheckBoxIcon();
    }

    @Override
    public synchronized void paint(Graphics g, JComponent c) {
        if (this.oldOpaque) {
            Dimension size = c.getSize();
            Container papi = c.getParent();
            if (papi != null) {
                if (papi.getClass() == CellRendererPane.class) {
                    g.setColor(c.getBackground());
                    g.fillRect(0, 0, size.width, size.height);
                } else if (papi instanceof JTable) {
                    g.setColor(((JTable)papi).getSelectionBackground());
                    g.fillRect(0, 0, size.width, size.height);
                } else if (papi instanceof JList) {
                    g.setColor(((JList)papi).getSelectionBackground());
                    g.fillRect(0, 0, size.width, size.height);
                }
            }
        }
        super.paint(g, c);
    }

    @Override
    protected void paintFocus(Graphics g, Rectangle t, Dimension d) {
        NimRODUtils.paintFocus(g, 1, 1, d.width - 2, d.height - 2, 8, 8, NimRODLookAndFeel.getFocusColor());
    }
}

