/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.journal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.journal.TEIDOMParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

public class GrobidRESTParser {
    private static final Logger LOG = LoggerFactory.getLogger(GrobidRESTParser.class);
    private static final String GROBID_REST_HOST = "http://localhost:8080";
    private Boolean legacyMode = null;
    private static final String GROBID_ISALIVE_PATH = "/api/isalive";
    private static final String GROBID_PROCESSHEADER_PATH = "/api/processHeaderDocument";
    private static final String GROBID_LEGACY_ISALIVE_PATH = "/grobid";
    private static final String GROBID_LEGACY_PROCESSHEADER_PATH = "/processHeaderDocument";
    private String restHostUrlStr;

    public GrobidRESTParser() {
        String restHostUrlStr = null;
        try {
            restHostUrlStr = GrobidRESTParser.readRestUrl();
        }
        catch (IOException e) {
            LOG.warn("can't read rest url", (Throwable)e);
        }
        this.restHostUrlStr = restHostUrlStr == null || restHostUrlStr.equals("") ? GROBID_REST_HOST : restHostUrlStr;
    }

    public void parse(String filePath, ContentHandler handler, Metadata metadata, ParseContext context) throws FileNotFoundException {
        File pdfFile = new File(filePath);
        ContentDisposition cd = new ContentDisposition("form-data; name=\"input\"; filename=\"" + pdfFile.getName() + "\"");
        Attachment att = new Attachment("input", (InputStream)new FileInputStream(pdfFile), cd);
        MultipartBody body = new MultipartBody(att);
        try {
            this.checkMode();
            Response response = WebClient.create((String)(this.restHostUrlStr + (this.legacyMode != false ? GROBID_LEGACY_PROCESSHEADER_PATH : GROBID_PROCESSHEADER_PATH))).accept(new String[]{"application/xml"}).type("multipart/form-data").post((Object)body);
            String resp = (String)response.readEntity(String.class);
            Metadata teiMet = new TEIDOMParser().parse(resp, context);
            for (String key : teiMet.names()) {
                metadata.add("grobid:header_" + key, teiMet.get(key));
            }
        }
        catch (Exception e) {
            LOG.warn("Couldn't read response", (Throwable)e);
        }
    }

    private static String readRestUrl() throws IOException {
        Properties grobidProperties = new Properties();
        grobidProperties.load(GrobidRESTParser.class.getResourceAsStream("GrobidExtractor.properties"));
        return grobidProperties.getProperty("grobid.server.url");
    }

    private void checkMode() throws TikaException {
        if (this.legacyMode != null) {
            return;
        }
        Response response = WebClient.create((String)(this.restHostUrlStr + GROBID_ISALIVE_PATH)).head();
        if (response.getStatus() == 200) {
            this.legacyMode = false;
            return;
        }
        response = WebClient.create((String)(this.restHostUrlStr + GROBID_LEGACY_ISALIVE_PATH)).head();
        if (response.getStatus() == 200) {
            this.legacyMode = true;
            return;
        }
        throw new TikaException("Cannot connect to Grobid Service");
    }

    protected static boolean canRun() {
        Response response = null;
        try {
            response = WebClient.create((String)(GrobidRESTParser.readRestUrl() + GROBID_ISALIVE_PATH)).get();
            String resp = (String)response.readEntity(String.class);
            return resp != null && !resp.equals("") && resp.startsWith("true");
        }
        catch (Exception e) {
            return false;
        }
    }
}

