/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.cloud.autoscaling.TriggerAction;
import org.apache.solr.cloud.autoscaling.TriggerUtils;
import org.apache.solr.cloud.autoscaling.TriggerValidationException;
import org.apache.solr.core.SolrResourceLoader;

public abstract class TriggerActionBase
implements TriggerAction {
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected SolrResourceLoader loader;
    protected SolrCloudManager cloudManager;
    protected final Set<String> validProperties = new HashSet<String>();
    protected final Set<String> requiredProperties = new HashSet<String>();

    protected TriggerActionBase() {
        TriggerUtils.validProperties(this.validProperties, "name", "class");
    }

    @Override
    public String getName() {
        String name = (String)this.properties.get("name");
        if (name != null) {
            return name;
        }
        return this.getClass().getSimpleName();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void configure(SolrResourceLoader loader, SolrCloudManager cloudManager, Map<String, Object> properties) throws TriggerValidationException {
        this.loader = loader;
        this.cloudManager = cloudManager;
        if (properties != null) {
            this.properties.putAll(properties);
        }
        HashMap<String, String> results = new HashMap<String, String>();
        TriggerUtils.checkProperties(this.properties, results, this.requiredProperties, this.validProperties);
        if (!results.isEmpty()) {
            throw new TriggerValidationException(this.getName(), results);
        }
    }

    @Override
    public void init() throws Exception {
    }
}

