/*
 * Decompiled with CFR 0.152.
 */
package javax.media.format;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.VideoFormat;

public class IndexedColorFormat
extends VideoFormat {
    protected int lineStride = -1;
    protected byte[] redValues = null;
    protected byte[] greenValues = null;
    protected byte[] blueValues = null;
    protected int mapSize = -1;
    private static String ENCODING = "irgb";

    public IndexedColorFormat(Dimension size, int maxDataLength, Class dataType, float frameRate, int lineStride, int mapSize, byte[] red, byte[] green, byte[] blue) {
        super(ENCODING, size, maxDataLength, dataType, frameRate);
        this.lineStride = lineStride;
        this.redValues = red;
        this.greenValues = green;
        this.blueValues = blue;
        this.mapSize = mapSize;
    }

    public int getMapSize() {
        return this.mapSize;
    }

    public byte[] getRedValues() {
        return this.redValues;
    }

    public byte[] getGreenValues() {
        return this.greenValues;
    }

    public byte[] getBlueValues() {
        return this.blueValues;
    }

    public int getLineStride() {
        return this.lineStride;
    }

    public Object clone() {
        IndexedColorFormat f2 = new IndexedColorFormat(this.size, this.maxDataLength, this.dataType, this.frameRate, this.lineStride, this.mapSize, this.redValues, this.greenValues, this.blueValues);
        f2.copy(this);
        return f2;
    }

    protected void copy(Format f2) {
        super.copy(f2);
        if (f2 instanceof IndexedColorFormat) {
            IndexedColorFormat other = (IndexedColorFormat)f2;
            this.mapSize = other.mapSize;
            this.redValues = other.redValues;
            this.greenValues = other.greenValues;
            this.blueValues = other.blueValues;
            this.lineStride = other.lineStride;
        }
    }

    public boolean equals(Object format) {
        if (format instanceof IndexedColorFormat) {
            IndexedColorFormat other = (IndexedColorFormat)format;
            return super.equals(format) && this.mapSize == other.mapSize && this.redValues == other.redValues && this.greenValues == other.greenValues && this.blueValues == other.blueValues && this.lineStride == other.lineStride;
        }
        return false;
    }

    public boolean matches(Format format) {
        if (!super.matches(format)) {
            return false;
        }
        if (!(format instanceof IndexedColorFormat)) {
            return true;
        }
        IndexedColorFormat other = (IndexedColorFormat)format;
        return !(this.mapSize != -1 && other.mapSize != -1 && this.mapSize != other.mapSize || this.redValues != null && other.redValues != null && !this.redValues.equals(other.redValues) || this.greenValues != null && other.greenValues != null && !this.greenValues.equals(other.greenValues) || this.blueValues != null && other.blueValues != null && !this.blueValues.equals(other.blueValues) || this.lineStride != -1 && other.lineStride != -1 && this.lineStride != other.lineStride);
    }

    public Format intersects(Format format) {
        Format fmt = super.intersects(format);
        if (fmt == null) {
            return null;
        }
        if (!(format instanceof IndexedColorFormat)) {
            return fmt;
        }
        IndexedColorFormat other = (IndexedColorFormat)format;
        IndexedColorFormat res = (IndexedColorFormat)fmt;
        res.mapSize = this.mapSize != -1 ? this.mapSize : other.mapSize;
        res.redValues = this.redValues != null ? this.redValues : other.redValues;
        res.greenValues = this.greenValues != null ? this.greenValues : other.greenValues;
        res.blueValues = this.blueValues != null ? this.blueValues : other.blueValues;
        res.lineStride = this.lineStride != -1 ? this.lineStride : other.lineStride;
        return res;
    }

    public Format relax() {
        IndexedColorFormat fmt = (IndexedColorFormat)super.relax();
        if (fmt == null) {
            return null;
        }
        fmt.lineStride = -1;
        return fmt;
    }
}

