/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.Laziness;
import com.jidesoft.dialog.PageEvent;
import com.jidesoft.dialog.PageListener;
import java.awt.Graphics;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;

public abstract class AbstractPage
extends JPanel
implements Laziness {
    private static final long serialVersionUID = 3566789990192642869L;
    public static int INVOKE_ON_ALL = -1;
    public static int INVOKE_ON_NONE = 0;
    public static int INVOKE_ON_PAINT = 1;
    public static int INVOKE_ON_REPAINT = 2;
    public static int INVOKE_ON_UPDATE = 4;
    public static int INVOKE_ON_VALIDATE = 8;
    private boolean _allowClosing = true;
    private int _invokeCondition = INVOKE_ON_PAINT | INVOKE_ON_REPAINT | INVOKE_ON_UPDATE;
    protected transient PageEvent _pageEvent = null;
    private boolean _lazyConstructorCalled = false;
    private static final Logger LOGGER_EVENT = Logger.getLogger(PageEvent.class.getName());

    protected AbstractPage() {
    }

    public int getInvokeCondition() {
        return this._invokeCondition;
    }

    public void setInvokeCondition(int invokeCondition) {
        this._invokeCondition = invokeCondition;
    }

    public void invalidate() {
        if ((this.getInvokeCondition() & INVOKE_ON_VALIDATE) != 0) {
            this.initialize();
        }
        super.invalidate();
    }

    public void revalidate() {
        if ((this.getInvokeCondition() & INVOKE_ON_VALIDATE) != 0) {
            this.initialize();
        }
        super.revalidate();
    }

    public void paint(Graphics g2) {
        if ((this.getInvokeCondition() & INVOKE_ON_PAINT) != 0) {
            this.initialize();
        }
        super.paint(g2);
    }

    public void paintAll(Graphics g2) {
        if ((this.getInvokeCondition() & INVOKE_ON_PAINT) != 0) {
            this.initialize();
        }
        super.paintAll(g2);
    }

    public void paintComponents(Graphics g2) {
        if ((this.getInvokeCondition() & INVOKE_ON_PAINT) != 0) {
            this.initialize();
        }
        super.paintComponents(g2);
    }

    public void repaint() {
        if ((this.getInvokeCondition() & INVOKE_ON_REPAINT) != 0) {
            this.initialize();
        }
        super.repaint();
    }

    public void repaint(long l) {
        if ((this.getInvokeCondition() & INVOKE_ON_REPAINT) != 0) {
            this.initialize();
        }
        super.repaint(l);
    }

    public void repaint(int i1, int i2, int i3, int i4) {
        if ((this.getInvokeCondition() & INVOKE_ON_REPAINT) != 0) {
            this.initialize();
        }
        super.repaint(i1, i2, i3, i4);
    }

    public void repaint(long l, int i1, int i2, int i3, int i4) {
        if ((this.getInvokeCondition() & INVOKE_ON_REPAINT) != 0) {
            this.initialize();
        }
        super.repaint(l, i1, i2, i3, i4);
    }

    public void update(Graphics g2) {
        if ((this.getInvokeCondition() & INVOKE_ON_UPDATE) != 0) {
            this.initialize();
        }
        super.update(g2);
    }

    public final synchronized void initialize() {
        if (!this._lazyConstructorCalled) {
            this._lazyConstructorCalled = true;
            this.lazyInitialize();
            this.validate();
        }
    }

    public synchronized void reset() {
        this._lazyConstructorCalled = false;
        this.removeAll();
    }

    public void addPageListener(PageListener l) {
        this.listenerList.add(PageListener.class, l);
    }

    public void removePageListener(PageListener l) {
        this.listenerList.remove(PageListener.class, l);
    }

    public PageListener[] getPageListeners() {
        return (PageListener[])this.listenerList.getListeners(PageListener.class);
    }

    public void firePageEvent(int id) {
        this.firePageEvent(this, id);
    }

    public void firePageEvent(Object source, int id) {
        this.initialize();
        if (source == null) {
            source = this;
        }
        if (LOGGER_EVENT.isLoggable(Level.FINE)) {
            switch (id) {
                case 3199: {
                    LOGGER_EVENT.fine("Page \"" + this + " is opened, source is " + source.getClass().getName());
                    break;
                }
                case 3200: {
                    LOGGER_EVENT.fine("Page \"" + this + " is closing, source is " + source.getClass().getName());
                    break;
                }
                case 3201: {
                    LOGGER_EVENT.fine("Page \"" + this + " is closed, source is " + source.getClass().getName());
                    break;
                }
            }
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PageListener.class) continue;
            this._pageEvent = new PageEvent(source, id);
            ((PageListener)listeners[i + 1]).pageEventFired(this._pageEvent);
        }
    }

    public void setAllowClosing(boolean allowClosing) {
        this._allowClosing = allowClosing;
    }

    public boolean allowClosing() {
        return this._allowClosing;
    }
}

