/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SimpleTimeZone
extends TimeZone {
    private static final int DOM_MODE = 1;
    private static final int DOW_IN_MONTH_MODE = 2;
    private static final int DOW_GE_DOM_MODE = 3;
    private static final int DOW_LE_DOM_MODE = 4;
    private static final byte[] monthArr = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final long serialVersionUID = -403250971215465050L;
    public static final int STANDARD_TIME = 1;
    public static final int WALL_TIME = 0;
    public static final int UTC_TIME = 2;
    private int rawOffset;
    private boolean useDaylight;
    private int dstSavings;
    private int startYear;
    private int startMode;
    private int startMonth;
    private int startDay;
    private int startDayOfWeek;
    private int startTime;
    private int startTimeMode;
    private int endMonth;
    private int endMode;
    private int endDay;
    private int endDayOfWeek;
    private int endTime;
    private int endTimeMode;
    private byte[] monthLength;
    private int serialVersionOnStream;

    public void setStartYear(int year) {
        this.startYear = year;
        this.useDaylight = true;
    }

    private final int checkRule(int month, int day, int dayOfWeek) {
        if (month < 0 || month > 11) {
            throw new IllegalArgumentException("month out of range");
        }
        int daysInMonth = this.getDaysInMonth(month, 1);
        if (dayOfWeek == 0) {
            if (day <= 0 || day > daysInMonth) {
                throw new IllegalArgumentException("day out of range");
            }
            return 1;
        }
        if (dayOfWeek > 0) {
            if (Math.abs(day) > (daysInMonth + 6) / 7) {
                throw new IllegalArgumentException("dayOfWeekInMonth out of range");
            }
            if (dayOfWeek > 7) {
                throw new IllegalArgumentException("dayOfWeek out of range");
            }
            return 2;
        }
        if (day == 0 || Math.abs(day) > daysInMonth) {
            throw new IllegalArgumentException("day out of range");
        }
        if (dayOfWeek < -7) {
            throw new IllegalArgumentException("dayOfWeek out of range");
        }
        if (day < 0) {
            return 4;
        }
        return 3;
    }

    public void setStartRule(int month, int day, int dayOfWeek, int time) {
        this.startMode = this.checkRule(month, day, dayOfWeek);
        this.startMonth = month;
        this.startDay = day;
        this.startDayOfWeek = Math.abs(dayOfWeek);
        this.startTime = this.startTimeMode == 0 || this.startTimeMode == 1 ? time : time + this.rawOffset;
        this.useDaylight = true;
    }

    public void setStartRule(int month, int day, int dayOfWeek, int time, boolean after) {
        this.startDay = after ? Math.abs(day) : -Math.abs(day);
        this.startDayOfWeek = after ? Math.abs(dayOfWeek) : -Math.abs(dayOfWeek);
        this.startMode = dayOfWeek != 0 ? 4 - after : this.checkRule(month, day, dayOfWeek);
        this.startDay = Math.abs(this.startDay);
        this.startDayOfWeek = Math.abs(this.startDayOfWeek);
        this.startMonth = month;
        this.startTime = this.startTimeMode == 0 || this.startTimeMode == 1 ? time : time + this.rawOffset;
        this.useDaylight = true;
    }

    public void setStartRule(int month, int day, int time) {
        this.setStartRule(month, day, 0, time);
    }

    public void setEndRule(int month, int day, int dayOfWeek, int time) {
        this.endMode = this.checkRule(month, day, dayOfWeek);
        this.endMonth = month;
        this.endDay = day;
        this.endDayOfWeek = Math.abs(dayOfWeek);
        this.endTime = this.endTimeMode == 0 ? time : (this.endTimeMode == 1 ? time + this.dstSavings : time + this.rawOffset + this.dstSavings);
        this.useDaylight = true;
    }

    public void setEndRule(int month, int day, int dayOfWeek, int time, boolean after) {
        this.endDay = after ? Math.abs(day) : -Math.abs(day);
        this.endDayOfWeek = after ? Math.abs(dayOfWeek) : -Math.abs(dayOfWeek);
        this.endMode = dayOfWeek != 0 ? 4 - after : this.checkRule(month, day, dayOfWeek);
        this.endDay = Math.abs(this.endDay);
        this.endDayOfWeek = Math.abs(this.endDayOfWeek);
        this.endMonth = month;
        this.endTime = this.endTimeMode == 0 ? time : (this.endTimeMode == 1 ? time + this.dstSavings : time + this.rawOffset + this.dstSavings);
        this.useDaylight = true;
    }

    public void setEndRule(int month, int day, int time) {
        this.setEndRule(month, day, 0, time);
    }

    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis) {
        int daysInMonth = this.getDaysInMonth(month, year);
        if (day < 1 || day > daysInMonth) {
            throw new IllegalArgumentException("day out of range");
        }
        if (dayOfWeek < 1 || dayOfWeek > 7) {
            throw new IllegalArgumentException("dayOfWeek out of range");
        }
        if (month < 0 || month > 11) {
            throw new IllegalArgumentException("month out of range:" + month);
        }
        int daylightSavings = 0;
        if (this.useDaylight && era == 1 && year >= this.startYear) {
            boolean afterStart = this.isBefore(year, month, day, dayOfWeek, millis, this.startMode, this.startMonth, this.startDay, this.startDayOfWeek, this.startTime) ^ true;
            boolean beforeEnd = this.isBefore(year, month, day, dayOfWeek, millis + this.dstSavings, this.endMode, this.endMonth, this.endDay, this.endDayOfWeek, this.endTime);
            if (this.startMonth < this.endMonth) {
                int n = 0;
                if (afterStart && beforeEnd) {
                    n = this.dstSavings;
                }
                daylightSavings = n;
            } else {
                int n = 0;
                if (beforeEnd || afterStart) {
                    n = this.dstSavings;
                }
                daylightSavings = n;
            }
        }
        return this.rawOffset + daylightSavings;
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public void setRawOffset(int rawOffset) {
        this.rawOffset = rawOffset;
    }

    public int getDSTSavings() {
        return this.dstSavings;
    }

    public void setDSTSavings(int dstSavings) {
        if (dstSavings <= 0) {
            throw new IllegalArgumentException("illegal value for dstSavings");
        }
        this.dstSavings = dstSavings;
    }

    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    private final int getDaysInMonth(int month, int year) {
        if (month == 1) {
            if ((year & 3) != 0) {
                return 28;
            }
            if (year < 1582) {
                return 29;
            }
            int n = 0;
            if (year % 100 != 0 || year % 400 == 0) {
                n = 1;
            }
            return n + 28;
        }
        return monthArr[month];
    }

    private final boolean isBefore(int calYear, int calMonth, int calDayOfMonth, int calDayOfWeek, int calMillis, int mode, int month, int day, int dayOfWeek, int millis) {
        if (calMonth != month) {
            boolean bl = false;
            if (calMonth < month) {
                bl = true;
            }
            return bl;
        }
        switch (mode) {
            case 1: {
                if (calDayOfMonth == day) break;
                boolean bl = false;
                if (calDayOfMonth < day) {
                    bl = true;
                }
                return bl;
            }
            case 2: {
                calDayOfMonth += dayOfWeek - calDayOfWeek;
                calDayOfMonth = day < 0 ? (calDayOfMonth -= this.getDaysInMonth(calMonth, calYear) + 7) : (calDayOfMonth += 6);
                int week = calDayOfMonth / 7;
                if (week != day) {
                    boolean bl = false;
                    if (week < day) {
                        bl = true;
                    }
                    return bl;
                }
                if (calDayOfWeek == dayOfWeek) break;
                boolean bl = false;
                if (calDayOfWeek < dayOfWeek) {
                    bl = true;
                }
                return bl;
            }
            case 4: {
                day = Math.abs(day) - 6;
            }
            case 3: {
                if ((calDayOfMonth -= (calDayOfWeek < dayOfWeek ? 7 : 0) + calDayOfWeek - dayOfWeek) < day) {
                    return true;
                }
                if (calDayOfWeek == dayOfWeek && calDayOfMonth < day + 7) break;
                return false;
            }
        }
        boolean bl = false;
        if (calMillis < millis) {
            bl = true;
        }
        return bl;
    }

    public boolean inDaylightTime(Date date) {
        Calendar cal = Calendar.getInstance(this);
        cal.setTime(date);
        boolean bl = false;
        if (cal.get(16) != 0) {
            bl = true;
        }
        return bl;
    }

    public synchronized int hashCode() {
        int n = 0;
        if (this.useDaylight) {
            n = this.startMonth ^ this.startDay ^ this.startDayOfWeek ^ this.startTime ^ this.endMonth ^ this.endDay ^ this.endDayOfWeek ^ this.endTime;
        }
        return this.rawOffset ^ n;
    }

    public synchronized boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone zone = (SimpleTimeZone)o;
        if (zone.hashCode() != this.hashCode() || !this.getID().equals(zone.getID()) || this.rawOffset != zone.rawOffset || this.useDaylight != zone.useDaylight) {
            return false;
        }
        if (!this.useDaylight) {
            return true;
        }
        boolean bl = false;
        if (this.startYear == zone.startYear && this.startMonth == zone.startMonth && this.startDay == zone.startDay && this.startDayOfWeek == zone.startDayOfWeek && this.startTime == zone.startTime && this.startTimeMode == zone.startTimeMode && this.endMonth == zone.endMonth && this.endDay == zone.endDay && this.endDayOfWeek == zone.endDayOfWeek && this.endTime == zone.endTime && this.endTimeMode == zone.endTimeMode) {
            bl = true;
        }
        return bl;
    }

    public boolean hasSameRules(TimeZone other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone zone = (SimpleTimeZone)other;
        if (zone.hashCode() != this.hashCode() || this.rawOffset != zone.rawOffset || this.useDaylight != zone.useDaylight) {
            return false;
        }
        if (!this.useDaylight) {
            return true;
        }
        boolean bl = false;
        if (this.startYear == zone.startYear && this.startMonth == zone.startMonth && this.startDay == zone.startDay && this.startDayOfWeek == zone.startDayOfWeek && this.startTime == zone.startTime && this.startTimeMode == zone.startTimeMode && this.endMonth == zone.endMonth && this.endDay == zone.endDay && this.endDayOfWeek == zone.endDayOfWeek && this.endTime == zone.endTime && this.endTimeMode == zone.endTimeMode) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        return this.getClass().getName() + "[id=" + this.getID() + ",offset=" + this.rawOffset + ",dstSavings=" + this.dstSavings + ",useDaylight=" + this.useDaylight + (this.useDaylight ? ",startYear=" + this.startYear + ",startMode=" + this.startMode + ",startMonth=" + this.startMonth + ",startDay=" + this.startDay + ",startDayOfWeek=" + this.startDayOfWeek + ",startTime=" + this.startTime + ",startTimeMode=" + this.startTimeMode + ",endMode=" + this.endMode + ",endMonth=" + this.endMonth + ",endDay=" + this.endDay + ",endDayOfWeek=" + this.endDayOfWeek + ",endTime=" + this.endTime + ",endTimeMode=" + this.endTimeMode : "") + ']';
    }

    private final void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        if (this.serialVersionOnStream == 0) {
            this.dstSavings = 3600000;
            this.endMode = 2;
            this.startMode = 2;
            this.startTimeMode = 0;
            this.endTimeMode = 0;
            this.serialVersionOnStream = 2;
        } else {
            int length = input.readInt();
            byte[] byteArray = new byte[length];
            input.read(byteArray, 0, length);
            if (length >= 4) {
                this.startDay = byteArray[0];
                this.startDayOfWeek = byteArray[1];
                this.endDay = byteArray[2];
                this.endDayOfWeek = byteArray[3];
            }
        }
    }

    private final void writeObject(ObjectOutputStream output) throws IOException {
        byte[] byteArray = new byte[]{(byte)this.startDay, (byte)this.startDayOfWeek, (byte)this.endDay, (byte)this.endDayOfWeek};
        switch (this.startMode) {
            case 1: {
                this.startDayOfWeek = 1;
            }
            case 3: 
            case 4: {
                this.startDay = (this.startDay + 6) / 7;
            }
        }
        switch (this.endMode) {
            case 1: {
                this.endDayOfWeek = 1;
            }
            case 3: 
            case 4: {
                this.endDay = (this.endDay + 6) / 7;
            }
        }
        output.defaultWriteObject();
        output.writeInt(byteArray.length);
        output.write(byteArray, 0, byteArray.length);
    }

    private final /* synthetic */ void this() {
        this.dstSavings = 3600000;
        this.startTimeMode = 0;
        this.endTimeMode = 0;
        this.monthLength = monthArr;
        this.serialVersionOnStream = 2;
    }

    public SimpleTimeZone(int rawOffset, String id) {
        this.this();
        this.rawOffset = rawOffset;
        this.setID(id);
        this.useDaylight = false;
        this.startYear = 0;
    }

    public SimpleTimeZone(int rawOffset, String id, int startMonth, int startDayOfWeekInMonth, int startDayOfWeek, int startTime, int endMonth, int endDayOfWeekInMonth, int endDayOfWeek, int endTime) {
        this.this();
        this.rawOffset = rawOffset;
        this.setID(id);
        this.useDaylight = true;
        this.setStartRule(startMonth, startDayOfWeekInMonth, startDayOfWeek, startTime);
        this.setEndRule(endMonth, endDayOfWeekInMonth, endDayOfWeek, endTime);
        if (startMonth == endMonth) {
            throw new IllegalArgumentException("startMonth and endMonth must be different");
        }
        this.startYear = 0;
    }

    public SimpleTimeZone(int rawOffset, String id, int startMonth, int startDayOfWeekInMonth, int startDayOfWeek, int startTime, int endMonth, int endDayOfWeekInMonth, int endDayOfWeek, int endTime, int dstSavings) {
        this(rawOffset, id, startMonth, startDayOfWeekInMonth, startDayOfWeek, startTime, endMonth, endDayOfWeekInMonth, endDayOfWeek, endTime);
        this.dstSavings = dstSavings;
    }

    public SimpleTimeZone(int rawOffset, String id, int startMonth, int startDayOfWeekInMonth, int startDayOfWeek, int startTime, int startTimeMode, int endMonth, int endDayOfWeekInMonth, int endDayOfWeek, int endTime, int endTimeMode, int dstSavings) {
        this.this();
        this.rawOffset = rawOffset;
        this.setID(id);
        this.useDaylight = true;
        if (startTimeMode < 0 || startTimeMode > 2) {
            throw new IllegalArgumentException("startTimeMode must be one of WALL_TIME, STANDARD_TIME, or UTC_TIME");
        }
        if (endTimeMode < 0 || endTimeMode > 2) {
            throw new IllegalArgumentException("endTimeMode must be one of WALL_TIME, STANDARD_TIME, or UTC_TIME");
        }
        this.startTimeMode = startTimeMode;
        this.endTimeMode = endTimeMode;
        this.setStartRule(startMonth, startDayOfWeekInMonth, startDayOfWeek, startTime);
        this.setEndRule(endMonth, endDayOfWeekInMonth, endDayOfWeek, endTime);
        if (startMonth == endMonth) {
            throw new IllegalArgumentException("startMonth and endMonth must be different");
        }
        this.startYear = 0;
        this.dstSavings = dstSavings;
    }
}

